/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.key.IPackKey;
import kd.fi.bcm.business.formula.model.value.ICollectResultHandle;
import kd.fi.bcm.business.formula.model.value.ICollectStableResultHandle;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.util.CollectCalculateHelp;

public class CollectCalculateService {
    private final ICalContext _ctx;
    private final CalculateService _cs;
    private Set<IPackKey> haveCalcKey = new HashSet<IPackKey>();
    private Map<String, Object> collectResultSet = new HashMap<String, Object>(16);
    private Map<String, Object> formula2result = new HashMap<String, Object>(16);
    private Map<String, Object> stableFormula2result = new HashMap<String, Object>(16);
    private Map<String, Integer> formulaKey2ParamIndex = new HashMap<String, Integer>(16);
    private ICollectResultHandle collectResultHandle = null;
    private IPackKey currPackKey;
    protected static Set<String> batchSupportFormulas = new HashSet<String>(16);
    private final Map<String, Pair<String, String>> tipLogMsg;

    public CollectCalculateService(ICalContext ctx) {
        this._ctx = ctx;
        this._cs = new CalculateService(ctx);
        batchSupportFormulas = DataCollectUtil.getCanBatchFormulaNums();
        this.tipLogMsg = new HashMap<String, Pair<String, String>>(16);
        this._ctx.setCollectResultHandle(new ICollectResultHandle(){

            @Override
            public void handle(Object collects, IPackKey dynaKey, IFormula formula, ICalContext ctx) {
                if (CollectCalculateService.this.collectResultHandle != null) {
                    CollectCalculateService.this.collectResultHandle.handle(collects, dynaKey, formula, ctx);
                }
            }

            @Override
            public void handle(IFormula formula, ICalContext ctx) {
                if (CollectCalculateService.this.currPackKey != null) {
                    this.handle(CollectCalculateService.this.formula2result.get(formula.toString()), CollectCalculateService.this.currPackKey, formula, ctx);
                }
            }
        });
        this._ctx.setCollectStableResultHandle(new ICollectStableResultHandle(){

            @Override
            public void handle(List<IFormula> formulaList) {
                for (IFormula formula : formulaList) {
                    CollectCalculateService.this.stableFormula2result.put(formula.toString(), formula.getValue());
                }
            }
        });
        this._ctx.setCheckFormulaHandle(new Predicate<IFormula>(){

            @Override
            public boolean test(IFormula formula) {
                if (CollectCalculateService.this.stableFormula2result.containsKey(formula.toString())) {
                    formula.setValue(CollectCalculateService.this.stableFormula2result.get(formula.toString()));
                    return true;
                }
                return false;
            }
        });
    }

    public CalculateService get_cs() {
        return this._cs;
    }

    public ExpressStatus addCollectCalculateExpress(String express) {
        return this._cs.addCalculateExpress(express);
    }

    public void calculateCollect() {
        this._ctx.setProperty("is_calc_collect", Boolean.TRUE);
        FormulaPoolManager allFpm = this._cs.getPoolMng();
        FormulaPoolManager calcFpm = new FormulaPoolManager();
        allFpm.forEach(f -> {
            if (batchSupportFormulas.contains(((String)f.getKey()).toLowerCase(Locale.ENGLISH)) || CollectCalculateHelp.batchSupportFormulas4bcm.contains(((String)f.getKey()).toLowerCase(Locale.ENGLISH))) {
                calcFpm.pushBatchFormula((List)f.getValue());
            }
        });
        this._cs.builtinBatchCalculate(calcFpm);
        calcFpm.forEach(e -> {
            Map<String, Object> resultMap = this._cs.getResultMap();
            for (IFormula f : (List)e.getValue()) {
                Object v = resultMap.get(f.getUUID());
                this.collectResultSet.put(f.getUUID(), v);
                this.formula2result.put(f.toString(), v);
                this.formulaKey2ParamIndex.put(f.getUUID(), f.getFloatParamIndex());
                String tip = f.getTipLogMsg();
                if (tip == null) continue;
                this.tipLogMsg.put(f.getKey(), (Pair<String, String>)new Pair((Object)f.toString(), (Object)tip));
            }
        });
        this._cs.clear();
        this._ctx.setProperty("is_calc_collect", Boolean.FALSE);
    }

    private void calculateSingleCollect() {
        this._ctx.setProperty("is_calc_collect_single", Boolean.TRUE);
        this._cs.batchCalculate();
        this._ctx.setProperty("is_calc_collect_single", Boolean.FALSE);
    }

    public <T> T evalExpress(ExpressStatus expr, IPackKey dynaKey, ICollectResultHandle collectResultHandle) {
        this.currPackKey = dynaKey;
        this.collectResultHandle = collectResultHandle;
        if (this.haveCalcKey.add(dynaKey)) {
            this.calculateSingleCollect();
        }
        return (T)(expr.hasException() ? expr.getException() : this._cs.getCalculateEngine().calculate(expr.getParseExpr()));
    }

    public void reset() {
        this._cs.clear();
    }

    public Map<String, Object> getCollectResultSet() {
        return this.collectResultSet;
    }

    public void setCollectResultSet(Map<String, Object> collectResultSet) {
        this.collectResultSet = collectResultSet;
    }

    public Map<String, Integer> getFormulaKey2ParamIndex() {
        return this.formulaKey2ParamIndex;
    }

    public void setFormulaKey2ParamIndex(Map<String, Integer> formulaKey2ParamIndex) {
        this.formulaKey2ParamIndex = formulaKey2ParamIndex;
    }

    public Map<String, Pair<String, String>> getTipLogMsg() {
        return this.tipLogMsg;
    }
}

