/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.convert.convertor.calculate.ICalculateContext;
import kd.fi.bcm.business.formula.model.value.IValue;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.fel.FelEngine;
import kd.fi.bcm.fel.common.FelBuilder;
import kd.fi.bcm.fel.context.AbstractContext;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.EvalException;

public class FelCalculateEngine {
    private ICalculateContext _ctx;
    private FelEngine bigfel;
    private static final DecimalFormat df = new DecimalFormat("0.0000");

    public FelEngine getBigfel() {
        return this.bigfel;
    }

    private FelCalculateEngine(ICalculateContext ctx) {
        this._ctx = ctx;
        this.bigfel = FelBuilder.bigNumberEngine((int)16);
        AbstractContext felctx = new AbstractContext(){

            /*
             * Enabled aggressive block sorting
             */
            public Object get(String name) {
                Object value;
                boolean isnull;
                block12: {
                    isnull = false;
                    IValue val = (IValue)FelCalculateEngine.this._ctx.get(name);
                    if (val.isNotExist()) {
                        value = name;
                    } else if (val.isNumber()) {
                        value = val.ofValue() instanceof BigDecimal ? (BigDecimal)val.ofValue() : new BigDecimal(FelCalculateEngine.formatNumberString(val.ofValue()));
                    } else if (val.isNull()) {
                        isnull = true;
                        value = BCMConstant.Zero;
                    } else {
                        if (val.isExcepton()) {
                            if (FelCalculateEngine.this._ctx.get("rptignorerror") != null) {
                                value = BCMConstant.Zero;
                                break block12;
                            } else {
                                if (val.ofValue() instanceof KDBizException) {
                                    throw (KDBizException)((Object)val.ofValue());
                                }
                                if (val.ofValue() instanceof EvalException) {
                                    throw (EvalException)val.ofValue();
                                }
                                throw new RuntimeException((Exception)val.ofValue());
                            }
                        }
                        value = val.ofValue();
                    }
                }
                if (!isnull) {
                    ThreadCache.remove((Object)"allnull");
                }
                return value;
            }
        };
        this.bigfel.setContext((FelContext)felctx);
    }

    public static String formatNumberString(Object v) {
        if (v instanceof Double) {
            return df.format((Double)v);
        }
        if (v instanceof Long) {
            return df.format((Long)v);
        }
        if (v instanceof Float) {
            return df.format((Float)v);
        }
        return v.toString();
    }

    public void resetFelContext(FelContext ctx) {
        this.bigfel.setContext(ctx);
    }

    public static FelCalculateEngine engine(ICalculateContext ctx) {
        return new FelCalculateEngine(ctx);
    }

    public Object calculate(String express) {
        try {
            String newExpress = express;
            if (newExpress.indexOf(61) > -1 && newExpress.indexOf(">=") < 0 && newExpress.indexOf("<=") < 0 && newExpress.indexOf("!=") < 0 && newExpress.indexOf("==") < 0) {
                newExpress = newExpress.replace("=", "==");
            }
            newExpress = newExpress.replace("<>", "!=");
            return this.bigfel.eval(newExpress);
        }
        catch (KDBizException | EvalException e1) {
            return e1;
        }
        catch (Exception e) {
            return new RuntimeException(e);
        }
    }
}

