/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.GetDimAttrFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class GetDimAttrCalculate
extends AbstractCalculate<GetDimAttrFormula> {
    private static final Map<String, String> ACCOUNTATTR = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("acctype", "accounttype");
            this.put("accdirect", "drcrdirect");
            this.put("accexrate", "exchange");
        }
    });
    private static final String SELECT_FIELDS_LONGNUMBER = "dpropertyid1.longnumber,dpropertyid2.longnumber,dpropertyid3.longnumber,dpropertyid4.longnumber,dpropertyid5.longnumber,dpropertyid6.longnumber,dpropertyid7.longnumber,dpropertyid8.longnumber,dpropertyid9.longnumber,dpropertyid10.longnumber";
    private static final List<String> ENTITYATTR = Arrays.asList("ec_code", "ec_name");

    @Override
    protected void execCalculate(List<GetDimAttrFormula> formulas) {
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this._ctx.getCubeNumber());
        if (formulas.isEmpty()) {
            return;
        }
        formulas.forEach(f -> {
            try {
                String dim = this.getParam((Formula)f, 0);
                String attrParam = this.getParam((Formula)f, 1);
                if (StringUtils.isNotEmpty((CharSequence)dim) && dim.contains(".")) {
                    String[] split = dim.split("\\.");
                    String dimNumber = (String)dimensionShortNumber2NumberMap.get(split[0]);
                    if (StringUtils.isEmpty((CharSequence)dimNumber)) {
                        f.setExceptionMsg(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"GetDimAttrCalculate_01", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
                    }
                    if (ENTITYATTR.contains(attrParam.toLowerCase(Locale.ENGLISH))) {
                        this.getEntityAttrCal(dimensionShortNumber2NumberMap, (GetDimAttrFormula)f, split[0], split[1], attrParam);
                    } else if (ACCOUNTATTR.containsKey(attrParam.toLowerCase(Locale.ENGLISH))) {
                        this.getAccountAttrCal((GetDimAttrFormula)f, split[0], split[1], attrParam);
                    } else {
                        this.getDefinedAttrCal(dimensionShortNumber2NumberMap, (GetDimAttrFormula)f, split[0], split[1], attrParam);
                    }
                    return;
                }
                String dimNumber = (String)dimensionShortNumber2NumberMap.get(dim);
                Optional<Map<String, String>> dim2MemMap = Optional.ofNullable(f.getDim2MemMap());
                if (!dim2MemMap.isPresent()) {
                    f.setExceptionMsg(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"GetDimAttrCalculate_01", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
                    return;
                }
                String memberStr = dim2MemMap.get().get(dimNumber);
                if (ENTITYATTR.contains(attrParam.toLowerCase(Locale.ENGLISH))) {
                    this.getEntityAttrCal(dimensionShortNumber2NumberMap, (GetDimAttrFormula)f, dim, memberStr, attrParam);
                } else if (ACCOUNTATTR.containsKey(attrParam.toLowerCase(Locale.ENGLISH))) {
                    this.getAccountAttrCal((GetDimAttrFormula)f, dim, memberStr, attrParam);
                } else {
                    this.getDefinedAttrCal(dimensionShortNumber2NumberMap, (GetDimAttrFormula)f, dim, memberStr, attrParam);
                }
            }
            catch (Exception e) {
                f.setExceptionMsg(e.getMessage());
            }
        });
    }

    private void getEntityAttrCal(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr, String attrParam) {
        if (f.getColRowDim() != null) {
            this.getEntityAttrByCell(dimensionShortNumber2NumberMap, f, dim, attrParam);
        } else {
            this.getEntityAttr(dimensionShortNumber2NumberMap, f, dim, memberStr, attrParam);
        }
    }

    private void getAccountAttrCal(GetDimAttrFormula f, String dim, String memberStr, String attrParam) {
        if (f.getColRowDim() != null) {
            this.getAccountAttrByCell(f, dim, attrParam);
        } else {
            this.getAccountAttr(f, dim, memberStr, ACCOUNTATTR.get(attrParam.toLowerCase(Locale.ENGLISH)));
        }
    }

    private void getDefinedAttrCal(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr, String attrParam) {
        if (f.getColRowDim() != null) {
            this.getDefinedPropertyBycell(dimensionShortNumber2NumberMap, f, dim, attrParam);
        } else {
            this.getDefinedProperty(dimensionShortNumber2NumberMap, f, dim, memberStr, attrParam);
        }
    }

    private void getAccountAttrByCell(GetDimAttrFormula f, String cellValue, String attrParam) {
        for (String value : f.getColRowDim().values()) {
            if (cellValue.indexOf(value) == -1) continue;
            this.getAccountAttr(f, f.getColRowDim().get("dimNum"), f.getColRowDim().get("dimMemNum"), ACCOUNTATTR.get(attrParam.toLowerCase(Locale.ENGLISH)));
            break;
        }
    }

    private void getEcName(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)dimensionShortNumber2NumberMap.get(dim), (String)memberStr);
        if (node == IDNumberTreeNode.NotFoundTreeNode) {
            f.setExceptionMsg(String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"GetDimAttrCalculate_02", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
            return;
        }
        IDNumberTreeNode currencyMemberByNum = MemberReader.findCurrencyMemberByNum((String)this._ctx.getCubeNumber(), (String)node.getCurrency());
        f.setValue(currencyMemberByNum.getName());
    }

    private void getEntityAttr(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr, String attrParam) {
        if (dim.equals(DimTypesEnum.ENTITY.getShortNumber())) {
            if ("EC_Code".equalsIgnoreCase(attrParam)) {
                this.getEcCode(dimensionShortNumber2NumberMap, f, dim, memberStr);
            } else if ("EC_Name".equalsIgnoreCase(attrParam)) {
                this.getEcName(dimensionShortNumber2NumberMap, f, dim, memberStr);
            }
        }
    }

    private void getEntityAttrByCell(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String cellValue, String attrParam) {
        for (String value : f.getColRowDim().values()) {
            if (cellValue.indexOf(value) == -1) continue;
            this.getEntityAttr(dimensionShortNumber2NumberMap, f, f.getColRowDim().get("dimNum"), f.getColRowDim().get("dimMemNum"), attrParam);
            break;
        }
    }

    private void getEcCode(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)dimensionShortNumber2NumberMap.get(dim), (String)memberStr);
        if (node == IDNumberTreeNode.NotFoundTreeNode) {
            f.setExceptionMsg(String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"GetDimAttrCalculate_02", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
            return;
        }
        f.setValue(node.getCurrency());
    }

    private void getDefinedProperty(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String memberStr, String attrParam) {
        DynamicObject attrDy;
        DynamicObject dproPropert = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_definedpropertyvalue", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)attrParam).and("model.number", "=", (Object)this._ctx.getCubeNumber()).and("dimension.number", "=", (Object)dimensionShortNumber2NumberMap.get(dim))});
        if (dproPropert != null && (attrDy = BusinessDataServiceHelper.loadSingleFromCache((String)MemberReader.getEntityNumberByDim((String)this._ctx.getCubeNumber(), (String)dimensionShortNumber2NumberMap.get(dim)), (String)SELECT_FIELDS_LONGNUMBER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)memberStr).and("model.number", "=", (Object)this._ctx.getCubeNumber()).and("dimension.number", "=", (Object)dimensionShortNumber2NumberMap.get(dim))})) != null) {
            for (int i = 1; i <= 10; ++i) {
                List<String> numbers;
                String longNumber = attrDy.getString("dpropertyid" + i + ".longnumber");
                if (!StringUtils.isNotEmpty((CharSequence)longNumber) || !(numbers = Arrays.asList(longNumber.split("!"))).contains(attrParam)) continue;
                f.setValue(attrDy.getString("dpropertyid" + i + ".name"));
                break;
            }
        }
    }

    private void getDefinedPropertyBycell(Map<String, String> dimensionShortNumber2NumberMap, GetDimAttrFormula f, String dim, String attrParam) {
        for (String value : f.getColRowDim().values()) {
            if (dim.indexOf(value) == -1) continue;
            this.getDefinedProperty(dimensionShortNumber2NumberMap, f, f.getColRowDim().get("dimNum"), f.getColRowDim().get("dimMemNum"), attrParam);
            break;
        }
    }

    private void getAccountAttr(GetDimAttrFormula f, String dim, String memberStr, String attr) {
        DynamicObject account;
        if (dim.equals(DimTypesEnum.ACCOUNT.getShortNumber()) && (account = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_accountmembertree", (String)"drcrdirect, accounttype, exchange", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)memberStr)})) != null) {
            if (attr.equalsIgnoreCase("accounttype")) {
                f.setValue(AccountTypeEnum.getEnum((String)account.getString(attr)).getName());
            } else if (attr.equalsIgnoreCase("drcrdirect")) {
                f.setValue(DrCRDirectEnum.getDrCRDirectEnum((String)account.getString(attr)).getName());
            } else if (attr.equalsIgnoreCase("exchange")) {
                f.setValue(ExchangeEnum.getExchangeEnumByIndex((String)account.getString(attr)).getName());
            }
        }
    }

    @Override
    protected void initFormula() {
    }

    private String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }
}

