/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.formula.rptformula.RptDateFormula;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class NewRptInfoCalculate
extends ExcelFormulaCalculate {
    @Override
    protected void calculateFormula(IFormula f) {
        ParamList pl = f.getParamList();
        if (pl.size() != 3) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"newrptinfo\u51fd\u6570\u53ea\u80fd\u67093\u4e2a\u53c2\u6570\uff0c\u4f46\u5f53\u524d\u8bbe\u7f6e\u4e86%1$s\u4e2a\u3002", (String)"NewRptInfoCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), pl.size()))));
            return;
        }
        Object p1 = ((ParamItem)pl.get(1)).getParam();
        String result = "";
        switch (p1.toString().trim().replace("\"", "")) {
            case "entity.name": {
                result = this.getEntityName();
                break;
            }
            case "modifytime": {
                result = this.getModifyTime(f, pl);
                if (result != null) break;
                return;
            }
            case "template.data": {
                result = this.covertNumberToName();
                break;
            }
            case "currency.number": {
                result = this._ctx.getCurrency();
                break;
            }
            case "currency.name": {
                result = MemberReader.findCurrencyMemberByNum((String)this._ctx.getCubeNumber(), (String)this._ctx.getCurrency()).getName();
                break;
            }
            case "entity.number": {
                result = this._ctx.getOrg();
                break;
            }
            case "modifyname": {
                result = this.getModifyName();
            }
        }
        if (StringUtils.isNotEmpty((String)result)) {
            result = ((ParamItem)pl.get(0)).toString() + result.replace("\"", "");
            f.setValue(result);
        }
    }

    private String getModifyTime(IFormula f, ParamList pl) {
        this.setPeriod();
        int expmonth = (Integer)this._ctx.getProperty("expmonth");
        int expday = (Integer)this._ctx.getProperty("expday");
        int lastDay = this.getLastday(expmonth, expday);
        int n = expday = expday < lastDay ? expday : lastDay;
        if (expmonth == 0 && expday == 0) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u53d6\u5230\u671f\u95f4\u53c2\u6570\uff08%1$s\uff09\u4e0d\u5408\u6cd5", (String)"NewRptInfoCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getPeriod()))));
            return null;
        }
        Object dateFormat = ((ParamItem)pl.get(2)).getParam();
        String result = dateFormat.toString();
        if (dateFormat.toString().contains("YYYY")) {
            result = dateFormat.toString().replace("YYYY", this._ctx.getYear().replace("FY", ""));
        } else if (dateFormat.toString().contains("yyyy")) {
            result = dateFormat.toString().replace("yyyy", this._ctx.getYear().replace("FY", ""));
        }
        if (dateFormat.toString().contains("MM")) {
            result = result.replace("MM", expmonth < 10 ? "0" + expmonth : Integer.toString(expmonth));
        }
        if (dateFormat.toString().contains("Q") && expmonth != 0) {
            int periodNum = 0;
            int n2 = periodNum = expmonth > 12 ? 4 : (int)Math.ceil((double)expmonth / 3.0);
            if (this._ctx.getPeriod().contains("Q_Q")) {
                periodNum = Integer.parseInt(this._ctx.getPeriod().replace("Q_Q", "").trim());
            }
            result = result.replace("Q", periodNum < 10 ? "0" + periodNum : Integer.toString(periodNum));
        }
        if (dateFormat.toString().contains("DD")) {
            result = result.replace("DD", expday < 10 ? "0" + expday : Integer.toString(expday));
        }
        return result;
    }

    private String getEntityName() {
        Long scenarioId = 0L;
        if (this._ctx.getProperty("scenarioId") == null) {
            scenarioId = MemberReader.findScenaMemberByNum((String)this._ctx.getCubeNumber(), (String)this._ctx.getScenario()).getId();
            this._ctx.setProperty("scenarioId", scenarioId);
        } else {
            scenarioId = (Long)this._ctx.getProperty("scenarioId");
        }
        Map<String, String> names = EntityVersioningUtil.getOrgNameByFYAndPeriod(this._ctx.getCubeNumber(), new ArrayList<String>(Collections.singletonList(this._ctx.getOrg())), this._ctx.getYear(), this._ctx.getPeriod(), scenarioId);
        String result = names.get(this._ctx.getOrg());
        return result;
    }

    private String covertNumberToName() {
        IDNumberTreeNode memberByNum = MemberReader.findCurrencyMemberByNum((String)this._ctx.getCubeNumber(), (String)this._ctx.getCurrency());
        String curname = memberByNum.getName();
        if (ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"NewRptInfoCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]).equals(curname)) {
            curname = ResManager.loadKDString((String)"\u5143", (String)"NewRptInfoCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return curname;
    }

    private Integer getLastday(int expmonth, int expday) {
        return RptDateFormula.getLastDay(Integer.parseInt(this._ctx.getYear().replace("FY", "")), expmonth - 1, expday);
    }

    private void setPeriod() {
        if (this._ctx.getProperty("expmonth") == null || this._ctx.getProperty("expday") == null) {
            QFilter modelFilter = new QFilter("model.number", "=", (Object)this._ctx.getCubeNumber());
            QFilter numberFilter = new QFilter("number", "=", (Object)this._ctx.getPeriod());
            DynamicObject periodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, expday, expmonth", (QFilter[])new QFilter[]{numberFilter, modelFilter});
            this._ctx.setProperty("expmonth", periodDy.getInt("expmonth"));
            this._ctx.setProperty("expday", periodDy.getInt("expday"));
        }
    }

    private String getModifyName() {
        QFilter qf = QFilter.of((String)"fyear.number=? and period.number=? and scene.number=? and entity.number=? and template =? and currency.number =?", (Object[])new Object[]{this._ctx.getYear(), this._ctx.getPeriod(), this._ctx.getScenario(), this._ctx.getOrg(), this._ctx.getProperty("templateId"), this._ctx.getCurrency()});
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((String)"bcm_reportentity", (String)"modifier.name", (QFilter[])qf.toArray());
        String name = " ";
        name = doc == null ? (this._ctx.getProperty("intrModifyName") != null ? (String)this._ctx.getProperty("intrModifyName") : RequestContext.get().getUserName()) : doc.getString("modifier.name");
        this._ctx.setProperty("modifier", name);
        return name;
    }
}

