/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.PeriodFormula;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;

public class PeriodCalculate
extends ExcelFormulaCalculate {
    private static final String RPT = "rpt";
    private static final String CELL = "cell";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    @Override
    protected void calculateFormula(IFormula f) {
        ParamList pl = f.getParamList();
        if (pl.size() != 2) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"period\u51fd\u6570\u53ea\u80fd\u67092\u4e2a\u53c2\u6570\uff0c\u4f46\u5f53\u524d\u8bbe\u7f6e\u4e86%s\u4e2a\u3002", (String)"PeriodCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), pl.size()))));
            return;
        }
        String type = SpecialCalLogic.getParam(f, "", 0);
        String show = SpecialCalLogic.getParam(f, "", 1);
        if (RPT.equalsIgnoreCase(type)) {
            if (NAME.equals(show)) {
                String periodName = (String)this._ctx.getProperty("periodName");
                if (StringUtils.isEmpty((String)periodName)) {
                    String rptMonth = ((PeriodFormula)f).getRptMonth();
                    periodName = MemberReader.findPeriodMemberByNum((String)this._ctx.getCubeNumber(), (String)rptMonth).getName();
                    f.setValue(periodName);
                    this._ctx.setProperty("periodName", periodName);
                } else {
                    f.setValue(periodName);
                }
            } else if (NUMBER.equalsIgnoreCase(show)) {
                f.setValue(this._ctx.getPeriod());
            } else {
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"period\u51fd\u6570\u53ea\u80fd\u663e\u793anumber\u6216\u8005name\u3002", (String)"PeriodCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]))));
            }
        } else if (CELL.equalsIgnoreCase(type)) {
            String cellMonth = ((PeriodFormula)f).getCellMonth();
            if (NAME.equals(show)) {
                String periodName = MemberReader.findPeriodMemberByNum((String)this._ctx.getCubeNumber(), (String)cellMonth).getName();
                f.setValue(periodName);
            } else if (NUMBER.equalsIgnoreCase(show)) {
                f.setValue(cellMonth);
            } else {
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"period\u51fd\u6570\u53ea\u80fd\u663e\u793anumber\u6216\u8005name\u3002", (String)"PeriodCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]))));
            }
        }
    }
}

