/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.RefFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.util.VirtualCurrencyUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections.CollectionUtils;

public class RefCalculate
extends AbstractCalculate<RefFormula> {
    @Override
    protected void execCalculate(List<RefFormula> formulas) {
        HashMap map = new HashMap();
        Set noPermOrgs = (Set)this._ctx.getProperty("noPermOrgs");
        Set rateOrgs = (Set)this._ctx.getProperty("rateOrgs");
        for (RefFormula refFormula : formulas) {
            ParamList paramList = refFormula.getParamList();
            RptEntity rptEntity = new RptEntity(this.getFromCxt(0, paramList), this.getFromCxt(1, paramList), this.getFromCxt(2, paramList), this.getFromCxt(3, paramList), this.getFromCxt(4, paramList), this.getFromCxt(5, paramList), this._ctx.getCubeNumber());
            String org = this.getFromCxt(0, paramList);
            if ((CollectionUtils.isEmpty((Collection)rateOrgs) || !rateOrgs.contains(org)) && CollectionUtils.isNotEmpty((Collection)noPermOrgs) && noPermOrgs.contains(org)) {
                refFormula.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u4ece\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u6570\u636e\u3002", (String)"RefCalculate_5", (String)"fi-bcm-business", (Object[])new Object[0]), org + "|" + MemberReader.findEntityMemberByNum((String)this._ctx.getCubeNumber(), (String)org).getName()))));
                continue;
            }
            String position = this.getFromCxt(6, paramList);
            if (position == null) continue;
            if (position.contains("$")) {
                position = position.replace("$", "");
            }
            position = position.trim();
            Point point = ExcelUtils.pos2Point((String)position);
            CellInfo cell = new CellInfo(point.y, point.x);
            Map cellListMap = (Map)map.get(rptEntity);
            if (cellListMap == null) {
                HashMap<CellInfo, List> newCellListMap = new HashMap<CellInfo, List>();
                newCellListMap.computeIfAbsent(cell, k -> new ArrayList()).add(refFormula);
                map.put(rptEntity, newCellListMap);
                continue;
            }
            cellListMap.computeIfAbsent(cell, k -> new ArrayList()).add(refFormula);
        }
        for (Map.Entry entry : map.entrySet()) {
            RptEntity key = (RptEntity)entry.getKey();
            Map value = (Map)entry.getValue();
            try {
                DataSet report = this.getReport(key);
                Object object = null;
                try {
                    Boolean hasNormalReportTyp = false;
                    while (report.hasNext()) {
                        Row row = report.next();
                        if (!this.isNormalReporttype(row)) continue;
                        hasNormalReportTyp = true;
                        String data = row.getString("data");
                        String reportNum = row.getString("template.number");
                        KDBizException msg = new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\u7f3a\u5c11\u6a21\u578b\u6570\u636e\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e", (String)"RefCalculate_6", (String)"fi-bcm-business", (Object[])new Object[0]), reportNum));
                        if (StringUtils.isEmpty((CharSequence)data)) {
                            for (List refFormulas : value.values()) {
                                for (RefFormula refFormula : refFormulas) {
                                    refFormula.setException((Exception)((Object)msg));
                                }
                            }
                            break;
                        }
                        Class<?> clazz = Class.forName("kd.fi.bcm.spread.util.RefCalculateUtils");
                        Method initRpt = clazz.getMethod("initRpt", Map.class, String.class);
                        initRpt.invoke(null, value, data);
                        break;
                    }
                    if (hasNormalReportTyp.booleanValue()) continue;
                    for (List cv : value.values()) {
                        cv.forEach(e -> {
                            String fromCxt = this.getFromCxt(5, e.getParamList());
                            e.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u62a5\u8868\u672a\u7f16\u5236\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u3002", (String)"RefCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), fromCxt))));
                        });
                    }
                }
                catch (Throwable hasNormalReportTyp) {
                    object = hasNormalReportTyp;
                    throw hasNormalReportTyp;
                }
                finally {
                    if (report == null) continue;
                    if (object != null) {
                        try {
                            report.close();
                        }
                        catch (Throwable hasNormalReportTyp) {
                            ((Throwable)object).addSuppressed(hasNormalReportTyp);
                        }
                        continue;
                    }
                    report.close();
                }
            }
            catch (Exception e2) {
                this.log.error((Throwable)e2);
                for (List cv : value.values()) {
                    cv.forEach(formula -> formula.setException((Exception)((Object)new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e2, (int)10)))));
                }
            }
        }
    }

    private boolean isNormalReporttype(Row row) {
        return !ReportType.CSTE.index.equals(row.getString("reporttype"));
    }

    private DataSet getReport(RptEntity key) {
        QFBuilder qf = new QFBuilder();
        qf.add("entity", "=", (Object)MemberReader.findEntityMemberByNum((String)key.modelNumber, (String)key.entityNumber).getId());
        qf.add("scene", "=", (Object)MemberReader.findScenaMemberByNum((String)key.modelNumber, (String)key.sceneNumber).getId());
        qf.add("fyear", "=", (Object)MemberReader.findFyMemberByNum((String)key.modelNumber, (String)key.fyearNumber).getId());
        qf.add("period", "=", (Object)MemberReader.findPeriodMemberByNum((String)key.modelNumber, (String)key.periodNumber).getId());
        qf.add("currency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)key.modelNumber, (String)key.currencyNumber).getId());
        qf.add("template.number", "=", (Object)key.templateNumber);
        qf.add("model", "=", (Object)MemberReader.findModelIdByNum((String)key.modelNumber));
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_reportentity", (String)"data,reporttype, template.number", (QFilter[])qf.toArray(), null, (int)1);
    }

    private int getCol(String s) {
        char[] chars;
        int val = 0;
        for (char aChar : chars = s.toLowerCase(Locale.ENGLISH).toCharArray()) {
            val = val * 27 + (aChar - 97 + 1);
        }
        return val;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void initFormula() {
        Iterator iterator = this.originalFormulas.iterator();
        while (true) {
            ParamList paramList;
            block24: {
                ParamItem yearItem;
                RefFormula formula;
                block23: {
                    String msg;
                    if (!iterator.hasNext()) {
                        return;
                    }
                    formula = (RefFormula)iterator.next();
                    paramList = formula.getParamList();
                    String tem = this.getFromCxt(5, paramList);
                    String pos = this.getFromCxt(6, paramList);
                    if (pos == null) {
                        msg = ResManager.loadKDString((String)"\u5355\u5143\u683c\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]);
                        formula.setException(new IllegalArgumentException(msg));
                    } else {
                        if (pos.contains("$")) {
                            pos = pos.replace("$", "");
                        }
                        try {
                            ExcelUtils.pos2Point((String)pos.trim());
                        }
                        catch (Exception e) {
                            formula.setException(e);
                            continue;
                        }
                    }
                    if (tem == null) {
                        msg = ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]);
                        formula.setException(new IllegalArgumentException(msg));
                        continue;
                    }
                    yearItem = (ParamItem)paramList.get(2);
                    String year = " ";
                    if (yearItem.getParam() instanceof StringExpr) {
                        year = ((StringExpr)yearItem.getParam()).getValue();
                    } else if (yearItem.getParam() != null) {
                        year = yearItem.getParam().toString();
                    }
                    if (StringUtils.isNotEmpty((CharSequence)year)) {
                        Optional s = PeriodUtils.trans2SpecificFy((String)this._ctx.getCubeNumber(), (String)this._ctx.getYear(), (String)year);
                        s.ifPresent(x -> yearItem.fixParam(new StringExpr(x)));
                        if (s.isPresent()) {
                            yearItem.fixParam(new StringExpr((String)s.get()));
                            break block23;
                        } else {
                            formula.setException(new IllegalArgumentException(ResManager.loadKDString((String)"\u8d22\u5e74\u6570\u636e\u83b7\u53d6\u5931\u8d25\u3002", (String)"RefCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0])));
                            continue;
                        }
                    }
                    String yearNum = this.getFromCxt(2, paramList);
                    yearItem.fixParam(new StringExpr(yearNum));
                }
                ParamItem periodItem = (ParamItem)paramList.get(3);
                String period = " ";
                if (periodItem.getParam() instanceof StringExpr) {
                    period = ((StringExpr)periodItem.getParam()).getValue();
                } else if (periodItem.getParam() != null) {
                    period = periodItem.getParam().toString();
                }
                if (StringUtils.isNotEmpty((CharSequence)period)) {
                    if ("LastPeriod".equals(period)) {
                        String yearNum = ((StringExpr)yearItem.getParam()).getValue();
                        String[] str = PeriodUtils.getLastPeriodIncludeYear((String)this._ctx.getCubeNumber(), (String)yearNum, (String)this._ctx.getPeriod(), (boolean)true);
                        if (str[0] != null && str[1] != null) {
                            yearItem.fixParam(new StringExpr(str[0]));
                            periodItem.fixParam(new StringExpr(str[1]));
                            break block24;
                        } else {
                            formula.setException(new IllegalArgumentException(ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u95f4\u6570\u636e\u5931\u8d25\u3002", (String)"RefCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0])));
                            continue;
                        }
                    }
                    Optional s = PeriodUtils.trans2SpecificPeriod((String)this._ctx.getCubeNumber(), (String)this._ctx.getPeriod(), (String)period, (boolean)true);
                    if (s.isPresent()) {
                        periodItem.fixParam(new StringExpr((String)s.get()));
                    } else {
                        formula.setException(new IllegalArgumentException(ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u95f4\u6570\u636e\u5931\u8d25\u3002", (String)"RefCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0])));
                        continue;
                    }
                }
            }
            ParamItem currencyItem = (ParamItem)paramList.get(4);
            String currency = " ";
            currency = currencyItem.getParam() instanceof StringExpr ? ((StringExpr)currencyItem.getParam()).getValue() : currencyItem.getParam().toString();
            if (!"EC".equals(currency)) continue;
            String ecNumber = VirtualCurrencyUtil.getECNumber(this._ctx.getCubeNumber(), this.getFromCxt(0, paramList), this.getFromCxt(2, paramList), this.getFromCxt(3, paramList));
            currencyItem.fixParam(new StringExpr(ecNumber));
        }
    }

    private String getFromCxt(int idx, ParamList paramList) {
        ParamItem paramItem = (ParamItem)paramList.get(idx);
        String param = " ";
        param = paramItem.getParam() instanceof StringExpr ? ((StringExpr)paramItem.getParam()).getValue() : paramItem.getParam().toString();
        if (!StringUtils.isEmpty((CharSequence)param)) {
            return param;
        }
        switch (idx) {
            case 0: {
                return this._ctx.getOrg();
            }
            case 1: {
                return this._ctx.getScenario();
            }
            case 2: {
                return this._ctx.getYear();
            }
            case 3: {
                return this._ctx.getPeriod();
            }
            case 4: {
                return this._ctx.getCurrency();
            }
        }
        return null;
    }

    private static class RptEntity {
        private String entityNumber;
        private String sceneNumber;
        private String fyearNumber;
        private String periodNumber;
        private String currencyNumber;
        private String templateNumber;
        private String modelNumber;

        private RptEntity(String entity, String scene, String fyear, String period, String currency, String template, String model) {
            this.entityNumber = entity;
            this.sceneNumber = scene;
            this.fyearNumber = fyear;
            this.periodNumber = period;
            this.currencyNumber = currency;
            this.templateNumber = template;
            this.modelNumber = model;
        }

        public int hashCode() {
            int hash = this.entityNumber.hashCode();
            hash += 31 * this.sceneNumber.hashCode();
            hash += 31 * this.fyearNumber.hashCode();
            hash += 31 * this.periodNumber.hashCode();
            hash += 31 * this.currencyNumber.hashCode();
            return hash += 31 * this.templateNumber.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RptEntity) {
                RptEntity rpt = (RptEntity)obj;
                return rpt.templateNumber.equals(this.templateNumber) && rpt.periodNumber.equals(this.periodNumber) && rpt.sceneNumber.equals(this.sceneNumber) && rpt.currencyNumber.equals(this.currencyNumber) && rpt.fyearNumber.equals(this.fyearNumber) && rpt.entityNumber.equals(this.entityNumber) && rpt.modelNumber.equals(this.modelNumber);
            }
            return false;
        }
    }

    public static class CellInfo {
        public final int row;
        public final int col;

        private CellInfo(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int hashCode() {
            return Integer.hashCode(this.row) + 31 * Integer.hashCode(this.col);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CellInfo) {
                CellInfo c = (CellInfo)obj;
                return c.col == this.col && c.row == this.row;
            }
            return false;
        }
    }
}

