/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.ExcRateFormula;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class VCalculate
extends AbstractCalculate<VFormula> {
    protected Map<String, String> dimNumMap = new HashMap<String, String>(16);
    private Map<String, Integer> dimOrderMap = new HashMap<String, Integer>(16);
    protected List<String> userDefinedDim = new ArrayList<String>(10);
    private boolean hasMC = false;

    @Override
    protected void initFormula() {
        this.initDimNumMap();
        this.handleDefaultParamVal();
        this.checkMemberIsExit();
        this.checkOrgPerm();
        this.originalFormulas.forEach(f -> {
            if (!f.hasException() && f.getParamList().size() != this.dimNumMap.size()) {
                List<String> dims = ChkCheckServiceHelper.compareDim(f.getParamList(), this.dimNumMap);
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u7f3a\u5931\u7ef4\u5ea6\u201c%1$s\u201d\u3002", (String)"VCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), dims))));
                this.log.error(String.format("V_initFormula() error:%s is empty", dims), (Throwable)f.getException());
            }
        });
        if (!this._ctx.getConvertParam().isEmpty()) {
            this._ctx.getConvertParam().forEach((k, t) -> {
                Set<String> errmsgSet = ConvertServiceHelper.convert4ProcessSpilt(this._ctx.getModelId(), this._ctx.getScenario(), this._ctx.getYear(), this._ctx.getPeriod(), (String)t.p1, (String)t.p2, (String)t.p3, true);
                if (!CollectionUtil.isEmpty(errmsgSet)) {
                    this.originalFormulas.stream().filter(f -> k.equals(this.getConvertKey((VFormula)f))).forEach(f -> f.setExceptionMsg(errmsgSet.toString()));
                }
            });
        }
    }

    private String getConvertKey(VFormula f) {
        String entityNum = "";
        String processNum = "";
        String currencyNum = "";
        for (ParamItem p : f.getParamList()) {
            String[] strArr = this.splitStr(p.toString());
            if (DimTypesEnum.ENTITY.getShortNumber().equals(strArr[0])) {
                entityNum = strArr[1];
                continue;
            }
            if (DimTypesEnum.PROCESS.getShortNumber().equals(strArr[0])) {
                processNum = strArr[1];
                continue;
            }
            if (!DimTypesEnum.CURRENCY.getShortNumber().equals(strArr[0])) continue;
            currencyNum = strArr[1];
        }
        return String.join((CharSequence)",", entityNum, processNum, currencyNum);
    }

    private void checkOrgPerm() {
        Object needCheckPerm;
        HashSet<String> noPermOrgs = new HashSet<String>(16);
        if (this._ctx.getProperty("noPermOrgs") instanceof Set) {
            noPermOrgs.addAll((Collection)this._ctx.getProperty("noPermOrgs"));
        }
        HashSet rateOrgs = new HashSet(16);
        if (this._ctx.getProperty("rateOrgs") instanceof Set) {
            rateOrgs.addAll((Collection)this._ctx.getProperty("rateOrgs"));
        }
        if ((needCheckPerm = this._ctx.getProperty("needCheckPerm")) instanceof Boolean && ((Boolean)needCheckPerm).booleanValue()) {
            Set rateOrgsCache;
            String cubeNumber = this._ctx.getCubeNumber();
            Long modelId = MemberReader.findModelIdByNum((String)cubeNumber);
            Set<String> noPermOrgsCache = DataCollectUtil.getNotPermNumsCache(modelId, "Entity");
            if (CollectionUtils.isNotEmpty(noPermOrgsCache)) {
                noPermOrgs.addAll(noPermOrgsCache);
            }
            if (CollectionUtils.isNotEmpty((Collection)(rateOrgsCache = (Set)ThreadCache.get((Object)"rateOrgs", () -> MemberReader.getAllNodeByDimNum((String)"Entity", (String)cubeNumber).stream().map(e -> {
                if (e.getLongNumber().contains("RateEntity")) {
                    return e.getNumber();
                }
                return null;
            }).collect(Collectors.toSet()))))) {
                rateOrgs.addAll(rateOrgsCache);
            }
        }
        if (CollectionUtils.isNotEmpty(noPermOrgs)) {
            this.originalFormulas.forEach(f -> {
                if (f.hasException()) {
                    return;
                }
                f.getParamList().forEach(p -> {
                    String[] strArr = this.splitStr(p.toString());
                    if (DimTypesEnum.ENTITY.getShortNumber().equals(strArr[0])) {
                        String orgNum = strArr[1];
                        if (orgNum.contains("_")) {
                            String[] parent2org = orgNum.split("_");
                            orgNum = parent2org[1];
                        }
                        if ((CollectionUtils.isEmpty((Collection)rateOrgs) || !rateOrgs.contains(orgNum)) && noPermOrgs.contains(orgNum)) {
                            f.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u4ece\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u6570\u636e\u3002", (String)"VCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), strArr[1] + "|" + MemberReader.findEntityMemberByNum((String)this._ctx.getCubeNumber(), (String)orgNum).getName()))));
                        }
                    }
                });
            });
        }
    }

    private void checkMemberIsExit() {
        for (Formula f : this.originalFormulas) {
            Formula cachedFormula;
            if (f.hasException() || !(cachedFormula = (Formula)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)("checkMemberIsExit" + this._ctx.getCubeNumber() + f), () -> {
                for (ParamItem item : f.getParamList()) {
                    String[] splitArr = this.splitStr(item.toString());
                    IDNumberTreeNode member = MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)this.dimNumMap.get(splitArr[0].toLowerCase(Locale.ENGLISH)), (String)splitArr[1]);
                    if (member != null && member != IDNumberTreeNode.NotFoundTreeNode) continue;
                    f.setException((Exception)((Object)new InvalidParamException("Member \"" + splitArr[1] + "\" not found")));
                }
                return f;
            })).hasException()) continue;
            f.setException(cachedFormula.getException());
        }
    }

    private void handleDefaultParamVal() {
        HashMap<String, String> dim2member = new HashMap<String, String>(16);
        for (Formula f : this.originalFormulas) {
            if (f.hasException()) continue;
            dim2member.clear();
            f.getParamList().removeIf(p -> StringUtils.isEmpty((String)p.toString()));
            for (ParamItem item : f.getParamList()) {
                String[] splitArr = this.splitStr(item.toString());
                if (splitArr.length == 2 && this.dimNumMap.containsKey(splitArr[0].toLowerCase(Locale.ENGLISH))) {
                    dim2member.put(splitArr[0].toLowerCase(Locale.ENGLISH), splitArr[1]);
                    continue;
                }
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"VCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), item.toString()))));
                break;
            }
            if (f.hasException()) continue;
            if (SysMembConstant.rateNumbers.contains(dim2member.get(DimTypesEnum.ACCOUNT.getShortNumber().toLowerCase(Locale.ENGLISH))) || f instanceof ExcRateFormula) {
                this.exchangeRateAccountHandle(f, dim2member);
                continue;
            }
            this.fillDefaultParamItem(dim2member, f);
        }
    }

    protected void exchangeRateAccountHandle(Formula f, Map<String, String> dim2member) {
        ParamList paramList = f.getParamList();
        paramList.clear();
        if (this._ctx.getProperty("exchangeRate") != null) {
            paramList.add(new ParamItem(DimTypesEnum.ENTITY.getShortNumber() + "." + this._ctx.getProperty("exchangeRate")));
        }
        paramList.add(new ParamItem(DimTypesEnum.ACCOUNT.getShortNumber() + "." + dim2member.get(DimTypesEnum.ACCOUNT.getShortNumber().toLowerCase(Locale.ENGLISH))));
        paramList.add(new ParamItem(DimTypesEnum.SCENARIO.getShortNumber() + "." + this._ctx.getScenario()));
        paramList.add(new ParamItem(DimTypesEnum.YEAR.getShortNumber() + "." + (dim2member.get("fy") != null ? dim2member.get("fy") : this._ctx.getYear())));
        paramList.add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + (dim2member.get("p") != null ? dim2member.get("p") : this._ctx.getPeriod())));
        if (this._ctx.getProperty("srcCurrency") != null) {
            paramList.add(new ParamItem(DimTypesEnum.PROCESS.getShortNumber() + "." + this._ctx.getProperty("srcCurrency")));
        }
        paramList.add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + this._ctx.getCurrency()));
        if (MemberReader.isExistAuditTrailDimension((String)this._ctx.getCubeNumber())) {
            paramList.add(new ParamItem(DimTypesEnum.AUDITTRIAL.getShortNumber() + "." + "ATNone"));
        }
        if (MemberReader.isExistChangeTypeDimension((String)this._ctx.getCubeNumber())) {
            paramList.add(new ParamItem(DimTypesEnum.CHANGETYPE.getShortNumber() + "." + "EndingBalance"));
        }
        if (this.dimNumMap.containsValue(DimTypesEnum.MYCOMPANY.getNumber())) {
            paramList.add(new ParamItem(DimTypesEnum.MYCOMPANY.getShortNumber() + "." + DimTypesEnum.MYCOMPANY.getShortNumber() + "None"));
        }
        paramList.add(new ParamItem(DimTypesEnum.INTERCOMPANY.getShortNumber() + "." + "ICNone"));
        if (this.dimNumMap.containsValue(DimTypesEnum.MULTIGAAP.getNumber())) {
            paramList.add(new ParamItem(DimTypesEnum.MULTIGAAP.getShortNumber() + "." + DimTypesEnum.MULTIGAAP.getShortNumber() + "None"));
        }
        if (this.dimNumMap.containsValue(DimTypesEnum.DATASORT.getNumber())) {
            paramList.add(new ParamItem(DimTypesEnum.DATASORT.getShortNumber() + "." + "Actual"));
        }
        this.userDefinedDim.forEach(u -> paramList.add(new ParamItem(u + "." + u + "None")));
    }

    private String[] splitStr(String param) {
        int first = (param = param.trim()).indexOf(46);
        if (first == -1) {
            return new String[0];
        }
        String dim = param.substring(0, first);
        String member = param.substring(first + 1);
        if (DimTypesEnum.PROCESS.getShortNumber().contentEquals(dim) && "ARPT".equalsIgnoreCase(member)) {
            member = "ARPT";
        }
        return new String[]{dim, member};
    }

    private void fillDefaultParamItem(Map<String, String> dim2member, Formula f) {
        Set<String> dimKeys = dim2member.keySet();
        if (!dimKeys.contains(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.ENTITY.getShortNumber() + "." + this._ctx.getOrg()));
            dim2member.put(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH), this._ctx.getOrg());
        }
        if (!dimKeys.contains(DimTypesEnum.YEAR.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.YEAR.getShortNumber() + "." + this._ctx.getYear()));
        }
        if (!dimKeys.contains(DimTypesEnum.PERIOD.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + this._ctx.getPeriod()));
        }
        if (!dimKeys.contains(DimTypesEnum.SCENARIO.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.SCENARIO.getShortNumber() + "." + this._ctx.getScenario()));
        }
        if (!dimKeys.contains(DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + this._ctx.getCurrency()));
        }
        if (!dimKeys.contains(DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.PROCESS.getShortNumber() + "." + this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber())));
            dim2member.put(DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH), (String)this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber()));
        }
        if (this.hasMC && !dimKeys.contains(DimTypesEnum.MYCOMPANY.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.MYCOMPANY.getShortNumber() + "." + this._ctx.getOrg()));
        }
        this.userDefinedDim.forEach(u -> {
            if (!dimKeys.contains(u.toLowerCase(Locale.ENGLISH))) {
                f.getParamList().add(new ParamItem(u + "." + u + "None"));
            }
        });
        this.replaceOrgByBp(dim2member, f);
    }

    private void replaceOrgByBp(Map<String, String> dim2member, Formula f) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)dim2member.get(DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH)))) {
            if (!dim2member.get(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH)).contains("_") && this._ctx.getProperty("orgpnumber") != null) {
                String orgPnumber = this._ctx.getProperty("orgpnumber") + "_" + this._ctx.getOrg();
                this.replaceEntityParam(f, orgPnumber);
            }
        } else if (dim2member.get(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH)).contains("_")) {
            String[] split = dim2member.get(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH)).split("_");
            this.replaceEntityParam(f, split[1]);
        }
    }

    private void replaceEntityParam(Formula f, String orgNumber) {
        ParamList paramList = f.getParamList();
        paramList.removeIf(p -> p.toString().startsWith(DimTypesEnum.ENTITY.getShortNumber() + "."));
        paramList.add(new ParamItem(DimTypesEnum.ENTITY.getShortNumber() + "." + orgNumber));
    }

    @Override
    protected void execCalculate(List<VFormula> formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        this.sortFormulaParamList(formulas);
        TreeMap<String, Collection> kvMap = new TreeMap<String, Collection>((k1, k2) -> this.dimOrderMap.get(k1) - this.dimOrderMap.get(k2));
        HashMultimap dim2MembMap = HashMultimap.create();
        ArrayList resultFormula = new ArrayList();
        formulas.iterator().forEachRemaining(e -> {
            if (StringUtils.isEmpty((String)e.getExceptionMsg())) {
                for (ParamItem p : e.getParamList()) {
                    String[] arrays = this.splitStr(p.toString());
                    dim2MembMap.put((Object)this.dimNumMap.get(arrays[0].toLowerCase(Locale.ENGLISH)), (Object)arrays[1]);
                    resultFormula.add(e);
                }
            }
        });
        if (dim2MembMap.isEmpty()) {
            return;
        }
        dim2MembMap.asMap().forEach((k, v) -> kvMap.put((String)k, (Collection)v));
        SQLBuilder sql = new SQLBuilder(this._ctx.getCubeNumber());
        kvMap.forEach((k, v) -> {
            sql.addSelectField((String)k);
            sql.addFilter((String)k, v.toArray(new String[0]));
        });
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        Map<String, Object> result = rs.asMap();
        resultFormula.forEach(f -> f.fillBack(result));
    }

    private void sortFormulaParamList(List<VFormula> formulas) {
        formulas.forEach(f -> {
            Formula cachedFormula = (Formula)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)("sortFormulaParamList" + this._ctx.getCubeNumber() + f), () -> {
                f.getParamList().sort((p1, p2) -> {
                    String s1 = this.splitStr(p1.toString())[0];
                    String s2 = this.splitStr(p2.toString())[0];
                    return this.dimOrderMap.get(s1) - this.dimOrderMap.get(s2);
                });
                return f;
            });
            f.initParam(cachedFormula.getParamList());
        });
    }

    private void initDimNumMap() {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber,dseq,issysdimension", (QFilter[])new QFBuilder().add("model.number", "=", (Object)this._ctx.getCubeNumber()).toArray()).values().forEach(e -> {
            this.dimNumMap.put(e.getString("shortnumber").toLowerCase(Locale.ENGLISH), e.getString("number"));
            this.dimOrderMap.put(e.getString("shortnumber"), e.getInt("dseq"));
            this.dimOrderMap.put(e.getString("number"), e.getInt("dseq"));
            if (DimTypesEnum.MYCOMPANY.getNumber().equals(e.getString("number"))) {
                this.hasMC = true;
            }
            if (!e.getBoolean("issysdimension")) {
                this.userDefinedDim.add(e.getString("shortnumber"));
            }
        });
    }
}

