/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.VDataFormula;
import kd.fi.bcm.business.formula.enums.VDataTypeEnum;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataFormulaVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.NumberUtils;

public class VDataCalculate
extends AbstractCalculate<VDataFormula> {
    public static final String CUR = "$Cur";

    @Override
    protected void initFormula() {
    }

    @Override
    protected void execCalculate(List<VDataFormula> formulas) {
        block2: for (VDataFormula formula : formulas) {
            String source = ((ParamItem)formula.getParamList().get(0)).toString();
            String model = ((ParamItem)formula.getParamList().get(1)).toString();
            String defaultValue = ((ParamItem)formula.getParamList().get(2)).toString();
            String returnValue = ((ParamItem)formula.getParamList().get(4)).toString();
            Map object = null;
            try {
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseVDataParam(source, model, defaultValue, ((ParamItem)formula.getParamList().get(3)).toString(), returnValue);
                boolean match = formulaVo.getColumnVos().stream().anyMatch(VDataRowVo::isFloat);
                if (match) {
                    Map variableMap = (Map)this._ctx.getProperty("v_data_variable_dims");
                    Map pageDims = this._ctx.getProperty("v_data_page_dims") == null ? Collections.emptyMap() : ((Map)this._ctx.getProperty("v_data_page_dims")).getOrDefault((Long)this._ctx.getProperty("templateId"), Collections.emptyMap());
                    for (VDataRowVo columnVo : formulaVo.getColumnVos()) {
                        MultiF7Result multiF7Result;
                        if (!(columnVo instanceof VDataDimNodeVo) || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList() == null || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().size() != 1 || (multiF7Result = ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().get(0)) == null || multiF7Result.getScope() != 10 || !CUR.equals(multiF7Result.getNumber())) continue;
                        String dimNum = columnVo.getDimNum();
                        if (pageDims.containsKey(dimNum)) {
                            multiF7Result.setNumber((String)pageDims.get(dimNum));
                            continue;
                        }
                        if (variableMap != null && variableMap.containsKey(dimNum.toLowerCase())) {
                            multiF7Result.setNumber((String)this._ctx.getProperty(dimNum.toLowerCase()));
                            continue;
                        }
                        formula.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bbe\u7f6e\u3002", (String)"VDataCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), columnVo.getDimNum()))));
                        continue block2;
                    }
                    HashMap shortMap = new HashMap(16);
                    Map numberMap = MemberReader.getDimensionShortNumber2NumberMap((String)this._ctx.getCubeNumber());
                    numberMap.forEach((k, v) -> shortMap.put(v, k));
                    Map refParam = (Map)this._ctx.getProperty("is_calc_collect_ref_param");
                    HashMap<String, JSONArray> jsonArrayMap = new HashMap<String, JSONArray>(16);
                    for (Map.Entry entry : refParam.entrySet()) {
                        jsonArrayMap.put((String)shortMap.getOrDefault(entry.getKey(), entry.getKey()), new JSONArray(new ArrayList((Collection)entry.getValue())));
                    }
                    HashMap floatMap = new HashMap(16);
                    formulaVo.getColumnVos().stream().filter(VDataRowVo::isFloat).forEach(vo -> {
                        if (formulaVo.getType() == VDataTypeEnum.CM || formulaVo.getType() == VDataTypeEnum.CM_ETX || formulaVo.getType() == VDataTypeEnum.RPT) {
                            Map shotMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberByShowNum((String)formulaVo.getModelNum()));
                            floatMap.put(numberMap.getOrDefault(vo.getFloatMapping(), vo.getNumber()), shotMap.getOrDefault(vo.getNumber(), vo.getNumber()));
                        } else {
                            floatMap.put(numberMap.getOrDefault(vo.getFloatMapping(), vo.getNumber()), vo.getNumber());
                        }
                    });
                    VDataFormulaVo multiVo = VDataFormulaUtils.transferMultiRow(formulaVo, jsonArrayMap);
                    VDataFormulaUtils.hasPermission(multiVo);
                    Object res = VDataFormulaUtils.getDataResult(multiVo.toFetchDataString());
                    if (res instanceof List && !((List)res).isEmpty()) {
                        HashMap result = new HashMap();
                        List returnDims = (List)this._ctx.getProperty("v_data_return_dims");
                        for (Map row : (List)res) {
                            ArrayList returnFields = new ArrayList(row.keySet());
                            JSONArray array = new JSONArray();
                            for (String returnDim : returnDims) {
                                String field = floatMap.getOrDefault(returnDim, returnDim);
                                array.add((Object)(row.get(field) == null ? "" : row.get(field)));
                                returnFields.remove(field);
                            }
                            if (returnFields.isEmpty()) continue;
                            Object value = row.get(returnFields.get(0));
                            if (value instanceof String && NumberUtils.isNumber((String)((String)value))) {
                                value = new BigDecimal((String)value);
                            }
                            result.put(JSONArray.toJSONString((Object)array), value);
                        }
                        object = result;
                    } else {
                        object = Collections.emptyMap();
                    }
                } else {
                    for (VDataRowVo columnVo : formulaVo.getColumnVos()) {
                        MultiF7Result multiF7Result;
                        if (!(columnVo instanceof VDataDimNodeVo) || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList() == null || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().size() != 1 || (multiF7Result = ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().get(0)) == null || multiF7Result.getScope() != 10 || !CUR.equals(multiF7Result.getNumber())) continue;
                        String dimNum = columnVo.getDimNum();
                        if (formula.getDimNumMap() != null && !formula.getDimNumMap().containsKey(dimNum.toLowerCase())) {
                            formula.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bbe\u7f6e\u3002", (String)"VDataCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), columnVo.getDimNum()))));
                            continue block2;
                        }
                        multiF7Result.setNumber(formula.getDimNumMap().get(dimNum.toLowerCase()));
                    }
                    Map value = VDataFormulaUtils.getDataResult(formulaVo.toFetchDataString());
                    if (value instanceof String && NumberUtils.isNumber((String)((String)((Object)value)))) {
                        value = new BigDecimal((String)((Object)value));
                    }
                    object = value;
                }
            }
            catch (Exception e) {
                formula.setException(e);
                this.log.error(String.format("VDData formulat: %s, error: %s", formula, Arrays.toString(e.getStackTrace())));
            }
            if (object == null) continue;
            formula.fillBack((Object)object);
        }
    }
}

