/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.ObjectUtils;

public class VDmCalculate
extends AbstractCalculate<VDmFormula> {
    private static final int MODEL_INDEX = 0;
    private static final int DIMS_INDEX = 1;
    private String processShortNum = DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH);
    private String currencyShortNumber = DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH);
    private String yearShortNumber = DimTypesEnum.YEAR.getShortNumber().toLowerCase(Locale.ENGLISH);
    private String periodShortNumber = DimTypesEnum.PERIOD.getShortNumber().toLowerCase(Locale.ENGLISH);
    private String sceneShortNumber = DimTypesEnum.SCENARIO.getShortNumber().toLowerCase(Locale.ENGLISH);

    @Override
    protected void initFormula() {
        Map<String, List<VDmFormula>> formulaGroupByCube = this.groupFormulasByModel(this.originalFormulas);
        for (List<VDmFormula> formulas : formulaGroupByCube.values()) {
            String cube = "";
            HashMap<String, String> shortNumber2Num = new HashMap(16);
            if (formulas == null || formulas.size() <= 0) continue;
            cube = this.getCube(formulas.get(0));
            if (StringUtils.isNotEmpty((String)cube)) {
                shortNumber2Num = this.getShortNumber2Num(cube);
            }
            int size = shortNumber2Num.size();
            HashBasedTable orgProcess2Currency = HashBasedTable.create();
            HashBasedTable lastPeriodMap = HashBasedTable.create();
            HashBasedTable exchangePeriodMap = HashBasedTable.create();
            HashMap<String, String> lastYearMap = new HashMap<String, String>(16);
            String currentYear = this._ctx.getYear();
            String currentPeriod = this._ctx.getPeriod();
            Long modelId = this._ctx.getModelId();
            for (Formula formula : formulas) {
                this.checkParams(formula);
                this.handleDefaultParamVal(formula, shortNumber2Num);
                this.checkDimParamSize(formula, size);
                this.checkMemberIsExit(formula, shortNumber2Num, cube);
                this.fixYearAndPeroidAndCurrency(cube, (HashBasedTable<String, String, String>)orgProcess2Currency, currentYear, currentPeriod, modelId, formula, lastYearMap, (HashBasedTable<String, String, String[]>)lastPeriodMap, (HashBasedTable<String, String, String>)exchangePeriodMap);
            }
            this.checkMemberPerm(formulas, shortNumber2Num, cube);
        }
    }

    private void fixYearAndPeroidAndCurrency(String cube, HashBasedTable<String, String, String> orgProcess2Currency, String currentYear, String currentPeriod, Long modelId, Formula f, Map<String, String> lastYearMap, HashBasedTable<String, String, String[]> lastPeriodMap, HashBasedTable<String, String, String> exchangePeriodMap) {
        if (!f.hasException()) {
            String period;
            String currency;
            String dimAndMembers = this.getParam(f, 1);
            String upperCase = dimAndMembers.toUpperCase();
            TreeMap<String, Object> shortNum2MemNum = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            if (upperCase.contains("C.DC") || upperCase.contains("C.EC") || upperCase.contains("C.PC") || upperCase.contains("FY.CURRENTYEAR") || upperCase.contains("FY.LASTYEAR") || upperCase.contains("P.CURRENTPERIOD") || upperCase.contains("P.LASTPERIOD")) {
                String[] dim2MemArr;
                for (String dim2num : dim2MemArr = dimAndMembers.split(",")) {
                    String[] dim2numArr = VDmFormula.splitDimAndMembNew(dim2num);
                    shortNum2MemNum.put(dim2numArr[0], dim2numArr[1]);
                }
            }
            if ("EC".equalsIgnoreCase(currency = (String)shortNum2MemNum.get(this.currencyShortNumber)) || "DC".equalsIgnoreCase(currency) || "PC".equalsIgnoreCase(currency)) {
                String orgnum = (String)shortNum2MemNum.get(DimTypesEnum.ENTITY.getShortNumber());
                String process = (String)shortNum2MemNum.get(this.processShortNum);
                if (orgnum != null) {
                    if (orgProcess2Currency.contains((Object)orgnum, (Object)process)) {
                        shortNum2MemNum.put(this.currencyShortNumber, orgProcess2Currency.get((Object)orgnum, (Object)process));
                    } else {
                        try {
                            IDNumberTreeNode entityMemberByNum = MemberReader.findEntityMemberByNum((String)cube, (String)orgnum);
                            Long orgId = entityMemberByNum.getId();
                            if (orgId == 0L || orgId == -1L) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff1a%s\u3002", (String)"SpecialcalLogic_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgnum));
                            }
                            Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(cube, (long)orgId, process, currency, 0L, 0L);
                            shortNum2MemNum.put(this.currencyShortNumber, msg.p2);
                            orgProcess2Currency.put((Object)orgnum, (Object)process, msg.p2);
                        }
                        catch (Exception e) {
                            f.setException(e);
                        }
                    }
                }
            }
            String year = (String)shortNum2MemNum.get(this.yearShortNumber);
            String scene = (String)shortNum2MemNum.get(this.sceneShortNumber);
            if (StringUtils.isNotEmpty((String)year)) {
                if ("CurrentYear".equals(year)) {
                    year = currentYear;
                } else if ("LastYear".equals(year)) {
                    if (!f.isPeriodInFormula()) {
                        if (!exchangePeriodMap.contains((Object)scene, (Object)currentPeriod)) {
                            String exchangePeriodNum = ConfigServiceHelper.getExchangePeriodForLastYear(modelId, scene, currentPeriod);
                            shortNum2MemNum.put(this.periodShortNumber, exchangePeriodNum);
                            exchangePeriodMap.put((Object)scene, (Object)currentPeriod, (Object)exchangePeriodNum);
                        } else {
                            shortNum2MemNum.put(this.periodShortNumber, exchangePeriodMap.get((Object)scene, (Object)currentPeriod));
                        }
                    }
                    if (!lastYearMap.containsKey(currentYear)) {
                        Optional lastYear = PeriodUtils.getLastYear((String)cube, (String)currentYear);
                        if (lastYear.isPresent()) {
                            year = (String)lastYear.get();
                        }
                        lastYearMap.put(currentYear, year);
                    } else {
                        year = lastYearMap.get(currentYear);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)(period = (String)shortNum2MemNum.get(this.periodShortNumber))) && StringUtils.isNotEmpty((String)year) && ObjectUtils.notEqual((Object)year, (Object)"LastYear")) {
                if ("CurrentPeriod".equals(period)) {
                    period = currentPeriod;
                } else if ("LastPeriod".equals(period)) {
                    String[] yearandperiod = new String[]{};
                    if (!lastPeriodMap.contains((Object)year, (Object)currentPeriod)) {
                        try {
                            yearandperiod = PeriodUtils.getLastPeriodIncludeYear((String)cube, (String)year, (String)currentPeriod, (boolean)true);
                            lastPeriodMap.put((Object)year, (Object)currentPeriod, (Object)yearandperiod);
                        }
                        catch (Exception e) {
                            this.log.error((Throwable)e);
                        }
                    } else {
                        yearandperiod = (String[])lastPeriodMap.get((Object)year, (Object)currentPeriod);
                    }
                    if (yearandperiod[0] != null) {
                        year = yearandperiod[0];
                        period = yearandperiod[1];
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)year)) {
                shortNum2MemNum.put(this.yearShortNumber, year);
            }
            if (StringUtils.isNotEmpty((String)period)) {
                shortNum2MemNum.put(this.periodShortNumber, period);
            }
            if (MapUtils.isNotEmpty(shortNum2MemNum)) {
                StringBuilder sb = new StringBuilder();
                int last = shortNum2MemNum.size();
                int index = 0;
                for (Map.Entry dim2num : shortNum2MemNum.entrySet()) {
                    sb.append((String)dim2num.getKey()).append('.').append((String)dim2num.getValue());
                    if (++index == last) continue;
                    sb.append(",");
                }
                f.getParamList().remove(1);
                f.getParamList().add(1, new ParamItem(new StringExpr(sb.toString())));
            }
        }
    }

    @Override
    protected void execCalculate(List<VDmFormula> formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        Map<String, List<VDmFormula>> formulaGroup = this.groupFormulasByModel(formulas);
        if (formulaGroup.size() == 0) {
            return;
        }
        formulaGroup.entrySet().forEach(model -> {
            String cube = MemberReader.findModelNumberByShowNum((String)((String)model.getKey()));
            Map dimOrderMap = MemberReader.getMemberShortNum2Dseq((String)cube);
            TreeMap<String, Integer> dimOrder = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            dimOrder.putAll(dimOrderMap);
            this.sortFormulaParamList(formulas, dimOrder);
            Map<String, String> shortNumber2Num = this.getShortNumber2Num(cube);
            Map memberNum2Dseq = MemberReader.getMemberNum2Dseq((String)cube);
            TreeMap<String, Collection<String>> kvMap = new TreeMap<String, Collection<String>>((k1, k2) -> (Integer)memberNum2Dseq.get(k1) - (Integer)memberNum2Dseq.get(k2));
            this.caculateOlapValue(cube, shortNumber2Num, kvMap, (List)model.getValue());
        });
    }

    private Map<String, List<VDmFormula>> groupFormulasByModel(List<VDmFormula> formulas) {
        Map<String, List<VDmFormula>> formulaGroup = formulas.stream().collect(Collectors.groupingBy(formula -> ((ParamItem)formula.getParamList().get(0)).toString()));
        return formulaGroup;
    }

    private void caculateOlapValue(String cube, Map<String, String> shortNumber2Num, TreeMap<String, Collection<String>> kvMap, List<VDmFormula> formulas) {
        kvMap.clear();
        HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims(shortNumber2Num, formulas);
        dim2MembMap.asMap().forEach((k, v) -> kvMap.put((String)k, (Collection<String>)v));
        SQLBuilder sql = new SQLBuilder(cube);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        kvMap.forEach((k, v) -> {
            sql.addSelectField((String)k);
            sql.addFilter((String)k, v.toArray(new String[0]));
        });
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        Map<String, Object> result = rs.asMap();
        formulas.forEach(f -> f.fillBack(result));
    }

    private HashMultimap<String, String> getSqlFilterDims(Map<String, String> shortNumber2Num, List<VDmFormula> formulas) {
        HashMultimap dim2MembMap = HashMultimap.create();
        for (VDmFormula f : formulas) {
            String[] arrays = null;
            String dimAndMembers = this.getParam(f, 1);
            ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
            for (String s : dim2MemList) {
                if (StringUtils.isEmpty((String)s)) continue;
                arrays = VDmFormula.splitDimAndMembNew(s);
                dim2MembMap.put((Object)shortNumber2Num.get(arrays[0].toUpperCase(Locale.ENGLISH)), (Object)arrays[1]);
            }
        }
        return dim2MembMap;
    }

    private void sortFormulaParamList(List<VDmFormula> formulas, Map<String, Integer> dimOrder) {
        formulas.forEach(f -> {
            String dimAndMembers = this.getParam((Formula)f, 1);
            ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
            dim2MemList.sort((p1, p2) -> {
                String s1 = VDmFormula.splitDimAndMembNew(p1)[0];
                String s2 = VDmFormula.splitDimAndMembNew(p2)[0];
                return (Integer)dimOrder.get(s1) - (Integer)dimOrder.get(s2);
            });
            this.changeDimParam((Formula)f, dim2MemList);
        });
    }

    private String getCube(Formula f) {
        String cube = "";
        try {
            if (!f.hasException()) {
                String showNumber = this.getParam(f, 0);
                cube = MemberReader.findModelNumberByShowNum((String)showNumber);
            }
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]))));
        }
        return cube;
    }

    private void checkDimParamSize(Formula f, int dimCount) {
        String dimStr;
        String[] split;
        if (!f.hasException() && (split = (dimStr = this.getParam(f, 1)).split(",")).length != dimCount) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u4e0e\u4f53\u7cfb\u7ef4\u5ea6\u6570\u91cf\u4e0d\u540c\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_9", (String)"fi-bcm-business", (Object[])new Object[0]))));
        }
    }

    private void checkParams(Formula f) {
        if (!f.hasException()) {
            if (f.getParamList().size() < 2) {
                f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u5c11\u4e8e2\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_7", (String)"fi-bcm-business", (Object[])new Object[0]))));
                return;
            }
            String showNumber = this.getParam(f, 0);
            Optional<DynamicObject> model = Optional.ofNullable(BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"number", (QFilter[])new QFBuilder().add("model.shownumber", "=", (Object)showNumber).toArray()));
            if (!model.isPresent()) {
                f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
                return;
            }
        }
    }

    private String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }

    private void handleDefaultParamVal(Formula f, Map<String, String> shortNumber2Num) {
        if (!f.hasException()) {
            Map<String, String> formulaDim2member = this.getFormulaDim2member(f, shortNumber2Num);
            if (formulaDim2member == null) {
                return;
            }
            this.fillDefaultParamItem(formulaDim2member, f);
            this.fillMissParamItem(shortNumber2Num, f, formulaDim2member);
        }
    }

    private Map<String, String> getFormulaDim2member(Formula f, Map<String, String> shortNumber2Num) {
        HashMap<String, String> formulaDim2member = new HashMap<String, String>(16);
        String dimAndMembers = this.getParam(f, 1);
        if (StringUtils.isEmpty((String)dimAndMembers)) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VDmCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]))));
            return null;
        }
        String[] dim2MemArr = dimAndMembers.split(",");
        try {
            for (String item : dim2MemArr) {
                String[] splitArr = VDmFormula.splitDimAndMembNew(item);
                if (splitArr.length != 2 || !shortNumber2Num.containsKey(splitArr[0].toUpperCase(Locale.ENGLISH))) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u65e0\u6548\u3002", (String)"VDmCalculate_5", (String)"fi-bcm-business", (Object[])new Object[0]), item))));
                    break;
                }
                formulaDim2member.put(splitArr[0].toUpperCase(Locale.ENGLISH), splitArr[1]);
            }
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"VDmCalculate_6", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error((Throwable)e);
            return null;
        }
        return formulaDim2member;
    }

    private Map<String, Integer> getDimOrdMapByCache(String cube) {
        return MemberReader.getMemberShortNum2Dseq((String)cube);
    }

    private Map<String, String> getShortNumber2Num(String cube) {
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)cube);
        TreeMap<String, String> dimensionShortNumber2NumberTreeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        dimensionShortNumber2NumberTreeMap.putAll(dimensionShortNumber2NumberMap);
        return dimensionShortNumber2NumberTreeMap;
    }

    private void fillDefaultParamItem(Map<String, String> formulaDim2member, Formula f) {
        Set<String> dimKeys = formulaDim2member.keySet();
        String dimAndMembers = this.getParam(f, 1);
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        if (!dimKeys.contains(DimTypesEnum.ENTITY.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.ENTITY.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getOrg());
            formulaDim2member.put(DimTypesEnum.ENTITY.getShortNumber().toUpperCase(Locale.ENGLISH), this._ctx.getOrg());
        }
        if (!dimKeys.contains(DimTypesEnum.YEAR.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.YEAR.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getYear());
            formulaDim2member.put(DimTypesEnum.YEAR.getShortNumber().toUpperCase(Locale.ENGLISH), this._ctx.getYear());
        }
        if (!dimKeys.contains(DimTypesEnum.PERIOD.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.PERIOD.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getPeriod());
            formulaDim2member.put(DimTypesEnum.PERIOD.getShortNumber().toUpperCase(Locale.ENGLISH), this._ctx.getPeriod());
        } else {
            f.setPeriodInFormula(true);
        }
        if (!dimKeys.contains(DimTypesEnum.SCENARIO.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.SCENARIO.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getScenario());
            formulaDim2member.put(DimTypesEnum.SCENARIO.getShortNumber().toUpperCase(Locale.ENGLISH), this._ctx.getScenario());
        }
        if (!dimKeys.contains(DimTypesEnum.CURRENCY.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.CURRENCY.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getCurrency());
            formulaDim2member.put(DimTypesEnum.CURRENCY.getShortNumber().toUpperCase(Locale.ENGLISH), this._ctx.getCurrency());
        }
        if (!dimKeys.contains(DimTypesEnum.PROCESS.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            if (this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber()) != null) {
                dim2MemList.add(DimTypesEnum.PROCESS.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber()));
                formulaDim2member.put(DimTypesEnum.PROCESS.getShortNumber().toUpperCase(Locale.ENGLISH), (String)this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber()));
            } else {
                dim2MemList.add(DimTypesEnum.PROCESS.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + "IRpt");
            }
        }
        if (!dimKeys.contains(DimTypesEnum.AUDITTRIAL.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.AUDITTRIAL.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + "EntityInput");
        }
        if (!dimKeys.contains(DimTypesEnum.CHANGETYPE.getShortNumber().toUpperCase(Locale.ENGLISH))) {
            dim2MemList.add(DimTypesEnum.CHANGETYPE.getShortNumber().toUpperCase(Locale.ENGLISH) + "." + "YTD");
        }
        this.changeDimParam(f, dim2MemList);
    }

    private void fillMissParamItem(Map<String, String> shortNum2Num, Formula f, Map<String, String> formulaShortNum2Num) {
        String dimAndMembers = this.getParam(f, 1);
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        Set<String> dimKeys = shortNum2Num.keySet();
        Set<String> formulaDimKeys = formulaShortNum2Num.keySet();
        dimKeys.forEach(dim -> {
            if (!formulaDimKeys.contains(dim.toUpperCase())) {
                dim2MemList.add(dim + '.' + dim + "None");
            }
        });
        f.getParamList().remove(1);
        f.getParamList().add(1, new ParamItem(new StringExpr(String.join((CharSequence)",", dim2MemList))));
    }

    private void checkMemberIsExit(Formula f, Map<String, String> shortNumber2Num, String cube) {
        if (!f.hasException()) {
            String[] dim2MemArr;
            String dimAndMembers = this.getParam(f, 1);
            for (String item : dim2MemArr = dimAndMembers.split(",")) {
                String[] splitArr = VDmFormula.splitDimAndMembNew(item);
                IDNumberTreeNode member = MemberReader.findMemberByNumber((String)cube, (String)shortNumber2Num.get(splitArr[0].toUpperCase(Locale.ENGLISH)), (String)splitArr[1]);
                if (member != null && member != IDNumberTreeNode.NotFoundTreeNode) continue;
                f.setException((Exception)((Object)new InvalidParamException("Member \"" + splitArr[1] + "\" not found")));
            }
        }
    }

    private void checkMemberPerm(List<VDmFormula> formulas, Map<String, String> shortNumber2Num, String cube) {
        if (formulas.size() > 0) {
            VDmFormula vDmFormula = formulas.stream().filter(f -> !f.hasException()).findFirst().orElse(null);
            if (vDmFormula == null) {
                return;
            }
            String dimstr = this.getParam(vDmFormula, 1);
            String[] dim2nums = dimstr.split(",");
            ArrayList<String> dimsOrder = new ArrayList<String>(16);
            for (String dim2num : dim2nums) {
                String[] dimAndMem = VDmFormula.splitDimAndMembNew(dim2num);
                dimsOrder.add(shortNumber2Num.get(dimAndMem[0]));
            }
            QueryStatusCommandInfo queryInfo = new QueryStatusCommandInfo(cube);
            queryInfo.setFormulaCal(true);
            queryInfo.setCrossDimensions(dimsOrder);
            queryInfo.setBizStatusQueryTypes(Collections.singletonList(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode()));
            HashMap<String, VDmFormula> formulaDims2formula = new HashMap<String, VDmFormula>(16);
            for (VDmFormula formula : formulas) {
                if (formula.hasException()) continue;
                ArrayList<String> mems = new ArrayList<String>(16);
                HashMap<String, String> dimNum2memNum = new HashMap<String, String>(16);
                String dimMemParamStr = this.getParam(formula, 1);
                for (String dim2num : dimMemParamStr.split("\\,")) {
                    String[] dimAndMem = dim2num.split("\\.");
                    dimNum2memNum.put(shortNumber2Num.get(dimAndMem[0]), dimAndMem[1]);
                }
                for (String dim : dimsOrder) {
                    mems.add((String)dimNum2memNum.get(dim));
                }
                queryInfo.addCrossMembers(mems);
                formulaDims2formula.put(String.join((CharSequence)"|", mems), formula);
            }
            queryInfo.setKeyPacker(membs -> {
                ArrayList list = new ArrayList(16);
                queryInfo.getCrossDimensions().forEach(dim -> list.add(membs.get(dim)));
                return String.join((CharSequence)"|", list);
            });
            BizStatusContext bsCTX = new BizStatusContext(queryInfo);
            Map<String, StatusResult> result = BizStatusServer.queryStatus(bsCTX);
            result.forEach((key, status) -> {
                if (formulaDims2formula.containsKey(key)) {
                    VDmFormula formula = (VDmFormula)formulaDims2formula.get(key);
                    formula.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u7684\u7ef4\u5ea6\u7ec4\u5408\u65e0\u6743\u3002", (String)"VDmCalculate_8", (String)"fi-bcm-business", (Object[])new Object[0]))));
                }
            });
        }
    }

    private void changeDimParam(Formula f, List<String> dim2MemList) {
        f.getParamList().remove(1);
        f.getParamList().add(1, new ParamItem(new StringExpr(String.join((CharSequence)",", dim2MemList))));
    }
}

