/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.XGetColSum;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.lang.StringUtils;

public class XGetColSumCalculate
extends AbstractCalculate<XGetColSum> {
    @Override
    protected void initFormula() {
    }

    @Override
    protected void execCalculate(List<XGetColSum> formulas) {
        for (XGetColSum formula : formulas) {
            ParamList paramList = formula.getParamList();
            String modelNum = this._ctx.getCubeNumber();
            Map map = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
            if (paramList.size() == 9 || paramList.size() == 10 || paramList.size() == 11) {
                try {
                    String dataModel = "";
                    String fieldNumber = "";
                    HashMap<String, String> dimScope = new HashMap<String, String>(16);
                    ArrayList<String> extScope = new ArrayList<String>(10);
                    HashMap<String, Pair<Long, String>> params = new HashMap<String, Pair<Long, String>>(this.getCtxDimMap(formula));
                    int index = 0;
                    for (ParamItem paramItem : paramList) {
                        String value;
                        if (paramItem.getParam() instanceof StringExpr && StringUtils.isNotEmpty((String)(value = ((StringExpr)paramItem.getParam()).getValue()))) {
                            switch (index) {
                                case 0: {
                                    dataModel = value.trim();
                                    break;
                                }
                                case 1: {
                                    fieldNumber = value.trim();
                                    break;
                                }
                                case 2: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode scenarioNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.SCENARIO.getNumber(), (String)value);
                                    if (scenarioNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.SCENARIO.getNumber(), (Pair<Long, String>)Pair.onePair((Object)scenarioNode.getId(), (Object)scenarioNode.getNumber()));
                                    break;
                                }
                                case 3: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode yearNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.YEAR.getNumber(), (String)value);
                                    if (yearNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.YEAR.getNumber(), (Pair<Long, String>)Pair.onePair((Object)yearNode.getId(), (Object)yearNode.getNumber()));
                                    break;
                                }
                                case 4: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode periodNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.PERIOD.getNumber(), (String)value);
                                    if (periodNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.PERIOD.getNumber(), (Pair<Long, String>)Pair.onePair((Object)periodNode.getId(), (Object)periodNode.getNumber()));
                                    break;
                                }
                                case 5: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode entityNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.ENTITY.getNumber(), (String)value);
                                    if (entityNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.ENTITY.getNumber(), (Pair<Long, String>)Pair.onePair((Object)entityNode.getId(), (Object)entityNode.getNumber()));
                                    break;
                                }
                                case 6: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode currencyNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.CURRENCY.getNumber(), (String)value);
                                    if (currencyNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.CURRENCY.getNumber(), (Pair<Long, String>)Pair.onePair((Object)currencyNode.getId(), (Object)currencyNode.getNumber()));
                                    break;
                                }
                                case 7: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode processNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.PROCESS.getNumber(), (String)value);
                                    if (processNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.PROCESS.getNumber(), (Pair<Long, String>)Pair.onePair((Object)processNode.getId(), (Object)processNode.getNumber()));
                                    break;
                                }
                                case 8: {
                                    if (!value.contains(".") && !value.contains("@")) break;
                                    value = value.split("[.@]", 2)[1];
                                    IDNumberTreeNode auditTrialNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)value);
                                    if (auditTrialNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                    params.put(DimEntityNumEnum.AUDITTRIAL.getNumber(), (Pair<Long, String>)Pair.onePair((Object)auditTrialNode.getId(), (Object)auditTrialNode.getNumber()));
                                    break;
                                }
                                case 9: 
                                case 10: {
                                    String scopeStr = value.trim();
                                    String[] scopes = scopeStr.trim().replace("),", ")|").replace("],", "]|").split("\\|");
                                    HashMap dimScopeMap = new HashMap(16);
                                    for (String scope : scopes) {
                                        ParamConstant.MethodEnum methodEnum;
                                        if (scope.contains("[") && scope.contains("]")) {
                                            int start = scope.indexOf("[");
                                            int end = scope.indexOf("]");
                                            int range = 10;
                                            String dim2 = scope.substring(0, start).trim();
                                            if (end == scope.length() - 1) {
                                                range = RangeEnum.VALUE_10.getValue();
                                            } else {
                                                String rangeName = scope.substring(end + 1);
                                                RangeEnum rangeByNumber = RangeEnum.getRangeByNumber((String)(rangeName = rangeName.substring(rangeName.indexOf(".") + 1, rangeName.indexOf("("))));
                                                if (rangeByNumber != null) {
                                                    range = rangeByNumber.getValue();
                                                }
                                            }
                                            if (!map.containsKey(dim2) && !map.containsValue(dim2)) continue;
                                            if (map.containsKey(dim2)) {
                                                dim2 = (String)map.get(dim2);
                                            }
                                            dimScopeMap.putIfAbsent(dim2, new ArrayList());
                                            String mem = scope.substring(start + 1, end).trim();
                                            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dim2, (String)mem);
                                            HashMap<String, String> memScope = new HashMap<String, String>(8);
                                            memScope.put("id", node.getId().toString());
                                            memScope.put("scope", String.valueOf(range));
                                            memScope.put("number", node.getNumber());
                                            ((List)dimScopeMap.get(dim2)).add(memScope);
                                            continue;
                                        }
                                        if (!scope.contains(".") || !scope.contains("(") || !scope.contains(")")) continue;
                                        String[] exts = scope.split("\\.", 2);
                                        String extNum = exts[0].trim();
                                        String input = exts[1].substring(0, exts[1].indexOf("("));
                                        ParamConstant.MethodEnum methodEnum2 = methodEnum = index == 9 ? ParamConstant.MethodEnum.getInMethodEnumByInput((String)input) : ParamConstant.MethodEnum.getExceptMethodEnumByInput((String)input);
                                        if (methodEnum == null) continue;
                                        String valueStr = "";
                                        String trim = exts[1].substring(exts[1].indexOf("(") + 1, exts[1].indexOf(")")).trim();
                                        if (trim.length() > 0) {
                                            valueStr = trim;
                                        }
                                        String extStr = String.format("%s@@%s@@%s", extNum, methodEnum.getCode(), valueStr);
                                        extScope.add(extStr);
                                    }
                                    for (Map.Entry entry : dimScopeMap.entrySet()) {
                                        dimScope.put((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
                                    }
                                    break;
                                }
                            }
                        }
                        ++index;
                    }
                    if (Arrays.stream(ParamConstant.CONTEXT_DIMENSIONS_ENUM).anyMatch(dim -> params.get(dim.getNumber()) == null && !DimEntityNumEnum.AUDITTRIAL.getNumber().equals(dim.getNumber()))) {
                        throw new IllegalArgumentException("ctx dim missing");
                    }
                    Pair<String, String> pair = TransMemberUtil.transOrgAndCurbyOrgId(modelNum, (long)((Long)((Pair)params.get((Object)DimEntityNumEnum.ENTITY.getNumber())).p1), (String)((Pair)params.get((Object)DimEntityNumEnum.PROCESS.getNumber())).p2, (String)((Pair)params.get((Object)DimEntityNumEnum.CURRENCY.getNumber())).p2, (long)((Long)((Pair)params.get((Object)DimEntityNumEnum.YEAR.getNumber())).p1), (long)((Long)((Pair)params.get((Object)DimEntityNumEnum.PERIOD.getNumber())).p1));
                    if (StringUtils.isEmpty((String)((String)pair.p2))) {
                        throw new IllegalArgumentException("ctx dim missing");
                    }
                    IDNumberTreeNode currency = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)((String)pair.p2));
                    params.put(DimEntityNumEnum.CURRENCY.getNumber(), (Pair<Long, String>)Pair.onePair((Object)currency.getId(), (Object)currency.getNumber()));
                    BigDecimal result = ScriptBuiltinExtHelper.getColSum(modelNum, dataModel, fieldNumber, params, dimScope, extScope);
                    formula.fillBack(result);
                }
                catch (Exception e) {
                    StringJoiner sj = new StringJoiner(",");
                    for (ParamItem paramItem : paramList) {
                        if (!(paramItem.getParam() instanceof StringExpr)) continue;
                        sj.add(((StringExpr)paramItem.getParam()).getValue());
                    }
                    this.log.error(String.format("excuteScript error![%s]", sj), (Throwable)e);
                    formula.setException(e);
                }
                continue;
            }
            formula.setException((Exception)((Object)new KDBizException("params is error")));
        }
    }

    public Map<String, Pair<Long, String>> getCtxDimMap(XGetColSum xGetColSum) {
        HashMap<String, Pair<Long, String>> ctxDimMap = new HashMap<String, Pair<Long, String>>(16);
        for (DimTypesEnum contextDimension : ParamConstant.CONTEXT_DIMENSIONS_ENUM) {
            String contextValue;
            String number = contextDimension.getNumber();
            if (contextDimension == DimTypesEnum.ENTITY) {
                contextValue = this._ctx.getOrg();
                ctxDimMap.put(contextDimension.getNumber(), (Pair<Long, String>)Pair.onePair((Object)ChkCheckServiceHelper.getRealOrgId(this._ctx), (Object)contextValue));
                continue;
            }
            contextValue = xGetColSum.getDimNumMap().get(number.toLowerCase(Locale.ENGLISH));
            if (StringUtils.isEmpty((String)contextValue)) {
                ctxDimMap.put(contextDimension.getNumber(), null);
                continue;
            }
            ctxDimMap.put(contextDimension.getNumber(), (Pair<Long, String>)Pair.onePair((Object)MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)contextDimension.getNumber(), (String)contextValue).getId(), (Object)contextValue));
        }
        return ctxDimMap;
    }
}

