/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.adjust;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.adjust.ADJFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;

public class ADJCalculate
extends AbstractCalculate<ADJFormula> {
    private Map<String, String> accountLongNums = new HashMap<String, String>(10);

    @Override
    protected void initFormula() {
        this.handleDefaultParamVal();
    }

    private void handleDefaultParamVal() {
        HashSet<String> keys = new HashSet<String>(10);
        for (Formula f : this.originalFormulas) {
            keys.clear();
            this.fillDefaultParamItem(keys, f);
        }
    }

    private void fillDefaultParamItem(Set<String> dimKeys, Formula f) {
        if (!dimKeys.contains(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH))) {
            f.getParamList().add(new ParamItem(DimTypesEnum.ENTITY.getShortNumber() + "." + this._ctx.getOrg()));
        }
    }

    @Override
    protected void execCalculate(List<ADJFormula> formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        List groupData = (List)this._ctx.getProperty("groupData");
        boolean isleaf = (Boolean)this._ctx.getProperty("isleaf");
        for (ADJFormula f : formulas) {
            String fAccountLongNum = null;
            ParamList paramList = f.getParamList();
            for (ParamItem p : paramList) {
                String[] pa = p.toString().split("\\.");
                if (!DimTypesEnum.ACCOUNT.getShortNumber().equals(pa[0]) || (fAccountLongNum = this.accountLongNums.get(pa[1])) != null) continue;
                DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber(((DynamicObject)groupData.get(0)).getLong("model.id"), pa[1], "bcm_accountmembertree");
                fAccountLongNum = member.getString("longnumber");
                this.accountLongNums.put(pa[1], fAccountLongNum);
            }
            String fStr = f.toString();
            BigDecimal result = BigDecimal.ZERO;
            for (DynamicObject adj : groupData) {
                if (!adj.getString("account.longnumber").startsWith(fAccountLongNum) || !fStr.contains("\"" + adj.getString("changetype.dimension.shortnumber") + "." + adj.getString("changetype.number") + "\"") || !fStr.contains("\"" + adj.getString("internalcompany.dimension.shortnumber") + "." + adj.getString("internalcompany.number") + "\"") || !fStr.contains("\"" + adj.getString("process.dimension.shortnumber") + "." + adj.getString("process.number") + "\"") || adj.getLong("multigaap.id") != 0L && !fStr.contains("\"" + adj.getString("multigaap.dimension.shortnumber") + "." + adj.getString("multigaap.number") + "\"") || adj.getLong("datasort.id") != 0L && !fStr.contains("\"" + adj.getString("datasort.dimension.shortnumber") + "." + adj.getString("datasort.number") + "\"") || adj.getLong("dim1.id") != 0L && !fStr.contains("\"" + adj.getString("dim1.dimension.shortnumber") + "." + adj.getString("dim1.number") + "\"") || adj.getLong("dim2.id") != 0L && !fStr.contains("\"" + adj.getString("dim2.dimension.shortnumber") + "." + adj.getString("dim2.number") + "\"") || adj.getLong("dim3.id") != 0L && !fStr.contains("\"" + adj.getString("dim3.dimension.shortnumber") + "." + adj.getString("dim3.number") + "\"") || adj.getLong("dim4.id") != 0L && !fStr.contains("\"" + adj.getString("dim4.dimension.shortnumber") + "." + adj.getString("dim4.number") + "\"") || adj.getLong("dim5.id") != 0L && !fStr.contains("\"" + adj.getString("dim5.dimension.shortnumber") + "." + adj.getString("dim5.number") + "\"") || adj.getLong("dim6.id") != 0L && !fStr.contains("\"" + adj.getString("dim6.dimension.shortnumber") + "." + adj.getString("dim6.number") + "\"") || isleaf && !fStr.contains("\"" + adj.getString("entity.dimension.shortnumber") + "." + adj.getString("entity.number") + "\"")) continue;
                BigDecimal value = BigDecimal.ZERO;
                if (AggOprtEnum.SKIP.sign.equals(adj.getString("account.aggoprt"))) continue;
                value = DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.index.equals(adj.getString("account.drcrdirect")) || DrCRDirectEnum.NONE.index.equals(adj.getString("account.drcrdirect")) ? (adj.getBigDecimal("debit").compareTo(BigDecimal.ZERO) != 0 ? value.add(adj.getBigDecimal("debit")) : value.add(adj.getBigDecimal("credit").multiply(new BigDecimal(-1)))) : (adj.getBigDecimal("debit").compareTo(BigDecimal.ZERO) != 0 ? value.add(adj.getBigDecimal("debit")).multiply(new BigDecimal(-1)) : value.add(adj.getBigDecimal("credit")));
                value = value.multiply(new BigDecimal(AggOprtEnum.SUBSTRACT.sign.equals(adj.getString("account.aggoprt")) ? -1 : 1));
                result = result.add(value);
            }
            f.fillBack(result);
        }
    }
}

