/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.adjust;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckContext;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.adjust.AggFactorPath;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.model.MergeStructConfig;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.OlapSandBoxContext;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.OlapUtils;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.spread.datacollect.DataCollectServiceHelper;
import org.apache.commons.compress.utils.Lists;

public class GetJLEntryCalculate
extends AbstractCalculate<GetJLEntryFormula> {
    public static final Map<String, Integer> indexMap = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("merge", 0);
            this.put("mergescope", 1);
            this.put("dimensionMem", 2);
            this.put("computetype", 3);
        }
    });
    private static final Set<String> onlySingleSelectDimSet = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("Process");
            this.add("Currency");
            this.add("Scenario");
            this.add("ChangeType");
            this.add("Year");
            this.add("Period");
        }
    });
    private final AdjustCheckContext ctx = new AdjustCheckContext();
    private Set<Long> effectiveOrgSet;
    private final Map<String, AggFactorPath> formulaOrgAggScope = new HashMap<String, AggFactorPath>(16);
    private final Map<String, DimensionScope> dimenScopeMap = new HashMap<String, DimensionScope>(16);
    private final Map<String, Map<String, List<AggFactorMetadataItem>>> aggFactorMap = new HashMap<String, Map<String, List<AggFactorMetadataItem>>>(16);
    private final Set<String> aggFactorSet = new HashSet<String>(16);
    private AggFactorPath orgAggPathTemp = new AggFactorPath();

    private String getParamItem(GetJLEntryFormula f, String fieldKey) {
        return ((ParamItem)f.getParamList().get(indexMap.get(fieldKey))).toString();
    }

    @Override
    protected void initFormula() {
        this.ctx.setModel((Pair<Long, String>)Pair.onePair((Object)MemberReader.findModelIdByNum((String)this._ctx.getCubeNumber()), (Object)this._ctx.getCubeNumber()));
        this.ctx.setNoCheckDimCombineSet(true);
        this.ctx.setScene(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)"Scenario", (String)this._ctx.getScenario()).getId());
        this.ctx.setYear(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)"Year", (String)this._ctx.getYear()).getId());
        this.ctx.setPeriod(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)"Period", (String)this._ctx.getPeriod()).getId());
    }

    @Override
    protected void execCalculate(List<GetJLEntryFormula> formulas) {
        ThreadCache.put((Object)GetJLEntryCalculate.class.getClass().getName(), (Object)"");
        formulas.stream().filter(f -> {
            if (f.getParamList().size() != indexMap.size()) {
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u516c\u5f0f\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), f))));
                return false;
            }
            return true;
        }).collect(Collectors.groupingBy(f -> this.getParamItem((GetJLEntryFormula)f, "computetype"))).forEach(this::execCalculateByComputeType);
        ThreadCache.remove((Object)GetJLEntryCalculate.class.getClass().getName());
    }

    private void execCalculateByComputeType(String computeType, List<GetJLEntryFormula> formulaList) {
        if (CollectionUtils.isEmpty(formulaList)) {
            return;
        }
        this.collectEffectiveOrgScope(formulaList);
        HashMap<String, Tuple<Dimension, IDNumberTreeNode, RangeEnum>> dimParamMap = new HashMap<String, Tuple<Dimension, IDNumberTreeNode, RangeEnum>>(16);
        for (GetJLEntryFormula f2 : formulaList) {
            try {
                this.collectDiemensionParam(f2, dimParamMap);
                if (f2.hasException()) continue;
                this.analysisDiemensionParam(f2, dimParamMap);
                dimParamMap.clear();
            }
            catch (Throwable t) {
                f2.setException((Exception)((Object)new InvalidParamException(AdjustmentServiceHelper.toString_Adj(t))));
            }
        }
        if (!this.dimenScopeMap.isEmpty() && formulaList.stream().anyMatch(formula -> !formula.hasException())) {
            MDResultSet rs = this.queryRecomputeEntryData(this.dimenScopeMap, computeType);
            ArrayList logDyList = new ArrayList(formulaList.size());
            if (rs != null && !rs.isEmpty()) {
                Map<String, Object> result = rs.asMap();
                formulaList.forEach(f -> {
                    if (!f.hasException()) {
                        f.fillBack(result, this.getOrgAggPath(f.getUUID()).getVirtualOrgPathSet());
                        logDyList.add(this.getLog(f.toString(), f.getAggScopeStr()));
                    }
                });
            }
            formulaList.stream().filter(Formula::hasException).forEach(f -> logDyList.add(this.getLog(f.toString(), AdjustmentServiceHelper.toString_Adj(f.getException()))));
            if (logDyList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])logDyList.toArray(new DynamicObject[0]));
            }
            this.dimenScopeMap.clear();
        }
        this.aggFactorSet.clear();
        this.formulaOrgAggScope.clear();
        this.effectiveOrgSet = null;
        this.aggFactorMap.clear();
    }

    private void collectEffectiveOrgScope(List<GetJLEntryFormula> formulaList) {
        DimensionScope mergeScope = new DimensionScope(((Long)this.ctx.getModel().p1).toString(), this.ctx.getSctx().getDimensionByNumber("Entity"));
        formulaList.forEach(f -> mergeScope.addDimeMemRange(MemberReader.findEntityMemberByNum((String)((String)this.ctx.getModel().p2), (String)this.getParamItem((GetJLEntryFormula)f, "merge")).getId(), RangeEnum.VALUE_50.getValue()));
        FilterOrgStructParam param = new FilterOrgStructParam((long)((Long)this.ctx.getModel().p1), this.ctx.getScene(), this._ctx.getYear(), this.ctx.getPeriod());
        param.setAutoDelChild(false);
        this.effectiveOrgSet = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, new ArrayList<Long>(mergeScope.getResolveScopeIds())).keySet();
    }

    private void collectDiemensionParam(GetJLEntryFormula f, Map<String, Tuple<Dimension, IDNumberTreeNode, RangeEnum>> dimParamMap) {
        String dimItemParam = this.getParamItem(f, "dimensionMem");
        Dimension realDim = null;
        Dimension scopeDim = null;
        String memNum = null;
        RangeEnum dimScopeEnum = null;
        for (String dimParam : dimItemParam.split(",")) {
            dimScopeEnum = null;
            String[] splitArr = GetJLEntryFormula.splitDimAndMemb(this.handelParam(dimParam));
            switch (splitArr.length) {
                case 2: {
                    scopeDim = realDim = this.ctx.getSctx().getDimensionByShortNum(splitArr[0]);
                    memNum = splitArr[1];
                    break;
                }
                case 4: {
                    realDim = this.ctx.getSctx().getDimensionByShortNum(splitArr[0]);
                    scopeDim = this.ctx.getSctx().getDimensionByShortNum(splitArr[1]);
                    memNum = splitArr[2];
                    dimScopeEnum = RangeEnum.getRangeByNumber((String)splitArr[3]);
                    if (dimScopeEnum != null) break;
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), splitArr[3]))));
                    break;
                }
                default: {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), dimParam))));
                }
            }
            if (f.hasException()) break;
            if (realDim == null || scopeDim == null) {
                f.setException((Exception)((Object)new InvalidParamException("Dimension " + dimParam + " not found")));
                break;
            }
            IDNumberTreeNode memNode = MemberReader.findMemberByNumber((String)((String)this.ctx.getModel().p2), (String)scopeDim.getNumber(), (String)memNum);
            if (IDNumberTreeNode.NotFoundTreeNode == memNode) {
                f.setException((Exception)((Object)new InvalidParamException("Member " + dimParam + " not found")));
                break;
            }
            dimParamMap.put(realDim.getShortnum(), (Tuple<Dimension, IDNumberTreeNode, RangeEnum>)Tuple.create((Object)scopeDim, (Object)memNode, (Object)dimScopeEnum));
        }
    }

    private void analysisDiemensionParam(GetJLEntryFormula f, Map<String, Tuple<Dimension, IDNumberTreeNode, RangeEnum>> dimParamMap) {
        StringJoiner stringJoiner = new StringJoiner(",");
        StringJoiner showStringJoiner = new StringJoiner(",");
        String memNum = null;
        String showMemNum = null;
        this.ctx.getSctx().getDimensions().forEach(u -> dimParamMap.computeIfAbsent(u.getShortnum(), a -> this.getDefaultParamItem(u.getShortnum())));
        VersionParam versionParam = AdjustOperationHelper.createVersionParam((Long)this.ctx.getModel().p1, this.ctx.getScene(), this.ctx.getYear(), this.ctx.getPeriod());
        for (Dimension u2 : this.ctx.getSctx().getDimensions()) {
            Set<String> detailMemSet;
            Tuple<Dimension, IDNumberTreeNode, RangeEnum> dimParmItem = dimParamMap.get(u2.getShortnum());
            if (dimParmItem == null) {
                f.setException((Exception)((Object)new InvalidParamException("Dimension \"" + u2.getNumber() + "\" not found")));
                return;
            }
            Dimension scopeDim = (Dimension)dimParmItem.p1;
            IDNumberTreeNode memNode = (IDNumberTreeNode)dimParmItem.p2;
            RangeEnum rangeEnum = (RangeEnum)dimParmItem.p3;
            memNum = memNode.getNumber();
            DimensionScope dimensionScope = this.dimenScopeMap.computeIfAbsent(u2.getNumber(), a -> new DimensionScope(((Long)this.ctx.getModel().p1).toString(), u2));
            if (onlySingleSelectDimSet.contains(u2.getNumber())) {
                if (rangeEnum != null || !memNode.isLeaf()) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u5fc5\u987b\u4e3a\u660e\u7ec6\u8282\u70b9\u3002", (String)"GetJLEntryCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), u2.getNumber()))));
                    break;
                }
                if ("Currency".equals(u2.getNumber())) {
                    Tuple<Dimension, IDNumberTreeNode, RangeEnum> orgParmItem = dimParamMap.get(DimTypesEnum.ENTITY.getShortNumber());
                    if ("DC".equals(memNode.getNumber())) {
                        Tuple<Dimension, IDNumberTreeNode, RangeEnum> proParmItem = dimParamMap.get(DimTypesEnum.PROCESS.getShortNumber());
                        IDNumberTreeNode mergeNode = MemberReader.findEntityMemberByNum((String)this._ctx.getCubeNumber(), (String)this.getParamItem(f, "merge"));
                        if (ParamConstant.pcProList.contains(((IDNumberTreeNode)proParmItem.p2).getNumber()) && mergeNode != IDNumberTreeNode.NotFoundTreeNode) {
                            memNum = MemberReader.findEntityMemberByNum((String)this._ctx.getCubeNumber(), (String)this.getParamItem(f, "merge")).getCurrency();
                        } else if (orgParmItem != null) {
                            memNum = ((IDNumberTreeNode)orgParmItem.p2).getCurrency();
                        }
                    } else if ("EC".equals(memNode.getNumber())) {
                        memNum = ((IDNumberTreeNode)orgParmItem.p2).getCurrency();
                    }
                    dimParamMap.put(u2.getNumber(), (Tuple<Dimension, IDNumberTreeNode, RangeEnum>)Tuple.create((Object)scopeDim, (Object)MemberReader.findCurrencyMemberByNum((String)this._ctx.getCubeNumber(), (String)memNum), (Object)rangeEnum));
                } else if ("Process".equals(u2.getNumber()) && ("ERAdj".equals(memNode.getNumber()) || "RAdj".equals(memNode.getNumber()))) {
                    dimensionScope.addDimeMemRange(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)u2.getNumber(), (String)"RAdj").getId(), RangeEnum.VALUE_10.getValue());
                    dimensionScope.addDimeMemRange(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)u2.getNumber(), (String)"ERAdj").getId(), RangeEnum.VALUE_10.getValue());
                }
                dimensionScope.addDimeMemRange(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)u2.getNumber(), (String)memNum).getId(), RangeEnum.VALUE_10.getValue());
                showStringJoiner.add(u2.getShortnum() + '.' + (memNum != null && memNum.contains(".") ? "[" + memNum + "]" : memNum));
            } else if ("Entity".equals(u2.getNumber())) {
                Tuple<Dimension, IDNumberTreeNode, RangeEnum> proParmItem;
                if (rangeEnum == null) {
                    rangeEnum = RangeEnum.VALUE_10;
                    showMemNum = memNum;
                } else {
                    memNum = String.format("%s_%s_%s", scopeDim.getShortnum(), memNode.getNumber(), rangeEnum.getNumber());
                    showMemNum = String.format("%s.%s.%s", scopeDim.getShortnum(), memNode.getNumber(), rangeEnum.getNumber());
                }
                detailMemSet = "InternalCompany".equals(scopeDim.getNumber()) ? AdjustOperationHelper.queryIcMemberNumbersByRange(AdjustOperationHelper.createVersionParam((Long)this.ctx.getModel().p1, this.ctx.getScene(), this.ctx.getYear(), this.ctx.getPeriod()), memNode.getNumber(), rangeEnum) : QueryMemberDetailsHelper.queryMemberNumbersByRange(scopeDim.getEntity(), memNode.getId(), memNode.getNumber(), rangeEnum.getValue(), ((Long)this.ctx.getModel().p1).toString(), DetailTypeEnum.OTHERS);
                if (!"Entity".equals(scopeDim.getNumber())) {
                    detailMemSet.retainAll(((Map)MemberReader.getAllNodeByNumberFromCache((String)"bcm_entitymembertree", (String)((String)this.ctx.getModel().p2)).get("Entity")).keySet());
                }
                if ((proParmItem = dimParamMap.get(DimTypesEnum.PROCESS.getShortNumber())) != null) {
                    if (OrgRelaProcessMembPool.isRelaProcess((String)((IDNumberTreeNode)proParmItem.p2).getNumber())) {
                        IDNumberTreeNode mergeNode = MemberReader.findEntityMemberByNum((String)((String)this.ctx.getModel().p2), (String)this.getParamItem(f, "merge"));
                        if (IDNumberTreeNode.NotFoundTreeNode == mergeNode) {
                            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u5408\u5e76\u8282\u70b9\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.getParamItem(f, "merge")))));
                            break;
                        }
                        this.formulaOrgAggScope.put(f.getUUID(), this.resolveOrgAggScope(mergeNode, dimensionScope, detailMemSet, this.getParamItem(f, "mergescope")));
                    } else {
                        this.formulaOrgAggScope.put(f.getUUID(), this.resolveOrgAggScope(null, dimensionScope, detailMemSet, null));
                    }
                }
                showStringJoiner.add(u2.getShortnum() + '.' + showMemNum);
            } else if (rangeEnum == null) {
                dimensionScope.addDimeMemRange(MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)u2.getNumber(), (String)memNum).getId(), RangeEnum.VALUE_50.getValue());
                showStringJoiner.add(u2.getShortnum() + '.' + (memNum != null && memNum.contains(".") ? "[" + memNum + "]" : memNum));
            } else if ("InternalCompany".equals(u2.getNumber())) {
                detailMemSet = "InternalCompany".equals(scopeDim.getNumber()) ? AdjustOperationHelper.queryIcMemberNumbersByRange(versionParam, memNode.getNumber(), rangeEnum) : QueryMemberDetailsHelper.queryMemberNumbersByRange(scopeDim.getEntity(), memNode.getId(), memNode.getNumber(), rangeEnum.getValue(), ((Long)this.ctx.getModel().p1).toString(), DetailTypeEnum.OTHERS);
                memNum = String.format("%s_%s_%s", scopeDim.getShortnum(), memNode.getNumber(), rangeEnum.getNumber());
                showMemNum = String.format("%s.%s.%s", scopeDim.getShortnum(), memNode.getNumber(), rangeEnum.getNumber());
                showStringJoiner.add(u2.getShortnum() + '.' + showMemNum);
                for (String detailMem : detailMemSet) {
                    IDNumberTreeNode detailNode = BcmThreadCache.findMemberByNum((String)this._ctx.getCubeNumber(), (String)u2.getNumber(), (String)detailMem);
                    if (detailNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    dimensionScope.addDimeMemRange(detailNode.getId(), RangeEnum.VALUE_10.getValue());
                    AggOprtEnum aggOprtEnum = AggOprtEnum.getAggOprtEnumBynameNoThrow((String)detailNode.getAggOprt());
                    if (aggOprtEnum == null) {
                        aggOprtEnum = AggOprtEnum.NONE;
                    }
                    if (!this.aggFactorSet.add(String.format("%s(%s)", memNum, detailMem))) continue;
                    this.aggFactorMap.computeIfAbsent(u2.getNumber(), a -> Maps.newHashMap()).computeIfAbsent(memNum, a -> Lists.newArrayList()).add(OlapUtils.createAggFactorMetadataItem(detailMem, Integer.parseInt(aggOprtEnum.getSign())));
                }
                dimParamMap.put(u2.getNumber(), (Tuple<Dimension, IDNumberTreeNode, RangeEnum>)Tuple.create((Object)scopeDim, (Object)new IDNumberTreeNode(Long.valueOf(-1L), memNum, "", -1, -1, null, null, false, null, Long.valueOf(-1L), ""), (Object)rangeEnum));
            } else {
                f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u5176\u4ed6\u7ef4\u5ea6\u4e0d\u652f\u6301\u8be5\u79cd\u5199\u6cd5\u3002", (String)"GetJLEntryCalculate_5", (String)"fi-bcm-business", (Object[])new Object[0]))));
                break;
            }
            stringJoiner.add(u2.getShortnum() + '.' + (memNum != null && memNum.contains(".") ? "[" + memNum + "]" : memNum));
        }
        f.getParamList().set(indexMap.get("dimensionMem"), new ParamItem(showStringJoiner.toString()));
        f.setDimension(stringJoiner.toString());
    }

    private Tuple<Dimension, IDNumberTreeNode, RangeEnum> getDefaultParamItem(String shortNum) {
        Dimension u = this.ctx.getSctx().getDimensionByShortNum(shortNum);
        if (u != null) {
            String dimMemNum = null;
            if (!u.isIssys()) {
                dimMemNum = u.getShortnum() + "None";
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.ENTITY.getShortNumber())) {
                dimMemNum = (String)this._ctx.getProperty("org");
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.YEAR.getShortNumber())) {
                dimMemNum = this._ctx.getYear();
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.PERIOD.getShortNumber())) {
                dimMemNum = this._ctx.getPeriod();
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.SCENARIO.getShortNumber())) {
                dimMemNum = this._ctx.getScenario();
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.CURRENCY.getShortNumber())) {
                dimMemNum = this._ctx.getCurrency();
            } else if (u.getShortnum().equalsIgnoreCase(DimTypesEnum.PROCESS.getShortNumber())) {
                dimMemNum = (String)this._ctx.getProperty(DimTypesEnum.PROCESS.getShortNumber());
            }
            IDNumberTreeNode memNode = MemberReader.findMemberByNumber((String)((String)this.ctx.getModel().p2), (String)u.getNumber(), (String)dimMemNum);
            if (IDNumberTreeNode.NotFoundTreeNode != memNode) {
                return Tuple.create((Object)u, (Object)memNode, (Object)RangeEnum.VALUE_10);
            }
        }
        return null;
    }

    private AggFactorPath resolveOrgAggScope(IDNumberTreeNode mergeNode, DimensionScope dimensionScope, Set<String> detailMemSet, String mergeScope) {
        AggFactorPath orgAggPath = new AggFactorPath();
        detailMemSet.forEach(detailOrg -> {
            dimensionScope.addDimeMemRange(BcmThreadCache.findMemberByNum((String)this._ctx.getCubeNumber(), (String)"Entity", (String)detailOrg).getId(), RangeEnum.VALUE_10.getValue());
            if (mergeNode == null) {
                orgAggPath.addOrgAggPath(null, (String)detailOrg);
            } else {
                MemberReader.findEntityMemberByPredicate((String)((String)this.ctx.getModel().p2), (String)detailOrg, detailNode -> {
                    if (detailNode.getLongNumber().startsWith(mergeNode.getLongNumber().concat("!"))) {
                        this.orgAggPathTemp.clear();
                        do {
                            if (RangeEnum.VALUE_10.getNumber().equals(mergeScope) && !detailNode.getParent().getNumber().equals(mergeNode.getNumber())) continue;
                            if (!this.effectiveOrgSet.contains(detailNode.getId())) {
                                this.orgAggPathTemp.clear();
                            }
                            if (!MergeStructConfig.get().isPartakeMerge((Long)this.ctx.getModel().p1, this.ctx.getScene(), this.ctx.getYear(), this.ctx.getPeriod(), detailNode.getParent().getNumber(), detailNode.getNumber())) {
                                this.orgAggPathTemp.clear();
                            }
                            this.orgAggPathTemp.addOrgAggPath((IDNumberTreeNode)detailNode, (String)detailOrg);
                        } while (!(detailNode = detailNode.getParent()).getNumber().equals(mergeNode.getNumber()));
                        orgAggPath.mergeOrgAggPath(this.orgAggPathTemp);
                    }
                    return false;
                });
            }
        });
        return orgAggPath;
    }

    private AggFactorPath getOrgAggPath(String formulaId) {
        return this.formulaOrgAggScope.getOrDefault(formulaId, AggFactorPath.emptyOrgAggPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDResultSet queryRecomputeEntryData(Map<String, DimensionScope> dimenScope, String computeType) {
        String[] tarStatus = this.resolvegComputeType(computeType);
        Set<String> allRealOrgPath = this.getAllRealOrgPath();
        if (CollectionUtils.isEmpty(allRealOrgPath)) {
            return null;
        }
        HashMap<String, Collection<String>> dimenScopeMap = new HashMap<String, Collection<String>>(16);
        for (Map.Entry<String, DimensionScope> p : dimenScope.entrySet()) {
            if (p.getValue().isEmpty()) {
                return null;
            }
            dimenScopeMap.put(p.getKey(), p.getValue().getResolveScopes());
        }
        dimenScopeMap.put("olaporg", allRealOrgPath);
        OlapSandBoxContext.get().openSandBoxEnv((String)this.ctx.getModel().p2);
        MDResultSet rs = null;
        try {
            this.clearRelatedData(dimenScopeMap);
            AdjustCheckServiceHelper.recomputeAuditData(this.ctx, dimenScopeMap, tarStatus);
            SQLBuilder sqb = this.createSQLBuilder(dimenScope);
            if (sqb != null) {
                rs = OlapServiceHelper.queryData(sqb);
            }
        }
        finally {
            OlapSandBoxContext.get().closeSandBoxEnv((String)this.ctx.getModel().p2);
        }
        return rs;
    }

    private String[] resolvegComputeType(String computeType) {
        switch (computeType = computeType.trim()) {
            case "0": {
                return new String[]{RptAdjustStatusEnum.SAVE.status(), RptAdjustStatusEnum.BACK.status(), RptAdjustStatusEnum.TEMPSAVE.status(), RptAdjustStatusEnum.COMMIT.status()};
            }
            case "1": {
                return new String[]{RptAdjustStatusEnum.AUDIT.status(), RptAdjustStatusEnum.SAVE.status(), RptAdjustStatusEnum.BACK.status(), RptAdjustStatusEnum.TEMPSAVE.status(), RptAdjustStatusEnum.COMMIT.status()};
            }
        }
        return new String[]{RptAdjustStatusEnum.AUDIT.status()};
    }

    private void clearRelatedData(Map<String, Collection<String>> dimScope) {
        RunScriptBuilder run = new RunScriptBuilder((String)this.ctx.getModel().p2);
        Collection<String> sceneScope = dimScope.remove("Scenario");
        dimScope.forEach((dimnum, memNums) -> {
            if (!"Entity".equals(dimnum)) {
                if ("olaporg".equals(dimnum)) {
                    run.addDimensionScope("Entity", memNums.toArray(new String[0]));
                } else {
                    run.addDimensionScope((String)dimnum, memNums.toArray(new String[0]));
                }
            }
        });
        sceneScope.forEach(p -> {
            run.appendV((PairList<String, String>)PairList.newWithParam((Object)"Scenario", (Object)p));
            run.appendEqualSign();
            run.appendStr(null);
            run.endRunExpress();
            run.runScript();
        });
    }

    private DynamicObject getLog(String formula, String log) {
        return DataCollectServiceHelper.getLog(formula, (Long)this._ctx.getProperty("templateId"), (Long)this._ctx.getProperty("originOrg"), 0, (Long)this.ctx.getModel().p1, this.ctx.getPeriod(), this.ctx.getScene(), this.ctx.getYear(), log, null);
    }

    private SQLBuilder createSQLBuilder(Map<String, DimensionScope> dimenScopeMap) {
        SQLBuilder sql = new SQLBuilder((String)this.ctx.getModel().p2);
        DimensionScope ds = null;
        String[] dimScope = null;
        for (String dimKey : this.ctx.getDimKeys()) {
            sql.addSelectField(dimKey);
            dimScope = null;
            if ("Entity".equals(dimKey)) {
                dimScope = this.getAllVirtualOrgPath().toArray(new String[0]);
                if (dimScope.length == 0) {
                    this.log.error(String.format("DimensionScope %s isEmpty,detail msg %s,%s", dimKey, dimScope, this.formulaOrgAggScope));
                    return null;
                }
            } else {
                ds = dimenScopeMap.get(dimKey);
                if (ds != null) {
                    Set<String> dimSet = ds.getNoResolveScopes();
                    Map<String, List<AggFactorMetadataItem>> aggFactorList = this.aggFactorMap.get(dimKey);
                    if (aggFactorList != null && !CollectionUtil.isEmpty(aggFactorList.keySet())) {
                        OlapServiceHelper.batchCreateDimensionMembers((String)this.ctx.getModel().p2, dimKey, aggFactorList.keySet().toArray(new String[0]));
                        OlapServiceHelper.batchAlterMemberStorageType((String)this.ctx.getModel().p2, dimKey, aggFactorList.keySet().stream().collect(Collectors.toMap(p -> p, p -> MemberStorageTypes.DynamicCalc)));
                        OlapServiceHelper.batchAlterAggFactorNoRetry((String)this.ctx.getModel().p2, dimKey, aggFactorList);
                        dimSet.addAll(aggFactorList.keySet());
                    }
                    dimScope = dimSet.toArray(new String[0]);
                }
            }
            if (dimScope == null || dimScope.length == 0) {
                throw new KDBizException(String.format("DimensionScope %s isEmpty,detail msg %s,%s", dimKey, dimScope, ds));
            }
            sql.addFilter(dimKey, dimScope);
        }
        sql.setExcludeDynaData(false);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.setIncludeNull(false);
        return sql;
    }

    private Set<String> getAllVirtualOrgPath() {
        HashSet<String> olapAggPathScope = new HashSet<String>(50);
        this.formulaOrgAggScope.values().forEach(orgAggPath -> olapAggPathScope.addAll(orgAggPath.getVirtualOrgPathSet()));
        olapAggPathScope.removeAll(OlapServiceHelper.batCheckMemberIsExistOlap("Entity", olapAggPathScope.toArray(new String[0]), (String)this.ctx.getModel().p2));
        return olapAggPathScope;
    }

    private Set<String> getAllRealOrgPath() {
        HashSet<String> olapAggPathScope = new HashSet<String>(50);
        this.formulaOrgAggScope.values().forEach(orgAggPath -> olapAggPathScope.addAll(orgAggPath.getRealOrgPathOrg()));
        return olapAggPathScope;
    }

    protected String handelParam(Object p) {
        return p == null ? "" : p.toString().trim().replace("\"", "");
    }

    public static boolean isFromGetJLEntryCalculate() {
        return ThreadCache.exists((Object)GetJLEntryCalculate.class.getClass().getName());
    }
}

