/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.chk;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.chk.XFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections.CollectionUtils;

public class XCalculate
extends AbstractCalculate<XFormula> {
    @Override
    protected void execCalculate(List<XFormula> formulas) {
        formulas.forEach(f -> {
            Map<String, Object> params = this.putDefaultParams();
            ParamList paramList = f.getParamList();
            CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)((ParamItem)paramList.get(0)).toString());
            String script = (String)xdmFormulaBuilder.getCondition("extendsFormula");
            if (paramList.size() > 1) {
                for (ParamItem paramItem : paramList) {
                    if (!(paramItem.getParam() instanceof StringExpr)) continue;
                    String value = ((StringExpr)paramItem.getParam()).getValue();
                    String[] split = value.split("\\.", 2);
                    if (!DimTypesEnum.PROCESS.getShortNumber().equals(split[0])) continue;
                    String processNumber = split[split.length - 1];
                    params.put(DimTypesEnum.PROCESS.getNumber(), Pair.onePair((Object)MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)DimTypesEnum.PROCESS.getNumber(), (String)processNumber).getId(), (Object)processNumber));
                }
            }
            if (params.get(DimTypesEnum.CURRENCY.getNumber()) == null && params.get(DimTypesEnum.PROCESS.getNumber()) != null && params.get(DimTypesEnum.PROCESS.getNumber()) instanceof Pair) {
                String currency = ChkCheckServiceHelper.getCurrency(this._ctx, (String)((Pair)params.get((Object)DimTypesEnum.PROCESS.getNumber())).p2, null);
                params.put(DimTypesEnum.CURRENCY.getNumber(), Pair.onePair((Object)MemberReader.findCurrencyMemberByNum((String)this._ctx.getCubeNumber(), (String)currency).getId(), (Object)currency));
            }
            if (params.get(DimTypesEnum.AUDITTRIAL.getNumber()) == null) {
                params.put(DimTypesEnum.AUDITTRIAL.getNumber(), Pair.onePair((Object)MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)"ATTotal").getId(), (Object)"ATTotal"));
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)xdmFormulaBuilder.getDim(entry.getKey()))) continue;
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)entry.getKey(), (String)xdmFormulaBuilder.getDim(entry.getKey()));
                params.put(entry.getKey(), Pair.onePair((Object)node.getId(), (Object)node.getNumber()));
            }
            xdmFormulaBuilder.addCondition("extendsFormula", script);
            ((ParamItem)paramList.get(0)).fixParam(ObjectSerialUtil.toByteSerialized((Object)xdmFormulaBuilder));
            try {
                String cube = this._ctx.getCubeNumber();
                String dataModel = (String)xdmFormulaBuilder.getCondition("extendsmodel");
                String fieldNumber = (String)xdmFormulaBuilder.getCondition("extendsfield");
                List extendsMdFieldsValue = (List)xdmFormulaBuilder.getCondition("extendsmdfieldvalue");
                HashMap<String, String> dimScope = new HashMap<String, String>();
                if (CollectionUtils.isNotEmpty((Collection)extendsMdFieldsValue)) {
                    Map<String, Tuple<String, String, String>> dimensionsInfo = QueryDimensionServiceHelper.getDimensionsInfo(MemberReader.findModelIdByNum((String)cube));
                    for (Tuple tuple : extendsMdFieldsValue) {
                        String lowerDimNumber = ((String)tuple.p1).substring(12);
                        if (tuple.p3 == null) continue;
                        Optional<Tuple> optional = dimensionsInfo.values().stream().filter(dim -> ((String)dim.p1).equalsIgnoreCase(lowerDimNumber)).findFirst();
                        optional.ifPresent(stringStringStringTuple -> {
                            String cfr_ignored_0 = (String)dimScope.put((String)stringStringStringTuple.p1, (String)tuple.p3);
                        });
                    }
                }
                List extScope = (List)xdmFormulaBuilder.getCondition("entryconditions");
                HashMap<String, Pair<Long, String>> methodParams = new HashMap<String, Pair<Long, String>>();
                params.forEach((key, val) -> {
                    if (val instanceof Pair) {
                        methodParams.put((String)key, (Pair<Long, String>)((Pair)val));
                    }
                });
                BigDecimal result = ScriptBuiltinExtHelper.getColSum(cube, dataModel, fieldNumber, methodParams, dimScope, extScope);
                if (BigDecimal.ZERO.compareTo(result) == 0) {
                    result = BigDecimal.ZERO;
                }
                f.fillBack(result);
            }
            catch (Exception e) {
                this.log.error(String.format("excuteScript error![%s]", script), (Throwable)e);
                f.setException(e);
            }
        });
    }

    private String formatDim(String dim, String dimNumber) {
        return String.format("%s['%s']", dim, dimNumber);
    }

    private Map<String, Object> putDefaultParams() {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (DimTypesEnum contextDimension : ParamConstant.CONTEXT_DIMENSIONS_ENUM) {
            String contextValue;
            String number = contextDimension.getNumber();
            if (contextDimension == DimTypesEnum.ENTITY) {
                contextValue = this._ctx.getOrg();
                params.put(contextDimension.getNumber(), Pair.onePair((Object)ChkCheckServiceHelper.getRealOrgId(this._ctx), (Object)contextValue));
                continue;
            }
            contextValue = (String)this._ctx.getProperty(number.toLowerCase(Locale.ENGLISH));
            if (contextValue == null) {
                params.put(contextDimension.getNumber(), null);
                continue;
            }
            params.put(contextDimension.getNumber(), Pair.onePair((Object)MemberReader.findMemberByNumber((String)this._ctx.getCubeNumber(), (String)contextDimension.getNumber(), (String)contextValue).getId(), (Object)contextValue));
        }
        return params;
    }

    @Override
    protected void initFormula() {
    }
}

