/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.ctx;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.IExternalDataProvider;
import kd.fi.bcm.business.formula.calculate.INestDataProvider;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.IFormulaHandle;
import kd.fi.bcm.business.formula.model.value.ICollectResultHandle;
import kd.fi.bcm.business.formula.model.value.ICollectStableResultHandle;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.ToStringHelper;

public abstract class AbstractCalContext
implements ICalContext,
Serializable {
    public static final long serialVersionUID = 1L;
    private final String cubeNumber;
    private final Map<String, Object> properties;
    private INestDataProvider provider;
    private IExternalDataProvider externalProvider;
    private IFormulaHandle fhandle;
    private IFormulaHandle defaultParamHandle;
    private ICollectResultHandle collectResultHandle;
    private ICollectStableResultHandle collectStableResultHandle;
    private Predicate<IFormula> predicate;
    private IFormulaHandle vFormulaPeriodHandle;
    private Map<String, Tuple<String, String, String>> convertParam = new HashMap<String, Tuple<String, String, String>>(16);

    public AbstractCalContext(String cubeNumber) {
        this.cubeNumber = cubeNumber;
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public String getCubeNumber() {
        return this.cubeNumber;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    @Override
    public <T> void setProperty(String key, T val) {
        this.properties.put(key, val);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }

    @Override
    public void setNestDataProvider(INestDataProvider ndp) {
        this.provider = ndp;
    }

    @Override
    public INestDataProvider getNestDataProvider() {
        return this.provider;
    }

    @Override
    public IExternalDataProvider getExternalDataProvider() {
        return this.externalProvider;
    }

    @Override
    public void setExternalDataProvider(IExternalDataProvider ndp) {
        this.externalProvider = ndp;
    }

    @Override
    public CalculateService getCalculateService() {
        return (CalculateService)this.getProperty("calculateService");
    }

    @Override
    public void setFormulaHandle(IFormulaHandle handle) {
        this.fhandle = handle;
    }

    @Override
    public IFormulaHandle getFormulaHandle() {
        return this.fhandle;
    }

    @Override
    public void setDefaultParamHandle(IFormulaHandle handle) {
        this.defaultParamHandle = handle;
    }

    @Override
    public IFormulaHandle getDefaultParamHandle() {
        return this.defaultParamHandle;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setCollectResultHandle(ICollectResultHandle handle) {
        this.collectResultHandle = handle;
    }

    @Override
    public ICollectResultHandle getCollectResultHandle() {
        return this.collectResultHandle;
    }

    @Override
    public void setCollectStableResultHandle(ICollectStableResultHandle handle) {
        this.collectStableResultHandle = handle;
    }

    @Override
    public ICollectStableResultHandle getCollectStableResultHandle() {
        return this.collectStableResultHandle;
    }

    @Override
    public void setCheckFormulaHandle(Predicate<IFormula> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Predicate<IFormula> getCheckFormulaHandle() {
        return this.predicate;
    }

    @Override
    public void setVFormulaPeriodHandle(IFormulaHandle handle) {
        this.vFormulaPeriodHandle = handle;
    }

    @Override
    public IFormulaHandle getVFormulaPeriodHandle() {
        return this.vFormulaPeriodHandle;
    }

    @Override
    public Map<String, Tuple<String, String, String>> getConvertParam() {
        return this.convertParam;
    }
}

