/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.cvt;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.model.cvt.CvtFormula;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.CvtFactorEnum;

public class CvtCalculate
extends AbstractCalculate<CvtFormula> {
    private FelCalculateEngine engine;

    @Override
    protected void execCalculate(List<CvtFormula> formulas) {
        for (CvtFormula cvtformula : formulas) {
            Object result = this.engine.calculate(this.getFormulaNumber(cvtformula.toString()));
            cvtformula.setValue(result);
        }
    }

    private String getFormulaNumber(String formula) {
        return (String)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("factorenum2number" + formula), () -> {
            Optional<CvtFactorEnum> myfator = Arrays.stream(CvtFactorEnum.values()).filter(s -> Objects.equals("CVT(\"cvtfactor@" + s + "\")", formula) || Objects.equals("CVT(\"exchange@" + s + "\")", formula) || Objects.equals("CVT(\"preexchange@" + s + "\")", formula)).findFirst();
            if (myfator.isPresent()) {
                return myfator.get().name();
            }
            return formula;
        });
    }

    @Override
    protected void initFormula() {
        this.engine = this._ctx.getCalculateService().getCalculateEngine();
    }
}

