/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.excelformula.IFFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.spread.formula.ICustomerFormat;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public abstract class ExcelFormulaCalculate
extends AbstractCalculate<IFFormula> {
    @Override
    protected void execCalculate(List<IFFormula> formulas) {
        for (IFormula iFormula : formulas) {
            try {
                this.calculateFormula(iFormula);
            }
            catch (Exception e) {
                iFormula.setException(e);
            }
        }
    }

    @Override
    protected void initFormula() {
    }

    protected abstract void calculateFormula(IFormula var1);

    protected boolean calcPredicateExpr(ParamItem item) {
        Object predicateParam = item.getParam();
        return this.calcPredicateExpr(predicateParam);
    }

    protected boolean calcPredicateExpr(Object predicateParam) {
        if (predicateParam == null) {
            return false;
        }
        if (predicateParam instanceof Boolean) {
            return (Boolean)predicateParam;
        }
        if (predicateParam instanceof String) {
            if (Boolean.parseBoolean((String)predicateParam)) {
                return true;
            }
            if ("false".equalsIgnoreCase((String)predicateParam)) {
                return false;
            }
            return "1".equals(predicateParam);
        }
        if (predicateParam instanceof Number) {
            return ((Number)predicateParam).doubleValue() >= 1.0;
        }
        if (predicateParam instanceof BinaryOperationExpr) {
            Object v = this.calSingleExpr((BinaryOperationExpr)predicateParam);
            return this.calcPredicateExpr(v);
        }
        if (predicateParam instanceof Exception) {
            if (this.calcErrorDefaultHandle()) {
                return false;
            }
            throw new KDBizException(((Exception)predicateParam).getMessage());
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a%s\u3002", (String)"ExcelFormulaCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), predicateParam.getClass().getName()));
    }

    public boolean calcErrorDefaultHandle() {
        return false;
    }

    private Object calSingleExpr(BinaryOperationExpr predicateParam) {
        StringBuffer buffer = new StringBuffer();
        predicateParam.output(buffer, new ICustomerFormat(){

            public void beforeOutput(Expression ex, StringBuffer sb) {
            }

            public void afterOutput(Expression ex, StringBuffer sb) {
            }

            public String formatOP(String op) {
                return "=".equals(op) ? "==" : ("<>".equals(op) ? "!=" : op);
            }
        });
        return this._ctx.getCalculateService().getCalculateEngine().calculate(buffer.toString().replace("NULL", "0"));
    }

    protected Object calcExpr(Object exprParam) {
        if (((ParamItem)exprParam).getParam() instanceof StringExpr) {
            return exprParam.toString();
        }
        if (exprParam.toString().trim().equals("")) {
            return null;
        }
        if (((ParamItem)exprParam).getParam() instanceof BinaryOperationExpr) {
            return this.calSingleExpr((BinaryOperationExpr)((ParamItem)exprParam).getParam());
        }
        return this._ctx.getCalculateService().getCalculateEngine().calculate(exprParam.toString());
    }
}

