/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.spread.formula.util.AreaReference;
import kd.fi.bcm.spread.formula.util.CellReference;
import org.apache.commons.collections.CollectionUtils;

public class MAXCalculate
extends ExcelFormulaCalculate {
    @Override
    protected void calculateFormula(IFormula f) {
        if (CollectionUtils.isEmpty((Collection)f.getParamList())) {
            f.setException((Exception)((Object)new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MAXCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        BigDecimal maximum = null;
        try {
            for (ParamItem paramItem : f.getParamList()) {
                maximum = MAXCalculate.getMaximum(maximum, (BigDecimal)this.calcExpr(paramItem));
            }
        }
        catch (Exception e) {
            f.setException(e);
            return;
        }
        f.setValue(maximum);
    }

    @Override
    protected Object calcExpr(Object exprParam) {
        Object param = ((ParamItem)exprParam).getParam();
        if (param instanceof AreaReference) {
            BigDecimal maximum = null;
            CellReference[] area = ((AreaReference)param).getCells();
            Object v = null;
            String cellName = "";
            for (int r = area[0].getRow(); r <= area[1].getRow(); ++r) {
                for (int c = area[0].getCol(); c <= area[1].getCol(); ++c) {
                    cellName = ExcelUtils.xy2Pos((int)c, (int)r);
                    v = this.getRefValue(cellName, new ParamItem(cellName));
                    if (!(v instanceof Number)) continue;
                    BigDecimal current = new BigDecimal(FelCalculateEngine.formatNumberString(v));
                    maximum = MAXCalculate.getMaximum(maximum, current);
                }
            }
            return maximum;
        }
        if (param instanceof Number) {
            return new BigDecimal(param.toString());
        }
        Object result = super.calcExpr(exprParam);
        if (result instanceof Number) {
            return new BigDecimal(param.toString());
        }
        return null;
    }

    private static BigDecimal getMaximum(BigDecimal maximum, BigDecimal current) {
        if (maximum == null) {
            maximum = current;
        } else if (current != null && current.compareTo(maximum) > 0) {
            maximum = current;
        }
        return maximum;
    }
}

