/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;

public class MonthCalculate
extends ExcelFormulaCalculate {
    private String getYear() {
        return ResManager.getLocaleString((String)"\u5e74", (String)"MonthCalculate_5", (String)"fi-bcm-business").getLocaleValue_zh_CN();
    }

    private String getMonth() {
        return ResManager.getLocaleString((String)"\u6708", (String)"MonthCalculate_6", (String)"fi-bcm-business").getLocaleValue_zh_CN();
    }

    private String getStage() {
        return ResManager.getLocaleString((String)"\u671f", (String)"MonthCalculate_7", (String)"fi-bcm-business").getLocaleValue_zh_CN();
    }

    private String getSeason() {
        return ResManager.getLocaleString((String)"\u5b63", (String)"MonthCalculate_8", (String)"fi-bcm-business").getLocaleValue_zh_CN();
    }

    @Override
    protected void calculateFormula(IFormula f) {
        ParamList pl = f.getParamList();
        if (pl.size() != 1) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"month\u51fd\u6570\u53ea\u80fd\u67091\u4e2a\u53c2\u6570\uff0c\u4f46\u5f53\u524d\u8bbe\u7f6e\u4e86%1$s\u4e2a\u3002", (String)"MonthCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), pl.size()))));
            return;
        }
        Object p1 = ((ParamItem)pl.get(0)).getParam();
        if (p1 == null || p1 != null && (p1.equals(0) || p1.toString().contentEquals("0"))) {
            f.setValue(BigInteger.valueOf(12L));
            return;
        }
        Integer result = 0;
        String compileDate = ResManager.getLocaleString((String)"\u7f16\u5236\u65e5\u671f\uff1a", (String)"MonthCalculate_4", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        try {
            if (p1.toString().startsWith("/OADate")) {
                double d = Double.parseDouble(p1.toString().substring(p1.toString().indexOf("(") + 1, p1.toString().indexOf(")")));
                result = this.covertFromOADateMonth(d);
            } else if (p1.toString().contains(compileDate)) {
                String[] split = p1.toString().split("\uff1a");
                result = this.getMonthByPatern(split[1]);
                if (result != 0) {
                    f.setValue(BigInteger.valueOf(result.intValue()));
                    return;
                }
                if (split.length != 2 || !split[1].contains(this.getYear()) || !split[1].contains(this.getMonth()) && !split[1].contains(this.getStage()) && !split[1].contains(this.getSeason())) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"MONTH\u51fd\u6570\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u201c%1$s\u201d\u7684\u65e5\u671f\u683c\u5f0f\u3002", (String)"MonthCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), p1.toString()))));
                    return;
                }
                result = this.getMonthStr(split[1]);
            } else if (p1.toString().contains(this.getYear()) && (p1.toString().contains(this.getMonth()) || p1.toString().contains(this.getStage()) || p1.toString().contains(this.getSeason()))) {
                result = this.getMonthStr(p1.toString());
            } else {
                result = this.getMonthByPatern(p1.toString());
                if (result == 0) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"MONTH\u51fd\u6570\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u201c%1$s\u201d\u7684\u65e5\u671f\u683c\u5f0f\u3002", (String)"MonthCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), p1.toString()))));
                    return;
                }
            }
        }
        catch (Exception e) {
            f.setException(e);
            return;
        }
        f.setValue(BigInteger.valueOf(result.intValue()));
    }

    private Integer getMonthByPatern(String str1) throws ParseException {
        String pattern = "";
        if (str1.matches("^\\d{4}[-]\\d{2}.*")) {
            pattern = "yyyy-MM";
        } else if (str1.matches("^\\d{4}[/]\\d{2}.*")) {
            pattern = "yyyy/MM";
        } else {
            if (str1.matches("^\\d{6}.*")) {
                return Integer.parseInt(str1.substring(4, 6));
            }
            return 0;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(str1);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    private Integer getMonthStr(String str) {
        Integer result = 0;
        if (str.contains(this.getStage()) || str.contains(this.getSeason())) {
            String tempStr = str.substring(str.indexOf(this.getYear()) + 1, str.indexOf(this.getStage()) == -1 ? str.indexOf(this.getSeason()) : str.indexOf(this.getStage())).trim();
            StringBuilder str1 = new StringBuilder();
            for (int i = 0; i < tempStr.length(); ++i) {
                if (tempStr.charAt(i) < '0' || tempStr.charAt(i) > '9') continue;
                str1.append(tempStr.charAt(i));
            }
            result = Integer.parseInt(str1.toString());
            result = result * 3 > 12 ? 12 : result * 3;
        } else if (str.contains(this.getMonth())) {
            result = Integer.parseInt(str.substring(str.indexOf(this.getYear()) + 1, str.indexOf(this.getMonth())).trim());
        }
        return result;
    }

    private Integer covertFromOADateMonth(double d) throws ParseException {
        SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
        Date baseDate = myFormat.parse("30 12 1899");
        Calendar c = Calendar.getInstance();
        c.setTime(baseDate);
        c.add(5, (int)d);
        return c.get(2) + 1;
    }
}

