/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.excelformula.TextFormulaCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import org.apache.commons.lang.StringUtils;

public class NUMBERVALUECalculate
extends TextFormulaCalculate {
    @Override
    protected void fillBackValue(IFormula f) {
        String text = (String)this.paramMap.get(0);
        String decimalSeparator = (String)this.paramMap.get(1);
        String groupSeparator = (String)this.paramMap.get(2);
        if (NUMBERVALUECalculate.invalidResult(f, text)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)decimalSeparator)) {
            decimalSeparator = decimalSeparator.substring(0, 1);
        }
        if (StringUtils.isNotEmpty((String)groupSeparator)) {
            groupSeparator = groupSeparator.substring(0, 1);
        }
        if (this.invalidDecimalAndGroup(f, text, decimalSeparator, groupSeparator)) {
            return;
        }
        text = text.replace(" ", "").replace(groupSeparator, "");
        this.calculatePercent(f, text);
    }

    private static boolean invalidResult(IFormula f, Object result) {
        if (result == null) {
            f.setValue(BigDecimal.ZERO);
            return true;
        }
        if (result instanceof Exception) {
            f.setException((Exception)result);
            return true;
        }
        return false;
    }

    private boolean invalidDecimalAndGroup(IFormula f, String text, String decimalSeparator, String groupSeparator) {
        if (decimalSeparator != null) {
            if (text.length() - text.replace(decimalSeparator, "").length() > 1) {
                f.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u5c0f\u6570\u5206\u9694\u7b26\u201c%s\u201d\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\u3002", (String)"NUMBERVALUECalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), decimalSeparator))));
                return true;
            }
            if (groupSeparator != null && text.indexOf(groupSeparator) > text.indexOf(decimalSeparator)) {
                f.setValue((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u5206\u9694\u7b26\u201c%1$s\u201d\u4e0d\u5f97\u4f4d\u4e8e\u5c0f\u6570\u5206\u9694\u7b26\u201c%2$s\u201d\u4e4b\u540e\u3002", (String)"NUMBERVALUECalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), groupSeparator, decimalSeparator)));
                return true;
            }
        }
        return false;
    }

    private void calculatePercent(IFormula f, String text) {
        int countPercent = 0;
        while (text.contains("%")) {
            if (text.lastIndexOf("%") != text.length() - 1) {
                f.setValue((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u672c\u5185\u5bb9\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8f6c\u6210\u6570\u5b57\u3002", (String)"NUMBERVALUECalculate_6", (String)"fi-bcm-business", (Object[])new Object[0]), text)));
                return;
            }
            text = text.substring(0, text.length() - 1);
            ++countPercent;
        }
        try {
            BigDecimal value = new BigDecimal(text);
            for (int i = 0; i < countPercent; ++i) {
                value = value.divide(BigDecimal.valueOf(100L));
            }
            f.setValue(value);
        }
        catch (Exception e) {
            f.setValue((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u672c\u5185\u5bb9\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8f6c\u6210\u6570\u5b57\u3002", (String)"NUMBERVALUECalculate_6", (String)"fi-bcm-business", (Object[])new Object[0]), text)));
        }
    }

    @Override
    protected int getMinParamSize() {
        return 1;
    }

    @Override
    protected int getMaxParamSize() {
        return 3;
    }
}

