/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigDecimal;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.value.Value;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.util.AreaReference;
import kd.fi.bcm.spread.formula.util.CellReference;

public class SumCalculate
extends ExcelFormulaCalculate {
    @Override
    protected void calculateFormula(IFormula f) {
        ParamList pList = f.getParamList();
        BigDecimal sum = new BigDecimal("0");
        for (ParamItem item : pList) {
            if (item.getParam() == null) continue;
            if (item.getParam() instanceof AreaReference) {
                AreaReference ref = (AreaReference)item.getParam();
                CellReference[] area = ref.getCells();
                Object v = null;
                String cellName = "";
                for (int r = area[0].getRow(); r <= area[1].getRow(); ++r) {
                    for (int c = area[0].getCol(); c <= area[1].getCol(); ++c) {
                        cellName = ExcelUtils.xy2Pos((int)c, (int)r);
                        v = this.getRefValue(cellName, new ParamItem(cellName));
                        if (!(v instanceof Number)) continue;
                        sum = sum.add(new BigDecimal(FelCalculateEngine.formatNumberString(v)));
                    }
                }
                continue;
            }
            if (item.getParam() instanceof Number) {
                sum = sum.add(new BigDecimal(FelCalculateEngine.formatNumberString(item.getParam())));
                continue;
            }
            if (item.getParam() instanceof BinaryOperationExpr) {
                Object va = FelCalculateEngine.engine(name -> new Value(this.getRefValue(name, new ParamItem(name)))).calculate(item.getParam().toString());
                if (va instanceof Number) {
                    sum = sum.add(new BigDecimal(FelCalculateEngine.formatNumberString(va.toString())));
                    continue;
                }
                throw new EvalException("not support sum function format:" + f);
            }
            throw new EvalException("not support sum function format:" + f);
        }
        f.setValue(sum);
    }
}

