/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigDecimal;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import org.apache.commons.lang3.StringUtils;

public class SumIfCalculate
extends ExcelFormulaCalculate {
    @Override
    protected void calculateFormula(IFormula f) {
        BigDecimal sum;
        ParamList pList = f.getParamList();
        if (pList.size() == 2 || pList.size() == 3) {
            sum = new BigDecimal("0");
            if (!(((ParamItem)pList.get(0)).getParam() instanceof AreaExpr)) {
                throw new EvalException("not support sumif function format:" + f);
            }
            AreaExpr ref0 = (AreaExpr)((ParamItem)pList.get(0)).getParam();
            Object v = null;
            String cellName = "";
            boolean isequal = ((ParamItem)pList.get(1)).getParam() instanceof Number;
            String leftValue = ((ParamItem)pList.get(1)).toString();
            if (!isequal && this.isEqualsType(leftValue)) {
                isequal = true;
                if (leftValue.charAt(0) == '=') {
                    leftValue = leftValue.substring(1);
                }
            }
            boolean replace = pList.size() == 3;
            int diffrol = 0;
            int diffcol = 0;
            if (replace) {
                if (!(((ParamItem)pList.get(2)).getParam() instanceof AreaExpr)) {
                    throw new EvalException("not support sumif function format:" + f);
                }
                AreaExpr ref2 = (AreaExpr)((ParamItem)pList.get(2)).getParam();
                diffrol = ref2.getStart_row() - ref0.getStart_row();
                diffcol = ref2.getStart_col() - ref0.getStart_col();
            }
            boolean likeSearch = false;
            if (leftValue.contains("*")) {
                likeSearch = true;
                leftValue = StringUtils.strip((String)leftValue, (String)"*");
            }
            for (int r = ref0.getStart_row(); r <= ref0.getEnd_row(); ++r) {
                for (int c = ref0.getStart_col(); c <= ref0.getEnd_col(); ++c) {
                    Object va;
                    cellName = ExcelUtils.xy2Pos((int)c, (int)r);
                    v = this.getRefValue(cellName, new ParamItem(cellName));
                    if (isequal) {
                        va = likeSearch ? Boolean.valueOf(v.toString().contains(leftValue)) : Boolean.valueOf(v.toString().equals(leftValue));
                    } else {
                        String formulula = v.toString() + leftValue;
                        va = this.getFelEngine().calculate(formulula);
                    }
                    if (va instanceof Exception) {
                        va = v.toString().equals(((ParamItem)pList.get(1)).toString());
                    }
                    if (!Boolean.parseBoolean(va.toString())) continue;
                    if (replace) {
                        cellName = ExcelUtils.xy2Pos((int)(c + diffcol), (int)(r + diffrol));
                        v = this.getRefValue(cellName, new ParamItem(cellName));
                    }
                    if (!(v instanceof Number)) continue;
                    sum = sum.add(new BigDecimal(FelCalculateEngine.formatNumberString(v)));
                }
            }
        } else {
            throw new EvalException("not support sumif function format:" + f);
        }
        f.setValue(sum);
    }

    private boolean isEqualsType(String expr) {
        if (expr.length() > 0) {
            char first = expr.charAt(0);
            return first != '<' && first != '>' && first != '!';
        }
        return true;
    }
}

