/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.spread.formula.util.AreaReference;

public abstract class TextFormulaCalculate
extends ExcelFormulaCalculate {
    protected Map<Integer, String> paramMap = new HashMap<Integer, String>();

    @Override
    protected void calculateFormula(IFormula f) {
        ParamList paramList = f.getParamList();
        if (paramList == null || paramList.size() < this.getMinParamSize()) {
            f.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u5c11\u4e8e$s\u4e2a\u3002", (String)"TextFormulaCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.getMinParamSize()))));
            return;
        }
        if (paramList.size() > this.getMaxParamSize()) {
            f.setException((Exception)((Object)new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"TextFormulaCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), this.getMaxParamSize()))));
            return;
        }
        try {
            for (int i = 0; i < paramList.size(); ++i) {
                ParamItem paramItem = (ParamItem)paramList.get(i);
                Object param = this.calcExpr(paramItem);
                if (param == null) continue;
                if (param instanceof Exception) {
                    f.setException((Exception)param);
                    return;
                }
                if (param instanceof Number && param.toString().contains(".")) {
                    param = new BigDecimal(param.toString()).stripTrailingZeros().toPlainString();
                }
                this.paramMap.put(i, param.toString());
            }
        }
        catch (Exception e) {
            f.setException(e);
            return;
        }
        this.fillBackValue(f);
    }

    @Override
    protected Object calcExpr(Object exprParam) {
        Object param = ((ParamItem)exprParam).getParam();
        if (param instanceof AreaReference) {
            return this.calcAreaRef((AreaReference)param);
        }
        if (param instanceof Number) {
            return new BigDecimal(param.toString());
        }
        if (param instanceof String) {
            return param.toString();
        }
        return super.calcExpr(exprParam);
    }

    protected Object calcAreaRef(AreaReference param) {
        return new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u652f\u6301\u9009\u62e9\u533a\u57df", (String)"TextFormulaCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    protected abstract void fillBackValue(IFormula var1);

    protected abstract int getMaxParamSize();

    protected abstract int getMinParamSize();
}

