/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.excelformula;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.excelformula.ExcelFormulaCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;

public class YearCalculate
extends ExcelFormulaCalculate {
    @Override
    protected void calculateFormula(IFormula f) {
        ParamList pl = f.getParamList();
        if (pl.size() != 1) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"YEAR\u51fd\u6570\u53ea\u80fd\u67091\u4e2a\u53c2\u6570\uff0c\u5f53\u524d\u8bbe\u7f6e\u4e86%1$s\u4e2a\u3002", (String)"YearCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]), pl.size()))));
            return;
        }
        Object p1 = ((ParamItem)pl.get(0)).getParam();
        if (p1 == null || p1 != null && (p1.equals(0) || p1.toString().contentEquals("0"))) {
            f.setValue(BigInteger.valueOf(1899L));
            return;
        }
        Integer result = 0;
        String compileDate = ResManager.getLocaleString((String)"\u7f16\u5236\u65e5\u671f\uff1a", (String)"MonthCalculate_4", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String year = ResManager.getLocaleString((String)"\u5e74", (String)"MonthCalculate_5", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        try {
            if (p1.toString().startsWith("/OADate")) {
                double d = Double.parseDouble(p1.toString().substring(p1.toString().indexOf("(") + 1, p1.toString().indexOf(")")));
                result = this.covertFromOADateYear(d);
            } else if (p1.toString().contains(compileDate)) {
                String[] split = p1.toString().split("\uff1a");
                result = this.getYearByPatern(split[1]);
                if (result != 0) {
                    f.setValue(BigInteger.valueOf(result.intValue()));
                    return;
                }
                if (split.length != 2 || !split[1].contains(year)) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"YEAR\u51fd\u6570\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u201c%1$s\u201d\u7684\u65e5\u671f\u683c\u5f0f\u3002", (String)"YearCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), p1.toString()))));
                    return;
                }
                result = Integer.parseInt(split[1].substring(0, split[1].indexOf(year)).trim());
            } else if (p1.toString().contains(year)) {
                result = Integer.parseInt(p1.toString().substring(0, p1.toString().indexOf(year)).trim());
            } else {
                result = this.getYearByPatern(p1.toString());
                if (0 == result) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"YEAR\u51fd\u6570\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u201c%1$s\u201d\u7684\u65e5\u671f\u683c\u5f0f\u3002", (String)"YearCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), p1.toString()))));
                    return;
                }
            }
        }
        catch (Exception e) {
            f.setException(e);
            return;
        }
        f.setValue(BigInteger.valueOf(result.intValue()));
    }

    private Integer getYearByPatern(String str1) throws ParseException {
        String pattern = "";
        if (str1.matches("^\\d{4}[-]\\d{2}.*")) {
            pattern = "yyyy-MM";
        } else if (str1.matches("^\\d{4}[/]\\d{2}.*")) {
            pattern = "yyyy/MM";
        } else {
            if (str1.matches("^\\d{6}.*")) {
                return Integer.parseInt(str1.substring(0, 4));
            }
            return 0;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(str1);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    private Integer covertFromOADateYear(double d) throws ParseException {
        SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
        Date baseDate = myFormat.parse("30 12 1899");
        Calendar c = Calendar.getInstance();
        c.setTime(baseDate);
        c.add(5, (int)d);
        return c.get(1);
    }
}

