/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.external;

import com.google.common.collect.HashMultimap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.dispatch.DispatchParams;
import kd.fi.bcm.business.formula.dispatch.FormulaDispatchServiceHelper;
import kd.fi.bcm.business.formula.model.external.ExternalFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.auditlog.ESDateUtils;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ExternalFormulaCalculate
extends AbstractCalculate<ExternalFormula> {
    @Override
    protected void execCalculate(List<ExternalFormula> formulas) {
        String formulaName = formulas.get(0).getName();
        DispatchParams params = new DispatchParams(formulaName);
        formulas.forEach(f -> {
            for (ParamItem item : f.getParamList()) {
                if (!(item.getParam() instanceof BinaryOperationExpr)) continue;
                Object va = this.getFelEngine().calculate(item.getParam().toString());
                item.fixParam(va);
            }
            params.addFormulaParam(f.getUUID(), f.formatParam());
        });
        params.addCommonParam(this.collectCommonParams(this._ctx, false, formulaName));
        params.addRefParam((Map)this._ctx.getProperty("is_calc_collect_ref_param"));
        params.setFloatParam((Map)this._ctx.getProperty("is_calc_collect_float_param"));
        params.addCommonAssistDim((HashMultimap<String, String>)((HashMultimap)this._ctx.getProperty("commonAssistDim")));
        this.log.startWatch();
        Boolean isBatchCalc = (Boolean)this._ctx.getProperty("is_calc_collect");
        Map<String, Object> result = FormulaDispatchServiceHelper.dispatchCalculate2MService(params.getFormulaName(), params.toJson(), isBatchCalc == null ? false : isBatchCalc);
        String templateNum = this._ctx.getProperty("template") == null ? " " : (String)this._ctx.getProperty("template");
        this.log.info(String.format("%s entity's template %s calculate [%d] formula [%s],spend time", this._ctx.getOrg(), templateNum, formulas.size(), formulaName));
        Boolean openLevel = (Boolean)this._ctx.getProperty("calErrorLogLevel");
        if (result != null) {
            formulas.forEach(f -> {
                Map v = (Map)result.get(f.getUUID());
                if (isBatchCalc != null && isBatchCalc.booleanValue()) {
                    if (v == null) {
                        f.setValue((Object)new EvalException("externalFormula calculate fail: result value is null."));
                    } else if (v.get("success") != null && ((Boolean)v.get("success")).booleanValue()) {
                        Object index;
                        f.setValue(v.get("v"));
                        Object msg = v.get("failmsg");
                        if (msg != null) {
                            f.setTipLogMsg(msg.toString());
                        }
                        if ((index = v.get("index")) instanceof Integer) {
                            f.setFloatParamIndex((Integer)index);
                        }
                    } else {
                        f.setValue((Object)new EvalException("" + v.get("failmsg")));
                    }
                } else if (v == null) {
                    f.setValue(null);
                } else {
                    Object type = v.get("type");
                    Object value = v.get("v");
                    int typeInt = 1;
                    if (type != null) {
                        typeInt = Integer.parseInt(type.toString());
                    }
                    if (typeInt == 3 && value instanceof Date) {
                        value = ESDateUtils.formatUTCDateFormat((Date)((Date)value));
                    }
                    if (openLevel != null && openLevel.booleanValue() && null != type && typeInt == -2) {
                        f.setLogMsg("" + value);
                    } else if (null != type && (typeInt == -1 || typeInt == -2)) {
                        f.setValue((Object)new EvalException("" + value));
                    } else {
                        f.setValue(value);
                        Object msg = v.get("msg");
                        if (msg != null) {
                            f.setTipLogMsg(msg.toString());
                        }
                    }
                }
            });
        }
    }

    public Map<String, Object> collectCommonParams(ICalContext _ctx, Boolean isBatch, String formulaNum) {
        HashMap<String, Object> commParams = new HashMap<String, Object>();
        this.setOrg(commParams, _ctx);
        this.setCurrency(commParams, _ctx, isBatch);
        this.setFy(commParams, _ctx);
        this.setScopePeriod(commParams, _ctx);
        this.setPeriod(commParams, _ctx, isBatch, formulaNum);
        this.setCommonDimension(commParams, _ctx);
        commParams.put("accountreclass", _ctx.getProperty("accountreclass"));
        commParams.put("model", _ctx.getCubeNumber());
        commParams.put("scenario", _ctx.getScenario());
        commParams.put("currency", _ctx.getCurrency());
        return commParams;
    }

    private void setScopePeriod(Map<String, Object> commParams, ICalContext _ctx) {
        String period = _ctx.getPeriod();
        if (StringUtils.isNotEmpty((String)period) && (period.contains("Q_Q") || period.contains("HF"))) {
            if (StringUtils.isEmpty((String)_ctx.getCubeNumber())) {
                return;
            }
            QFilter modelFilter = new QFilter("model.number", "=", (Object)_ctx.getCubeNumber());
            QFilter periodnumber = new QFilter("number", "=", (Object)_ctx.getPeriod());
            DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"expmonth, effmonth", (QFilter[])new QFilter[]{periodnumber, modelFilter});
            int[] scopePeriod = new int[]{periodObj.getInt("effmonth"), periodObj.getInt("expmonth")};
            commParams.put("scopePeriod", scopePeriod);
        }
    }

    private void setOrg(Map<String, Object> commParams, ICalContext _ctx) {
        DynamicObject[] memberDims;
        String org = _ctx.getOrg();
        if (StringUtils.isNotEmpty((String)org) && ("acct".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName()) || "acctcf".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName())) && _ctx.getProperty("deleteOrg") != null && ((Boolean)_ctx.getProperty("deleteOrg")).booleanValue()) {
            return;
        }
        if (StringUtils.isEmpty((String)_ctx.getCubeNumber())) {
            commParams.put("org", org);
            return;
        }
        Long modelId = MemberReader.findModelIdByNum((String)_ctx.getCubeNumber());
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bcmdim", "=", (Object)entityDimId);
        for (DynamicObject memberDim : memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.membermodel, bcmmember, assttype, asstmember, model", (QFilter[])qFilter.toArray())) {
            if (!memberDim.getString("bcmmember").equals(org)) continue;
            org = memberDim.getString("asstmember");
            break;
        }
        commParams.put("org", org);
    }

    private void setFy(Map<String, Object> commParams, ICalContext _ctx) {
        String fy = _ctx.getYear();
        if (StringUtils.isNotEmpty((String)fy)) {
            commParams.put("fy", Integer.parseInt(fy.substring(2)));
        }
    }

    private void setPeriod(Map<String, Object> commParams, ICalContext _ctx, Boolean isBatch, String formulaNum) {
        String period = _ctx.getPeriod();
        String orignPeriod = _ctx.getPeriod();
        if (StringUtils.isNotEmpty((String)period)) {
            DynamicObject[] memberDims;
            if ((isBatch.booleanValue() || "acct".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName()) || "acctcf".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName()) || "acctage".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName())) && (period.contains("Q_Q") || period.contains("HF")) && StringUtils.isNotEmpty((String)_ctx.getCubeNumber())) {
                QFilter modelFilter = new QFilter("model.number", "=", (Object)_ctx.getCubeNumber());
                QFilter periodnumber = new QFilter("number", "=", (Object)_ctx.getPeriod());
                DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, expmonth", (QFilter[])new QFilter[]{periodnumber, modelFilter});
                period = "M_M" + (Integer.parseInt(periodObj.getString("expmonth")) < 10 ? "0" + periodObj.getString("expmonth") : periodObj.getString("expmonth"));
            }
            if (PeriodUtils.isStandardPeriod((String)period)) {
                commParams.put("period", PeriodUtils.trans2IntPeriod((String)period));
                commParams.put("period_type", PeriodUtils.getPeriodType((String)period));
            } else {
                commParams.put("period", 0);
            }
            commParams.put("original_period", period);
            if (StringUtils.isEmpty((String)_ctx.getCubeNumber())) {
                return;
            }
            Long modelId = MemberReader.findModelIdByNum((String)_ctx.getCubeNumber());
            Long periodDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Period");
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("bcmdim", "=", (Object)periodDimId);
            for (DynamicObject memberDim : memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.membermodel, bcmmember, assttype, asstmember, model", (QFilter[])qFilter.toArray())) {
                if (!memberDim.getString("bcmmember").equalsIgnoreCase(orignPeriod) || !memberDim.getString("bcmdim.membermodel").equals("bcm_periodmembertree")) continue;
                orignPeriod = memberDim.getString("asstmember");
                if (NumberUtils.isNumber((String)orignPeriod)) {
                    commParams.put("period", Integer.parseInt(orignPeriod));
                    commParams.remove("scopePeriod");
                    break;
                }
                DataCollectUtil.dealScopePeriodByCommonDim(orignPeriod, null, periodList -> {
                    String[] scopePeriod = new String[]{(String)periodList.get(0), (String)periodList.get(1)};
                    commParams.put("scopePeriod", scopePeriod);
                    commParams.put("isAdjustPeriod", true);
                }, periodStr -> {
                    commParams.put("period", periodStr);
                    commParams.remove("scopePeriod");
                });
                break;
            }
            if ("acct".equalsIgnoreCase(formulaNum) || "acctcf".equalsIgnoreCase(formulaNum)) {
                Object periodValue = commParams.get("period");
                boolean isText = DataCollectUtils.acctFormulaPeriodIsTxt(formulaNum);
                if (!isText && !(periodValue instanceof Integer)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u8d26\u4e0d\u8bc6\u522b\u7684\u671f\u95f4 %s\uff0c\u8bf7\u7ef4\u62a4\u6210\u5458\u6620\u5c04\u6216\u5347\u7ea7\u603b\u8d26\u7248\u672c", (String)"ExternalFormulaCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), period));
                }
            }
            if (StringUtils.isEmpty((String)_ctx.getYear()) || StringUtils.isEmpty((String)_ctx.getCubeNumber())) {
                return;
            }
            Date[] startAndEndDate = PeriodUtils.calcStartAndEndDate((long)modelId, (String)_ctx.getYear(), (String)period);
            if (startAndEndDate[0] != null) {
                commParams.put("startDate", PeriodUtils.formatDate((Date)startAndEndDate[0]));
            }
            if (startAndEndDate[1] != null) {
                commParams.put("endDate", PeriodUtils.formatDate((Date)startAndEndDate[1]));
            }
        }
    }

    private void setCurrency(Map<String, Object> commParams, ICalContext _ctx, Boolean isBatch) {
        if (isBatch.booleanValue() || "acct".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName())) {
            return;
        }
        String currency = _ctx.getCurrency();
        if (StringUtils.isNotEmpty((String)currency)) {
            commParams.put("currency", currency);
        }
    }

    @Override
    protected void initFormula() {
    }

    private void setCommonDimension(Map<String, Object> commParams, ICalContext _ctx) {
        String commonDimension = _ctx.getCommonDimension();
        if (StringUtils.isNotEmpty((String)commonDimension) && ("acct".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName()) || "acctcf".equalsIgnoreCase(((ExternalFormula)this.originalFormulas.get(0)).getName()))) {
            commParams.put("commondimension", commonDimension);
        }
    }
}

