/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.disclosure.util.DmCurrencyUtil;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmvFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public abstract class AbstractFidmCalculate<T extends FidmCommonFormula>
extends AbstractCalculate<FidmCommonFormula> {
    public static final String ORG_RELA_SIGN = "_";
    private static final String DC = "DC";
    private static final List<String> presetProcess = Lists.newArrayList((Object[])new String[]{"CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
    protected static final List<String> detailoricess = Lists.newArrayList((Object[])new String[]{"CCADJ", "EJE", "CADJ", "ADJ", "Rpt", "IRpt", "EIRpt", "ERAdj"});

    @Override
    protected void initFormula() {
        this.originalFormulas.forEach(f -> this.initParams((FidmCommonFormula)f));
    }

    protected void initParams(FidmCommonFormula f) {
        if (f.hasException()) {
            return;
        }
        if (f.getParamList().size() < 2) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u5c11\u4e8e2\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        String showNumber = this.getParam(f, this.getModelIndex());
        Optional<DynamicObject> model = Optional.ofNullable(BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"number", (QFilter[])new QFBuilder().add("model.shownumber", "=", (Object)showNumber).toArray()));
        if (!model.isPresent()) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        String cube = this.getCube(f);
        Map<String, String> shortNumber2Num = this.getShortNumber2Num(cube);
        f.setShownumbner(showNumber);
        f.setCube(cube);
        f.setShortNumber2Num(shortNumber2Num);
        this.handleDefaultParamVal(f, shortNumber2Num);
        this.checkMemberIsExit(f, shortNumber2Num, cube);
        this.sortFormulaParamList(f);
        Map memberNum2Dseq = MemberReader.getMemberNum2Dseq((String)cube);
        f.setMemberNum2Dseq(memberNum2Dseq);
    }

    private void checkMemberIsExit(FidmCommonFormula f, Map<String, String> shortNumber2Num, String cube) {
        if (!f.hasException()) {
            String dimAndMembers = this.getParam(f, this.getDimsIndex());
            String[] dim2MemArr = dimAndMembers.split(",");
            ArrayList<String> entitys = new ArrayList<String>(8);
            ArrayList<String> currencys = new ArrayList<String>(8);
            ArrayList<String> processs = new ArrayList<String>(8);
            for (String item : dim2MemArr) {
                String[] splitArr = VDmFormula.splitDimAndMemb(item);
                if (splitArr[1].startsWith("{") && splitArr[1].endsWith("}")) {
                    splitArr[1] = splitArr[1].substring(1, splitArr[1].length() - 1);
                }
                String[] memSplitArr = splitArr[1].split(";");
                if ("C".equalsIgnoreCase(splitArr[0]) && Arrays.stream(memSplitArr).anyMatch(s -> s.equalsIgnoreCase("ec") || s.equalsIgnoreCase("dc") || s.equalsIgnoreCase("pc"))) {
                    f.setUseEcDcPcStr(Boolean.TRUE);
                }
                for (String memItem : memSplitArr) {
                    IDNumberTreeNode member = null;
                    if ("E".equalsIgnoreCase(splitArr[0]) && memItem.contains(ORG_RELA_SIGN)) {
                        int index = memItem.indexOf(ORG_RELA_SIGN);
                        String parentnumber = memItem.substring(0, index);
                        String orgnumber = memItem.substring(index + 1);
                        member = MemberReader.findMemberByNumber((String)cube, (String)DimEntityNumEnum.ENTITY.getNumber(), (String)orgnumber);
                        this.checkParentChild(parentnumber, member);
                    } else {
                        member = MemberReader.findMemberByNumber((String)cube, (String)shortNumber2Num.get(splitArr[0]), (String)memItem);
                    }
                    if ("$all".equalsIgnoreCase(memItem)) {
                        f.addAllCols(splitArr[0]);
                        continue;
                    }
                    if (member == null || member == IDNumberTreeNode.NotFoundTreeNode) {
                        f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"AbstractFidmCalculate_8", (String)"fi-bcm-business", (Object[])new Object[0]), memItem))));
                        return;
                    }
                    if ("E".equalsIgnoreCase(splitArr[0])) {
                        entitys.add(memItem);
                        continue;
                    }
                    if ("C".equalsIgnoreCase(splitArr[0])) {
                        currencys.add(memItem);
                        continue;
                    }
                    if (!"BP".equalsIgnoreCase(splitArr[0])) continue;
                    processs.add(memItem);
                }
            }
            if (processs.size() == 0 || f.getMemberinAllCols("BP")) {
                processs.addAll(detailoricess);
                this.changeDimParam(f, "BP", processs);
            }
            if (f.getUseEcDcPcStr() == Boolean.TRUE && !f.getMemberinAllCols("E")) {
                f.addPCOrgs(entitys.toArray(new String[0]));
                MultiKeyMap orgCurrencyMap = DmCurrencyUtil.handleECDC(f.getCube(), entitys, currencys, processs, processs.size() == 0 || f.getMemberinAllCols("BP"));
                f.addCurrency(currencys.toArray(new String[0]));
                List<String> validEntitys = currencys.contains(DC) && f.getMemberinAllCols("BP") == Boolean.TRUE.booleanValue() ? entitys : this.getEntitysFormMap((MultiKeyMap<String, Object>)orgCurrencyMap);
                this.changeDimParam(f, "E", validEntitys);
                f.setOrgCurrencymap(orgCurrencyMap);
            }
        }
    }

    public List<String> getEntitysFormMap(MultiKeyMap<String, Object> orgCurrencyMap) {
        HashSet<Object> entitys = new HashSet<Object>(orgCurrencyMap.size());
        for (MultiKey entry : orgCurrencyMap.keySet()) {
            entitys.add(entry.getKey(0));
        }
        return Lists.newArrayList(entitys);
    }

    public void changeDimParam(FidmCommonFormula f, String dim, List<String> value) {
        String dimAndMembers = this.getParam(f, this.getDimsIndex());
        if (StringUtils.isEmpty((CharSequence)dim) || value.size() == 0) {
            return;
        }
        boolean containBp = Boolean.FALSE;
        StringBuilder sb = new StringBuilder(dim);
        sb.append(".");
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        for (int i = 0; i < dim2MemList.size(); ++i) {
            String[] arrays;
            String s = (String)dim2MemList.get(i);
            if (StringUtils.isEmpty((CharSequence)s) || !Objects.equals(dim, (arrays = VSDmvFormula.splitDimAndMemb(s))[0])) continue;
            containBp = Boolean.TRUE;
            if (value.size() == 1) {
                sb.append(value.get(0));
            } else {
                sb.append("{");
                sb.append(String.join((CharSequence)";", value));
                sb.append("}");
            }
            if (Objects.equals(arrays[1], sb.toString())) {
                return;
            }
            dim2MemList.set(i, sb.toString());
        }
        if (!containBp) {
            sb.append("{");
            sb.append(String.join((CharSequence)";", value));
            sb.append("}");
            dim2MemList.add(sb.toString());
        }
        f.getParamList().remove(this.getDimsIndex());
        f.getParamList().add(this.getDimsIndex(), new ParamItem(new StringExpr(String.join((CharSequence)",", dim2MemList))));
    }

    public void changeDimParam(Formula f, List<String> dim2MemList) {
        f.getParamList().remove(this.getDimsIndex());
        f.getParamList().add(this.getDimsIndex(), new ParamItem(new StringExpr(String.join((CharSequence)",", dim2MemList))));
    }

    public Map<String, String> getShortNumber2Num(String cube) {
        return MemberReader.getDimensionShortNumber2NumberMap((String)cube);
    }

    public String getCube(FidmCommonFormula f) {
        String cube = "";
        try {
            if (!f.hasException()) {
                String showNumber = this.getParam(f, this.getModelIndex());
                cube = MemberReader.findModelNumberByShowNum((String)showNumber);
            }
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
        }
        return cube;
    }

    public HashMultimap<String, String> getSqlFilterDims(FidmCommonFormula f, Map<String, String> shortNumber2Num, String dimAndMembers) {
        HashMultimap dim2MembMap = HashMultimap.create();
        String[] arrays = null;
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        String realDimVal = null;
        HashSet currencys = new HashSet(16);
        for (String s : dim2MemList) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            arrays = VSDmvFormula.splitDimAndMemb(s);
            realDimVal = this.getRealDimVal(arrays[1]);
            String[] realDimValArr = realDimVal.split(";");
            MultiKeyMap map = f.getOrgCurrencymap();
            if (f.getUseEcDcPcStr() == Boolean.TRUE && "C".equalsIgnoreCase(arrays[0]) && Objects.nonNull(map) && map.values().size() > 0) {
                map.values().forEach(p -> currencys.addAll((Collection)p));
                realDimValArr = currencys.toArray(new String[0]);
            }
            for (String realDimValStr : realDimValArr) {
                dim2MembMap.put((Object)shortNumber2Num.get(arrays[0]), (Object)realDimValStr);
            }
        }
        return dim2MembMap;
    }

    private String getRealDimVal(String curDimVal) {
        if (curDimVal.startsWith("{") && curDimVal.endsWith("}")) {
            curDimVal = curDimVal.substring(1, curDimVal.length() - 1);
        }
        return curDimVal;
    }

    public HashMultimap<String, String> getSqlFilterDims(FidmCommonFormula f, Map<String, String> shortNumber2Num, String dimAndMembers, Map<String, String> userdefinedims) {
        HashMultimap dim2MembMap = HashMultimap.create();
        if (StringUtils.isEmpty((CharSequence)dimAndMembers)) {
            return dim2MembMap;
        }
        String[] arrays = null;
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        HashSet currencys = new HashSet(16);
        for (String s : dim2MemList) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            arrays = VDmFormula.splitDimAndMemb(s);
            String left = shortNumber2Num.get(arrays[0]);
            String right = arrays[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            Collection<String> members = Arrays.asList(para.split(";"));
            MultiKeyMap map = f.getOrgCurrencymap();
            if (f.getUseEcDcPcStr() == Boolean.TRUE && "C".equalsIgnoreCase(arrays[0]) && Objects.nonNull(map) && map.values().size() > 0) {
                map.values().forEach(p -> {
                    if (p instanceof HashSet) {
                        currencys.addAll((HashSet)p);
                    } else {
                        currencys.add(p.toString());
                    }
                });
                members = currencys;
            }
            this.addMembers(members, (HashMultimap<String, String>)dim2MembMap, left);
        }
        return dim2MembMap;
    }

    private void addMembers(Collection<String> members, HashMultimap<String, String> dim2MembMap, String left) {
        for (String member : members) {
            dim2MembMap.put((Object)left, (Object)member);
        }
    }

    public Map<ParamItem, List<FidmCommonFormula>> groupFormulas(List<FidmCommonFormula> formulas) {
        Map<ParamItem, List<FidmCommonFormula>> formulaGroup = formulas.stream().collect(Collectors.groupingBy(formula -> (ParamItem)formula.getParamList().get(this.getModelIndex())));
        return formulaGroup;
    }

    public void sortFormulaParamList(FidmCommonFormula formula) {
        Map dimOrderMap = MemberReader.getMemberShortNum2Dseq((String)formula.getCube());
        String dimAndMembers = this.getParam(formula, this.getDimsIndex());
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        dim2MemList.sort((p1, p2) -> {
            String s1 = VDmFormula.splitDimAndMemb(p1)[0];
            String s2 = VDmFormula.splitDimAndMemb(p2)[0];
            return (Integer)dimOrderMap.get(s1) - (Integer)dimOrderMap.get(s2);
        });
        this.changeDimParam(formula, dim2MemList);
    }

    public String getParam(FidmCommonFormula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }

    private void handleDefaultParamVal(FidmCommonFormula f, Map<String, String> shortNumber2Num) {
        if (!f.hasException()) {
            this.getFormulaDim2member(f, shortNumber2Num);
        }
    }

    private Map<String, String> getFormulaDim2member(FidmCommonFormula f, Map<String, String> shortNumber2Num) {
        HashMap<String, String> formulaDim2member = new HashMap<String, String>(16);
        String dimAndMembers = this.getParam(f, this.getDimsIndex());
        if (kd.bos.util.StringUtils.isEmpty((String)dimAndMembers)) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractFidmCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]))));
            return null;
        }
        String[] dim2MemArr = dimAndMembers.split(",");
        try {
            for (String item : dim2MemArr) {
                String[] splitArr = VDmFormula.splitDimAndMemb(item);
                if (splitArr.length != 2 || !shortNumber2Num.containsKey(splitArr[0])) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"AbstractFidmCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), item))));
                    break;
                }
                formulaDim2member.put(splitArr[0], splitArr[1]);
            }
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"AbstractFidmCalculate_5", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error((Throwable)e);
            return null;
        }
        return formulaDim2member;
    }

    public void checkParentChild(String parentnumber, IDNumberTreeNode baseOrg) {
        if (baseOrg == null) {
            return;
        }
        if (Objects.nonNull(baseOrg.getParent()) && Objects.equals(baseOrg.getParent().getNumber(), parentnumber)) {
            return;
        }
        if (Objects.nonNull(baseOrg.getShareNodes())) {
            for (IDNumberTreeNode node : baseOrg.getShareNodes()) {
                if (!Objects.nonNull(node.getParent()) || !Objects.equals(node.getParent().getNumber(), parentnumber)) continue;
                return;
            }
        }
    }

    public void resetZeroByOrgCurrency(MDResultSet rs, FidmCommonFormula formula) {
        if (Objects.isNull(rs) || rs.getCount() == 0 || !Objects.equals(formula.getUseEcDcPcStr(), Boolean.TRUE)) {
            return;
        }
        Row[] mergerRows = new Row[rs.getFetchSize()];
        String cubeNumber = formula.getCube();
        MultiKeyMap orgCurrencymap = formula.getOrgCurrencymap();
        if (formula.getUseEcDcPcStr() == Boolean.TRUE && (Objects.isNull(orgCurrencymap) || orgCurrencymap.size() == 0)) {
            orgCurrencymap = new MultiKeyMap();
        }
        int processIndex = rs.getMetaData().getColIndex(DimTypesEnum.PROCESS.getNumber());
        rs.beforeFirst();
        Set<String> currencys = formula.getCurrencys();
        int i = 0;
        while (rs.next()) {
            Row row = rs.getRow();
            String orgNum = row.getString(DimTypesEnum.ENTITY.getNumber());
            if (StringUtils.isEmpty((CharSequence)orgNum)) {
                return;
            }
            String currencyNum = row.getString(DimTypesEnum.CURRENCY.getNumber());
            String processNum = processIndex >= 0 ? row.getString(DimTypesEnum.PROCESS.getNumber()) : "";
            HashSet<Object> targetCurency = orgCurrencymap.get((Object)orgNum, (Object)processNum);
            if (Objects.isNull(targetCurency)) {
                HashSet<Object> mycurrencys = new HashSet<Object>(16);
                for (String currency : currencys) {
                    if (presetProcess.contains(processNum) && DC.equalsIgnoreCase(currency)) {
                        Set<String> pcorgs = formula.getPCOrgs();
                        for (String org : pcorgs) {
                            if (!org.endsWith(orgNum) || !org.contains(ORG_RELA_SIGN)) continue;
                            IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)cubeNumber, (String)org);
                            Pair<String, String> transCur = TransMemberUtil.transOrgAndCurbyOrgId(cubeNumber, (long)entityNode.getId(), processNum, currency, 0L, 0L);
                            mycurrencys.add(transCur.p2);
                        }
                        continue;
                    }
                    IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)cubeNumber, (String)orgNum);
                    Pair<String, String> transCur = TransMemberUtil.transOrgAndCurbyOrgId(cubeNumber, (long)entityNode.getId(), processNum, currency, 0L, 0L);
                    mycurrencys.add(transCur.p2);
                }
                targetCurency = mycurrencys;
                orgCurrencymap.put((Object)orgNum, (Object)processNum, mycurrencys);
            }
            if (!((HashSet)targetCurency).contains(currencyNum)) continue;
            mergerRows[i++] = row;
        }
        while (i < rs.getFetchSize()) {
            mergerRows[i++] = null;
        }
        System.arraycopy(mergerRows, 0, rs.getRows(), 0, rs.getFetchSize());
        rs.beforeFirst();
    }

    abstract int getModelIndex();

    abstract int getDimsIndex();
}

