/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.disclosure.DataSetExtService;
import kd.fi.bcm.business.disclosure.util.DmCurrencyUtil;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.calculate.fidm.AbstractFidmCalculate;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.model.fidm.FidmExtCommonFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections4.map.MultiKeyMap;

public abstract class AbstractFidmExtCalculate<T extends FidmExtCommonFormula>
extends AbstractFidmCalculate<FidmExtCommonFormula> {
    private static final String NUMBER = "number";
    private static final String PROJECT = "fi-bcm-business";

    @Override
    protected void initFormula() {
        this.originalFormulas.forEach(f -> this.initParams((FidmExtCommonFormula)f));
    }

    protected void initParams(FidmExtCommonFormula f) {
        if (f.hasException()) {
            return;
        }
        if (f.getParamList().size() < 3) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u5c11\u4e8e3\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_1", (String)PROJECT, (Object[])new Object[0]))));
            return;
        }
        String showNumber = this.getParam(f, this.getModelIndex());
        Optional<DynamicObject> model = Optional.ofNullable(BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id,number,shownumber", (QFilter[])new QFBuilder().add("shownumber", "=", (Object)showNumber).toArray()));
        if (!model.isPresent()) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_2", (String)PROJECT, (Object[])new Object[0]))));
            return;
        }
        f.setShownumbner(showNumber);
        String cube = this.getCube(f);
        Map<String, String> shortNumber2Num = this.getShortNumber2Num(cube);
        f.setShownumbner(showNumber);
        f.setCube(cube);
        f.setShortNumber2Num(shortNumber2Num);
        String extnumber = this.getParam(f, this.getExtModelIndex());
        Optional<DynamicObject> extmodel = Optional.ofNullable(BusinessDataServiceHelper.loadSingle((String)"bcm_extendsmodel", (String)"id,number,extendsgroup", (QFilter[])new QFBuilder().add(NUMBER, "=", (Object)extnumber).and("model", "=", (Object)model.get().getLong("id")).toArray()));
        if (!extmodel.isPresent()) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_2", (String)PROJECT, (Object[])new Object[0]), extnumber))));
            return;
        }
        DynamicObject groupObj = ExtDimensionHelper.getExtGroupByNumber(model.get().getLong("id"), extmodel.get().getString("extendsgroup.number"));
        f.setExtModel((Pair<Long, String>)new Pair((Object)extmodel.get().getLong("id"), (Object)extnumber));
        f.setExtGroup((Pair<String, String>)new Pair((Object)groupObj.getString(NUMBER), (Object)groupObj.getString("grouptype")));
        f.setModel((Tuple<Long, String, String>)new Tuple((Object)model.get().getLong("id"), (Object)model.get().getString("shownumber"), (Object)model.get().getString(NUMBER)));
        this.checkMemberIsExit(f, shortNumber2Num, cube);
        this.sortFormulaParamList(f);
        Map memberNum2Dseq = MemberReader.getMemberNum2Dseq((String)cube);
        f.setMemberNum2Dseq(memberNum2Dseq);
    }

    public void checkMemberIsExit(FidmExtCommonFormula f, Map<String, String> shortNumber2Num, String cube) {
        if (f.hasException()) {
            return;
        }
        String dimAndMembers = this.getParam(f, this.getDimsIndex());
        String[] dim2MemArr = dimAndMembers.split(",");
        ArrayList<String> left = new ArrayList<String>(8);
        ArrayList<String> right = new ArrayList<String>(8);
        ArrayList<String> allDimShortNumbers = new ArrayList<String>(8);
        ArrayList<String> entitys = new ArrayList<String>(8);
        ArrayList<String> currencys = new ArrayList<String>(8);
        ArrayList<String> processs = new ArrayList<String>(8);
        for (String item : dim2MemArr) {
            String[] splitArr;
            if (StringUtils.isEmpty((String)item) || !shortNumber2Num.containsKey((splitArr = VDmFormula.splitDimAndMemb(item))[0])) continue;
            String para = splitArr[1].startsWith("{") && splitArr[1].endsWith("}") ? splitArr[1].substring(1, splitArr[1].length() - 1) : splitArr[1];
            List<String> members = Arrays.asList(para.split(";"));
            if ("C".equalsIgnoreCase(splitArr[0]) && members.stream().anyMatch(s -> s.equalsIgnoreCase("ec") || s.equalsIgnoreCase("dc") || s.equalsIgnoreCase("pc"))) {
                f.setUseEcDcPcStr(Boolean.TRUE);
            }
            for (String member : members) {
                IDNumberTreeNode membernode = null;
                if ("E".equalsIgnoreCase(splitArr[0]) && member.contains("_")) {
                    int index = member.indexOf("_");
                    String parentnumber = member.substring(0, index);
                    String orgnumber = member.substring(index + 1);
                    membernode = MemberReader.findMemberByNumber((String)cube, (String)DimEntityNumEnum.ENTITY.getNumber(), (String)orgnumber);
                    this.checkParentChild(parentnumber, membernode);
                } else {
                    membernode = MemberReader.findMemberByNumber((String)cube, (String)shortNumber2Num.get(splitArr[0]), (String)member);
                }
                if (membernode == null || membernode == IDNumberTreeNode.NotFoundTreeNode) {
                    if ("$all".equalsIgnoreCase(member.toLowerCase(Locale.ENGLISH))) {
                        f.addAllCols(splitArr[0]);
                        continue;
                    }
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u6216\u8005\u53d8\u91cf%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_3", (String)PROJECT, (Object[])new Object[0]), member))));
                    return;
                }
                if ("E".equalsIgnoreCase(splitArr[0])) {
                    entitys.add(member);
                    continue;
                }
                if ("C".equalsIgnoreCase(splitArr[0])) {
                    currencys.add(member);
                    continue;
                }
                if (!"BP".equalsIgnoreCase(splitArr[0])) continue;
                processs.add(member);
            }
            allDimShortNumbers.add(splitArr[0]);
        }
        if (f.getUseEcDcPcStr() == Boolean.TRUE && !f.getMemberinAllCols("E")) {
            MultiKeyMap orgCurrencyMap = DmCurrencyUtil.handleECDC(f.getCube(), entitys, currencys, processs, f.getMemberinAllCols("BP") || processs.size() == 0);
            f.addCurrency(currencys.toArray(new String[0]));
            List<String> validEntitys = currencys.contains("DC") && f.getMemberinAllCols("BP") == Boolean.TRUE.booleanValue() ? entitys : this.getEntitysFormMap((MultiKeyMap<String, Object>)orgCurrencyMap);
            this.changeDimParam(f, "E", validEntitys);
            f.setOrgCurrencymap(orgCurrencyMap);
        }
        String extdimAndMembers = this.getParam(f, this.getMeasuresIndex());
        String[] extdim2MemArr = extdimAndMembers.split(",");
        String extnumber = this.getParam(f, this.getExtModelIndex());
        QFilter extmodelFilter = new QFilter(NUMBER, "=", (Object)extnumber).and("model.shownumber", "=", (Object)this.getParam(f, this.getModelIndex()));
        DynamicObject extmodel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{extmodelFilter});
        ArrayList<String> extfields = new ArrayList<String>(8);
        for (String item : extdim2MemArr) {
            if (shortNumber2Num.containsKey(item)) {
                left.add(item);
                continue;
            }
            QFilter fieldFilter = new QFilter("extmodelid", "=", (Object)extmodel.getLong("id")).and("extfield.number", "=", (Object)item);
            DynamicObject fieldCol = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"extfield,extfield.number", (QFilter[])new QFilter[]{fieldFilter});
            if (Objects.isNull(fieldCol)) {
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6210\u5458%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_4", (String)PROJECT, (Object[])new Object[0]), item))));
                continue;
            }
            right.add(item);
            extfields.add(item);
        }
        f.setExtfields(extfields.toArray(new String[0]));
        f.setMultiRow((Pair<String[], String[]>)new Pair((Object)new String[0], (Object)extfields.toArray(new String[0])));
        f.setAllDimShortNumber(allDimShortNumbers.toArray(new String[0]));
        this.updatebyVs(f, left, right);
    }

    public void dimchangebyVar(String dim, String type, FidmExtCommonFormula f) {
        if ("$all".equals(type.toLowerCase(Locale.ENGLISH))) {
            this.changeOneDimParam(f, dim, "");
            return;
        }
    }

    public void changeOneDimParam(FidmExtCommonFormula f, String dim, String value) {
        int dimIndex = this.getDimsIndex();
        String dimAndMembers = this.getParam(f, dimIndex);
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        ArrayList<String> result = new ArrayList<String>(dim2MemList.size());
        for (String temp : dim2MemList) {
            String[] dim2MemArr = temp.split("\\.");
            if (Objects.equals(dim.toUpperCase(Locale.ENGLISH), dim2MemArr[0])) {
                if (!StringUtils.isNotEmpty((String)value)) continue;
                result.add(dim2MemArr[0] + "." + value);
                continue;
            }
            result.add(temp);
        }
        f.getParamList().remove(dimIndex);
        f.getParamList().add(dimIndex, new ParamItem(new StringExpr(String.join((CharSequence)",", result))));
    }

    protected static EDResultSet getEdResultSet(DataSetExtService extService, FidmExtCommonFormula formula, HashMultimap<String, String> dim2MembMap, Map<String, String[]> dimFilter) {
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(formula.getShownumbner(), (String)formula.getExtGroup().p1, (String)formula.getExtModel().p2);
        edQueryComInfo.setExtselects(formula.getExtfields());
        edQueryComInfo.setNeedSum(true);
        edQueryComInfo.setMultiOrg(true);
        edQueryComInfo.setDimselects((String[])dim2MembMap.keys().stream().distinct().toArray(String[]::new));
        edQueryComInfo.setDimFilter(dimFilter);
        extService.filterMapCheck(edQueryComInfo);
        return ExtDataServiceHelper.queryData(edQueryComInfo);
    }

    @Override
    abstract int getModelIndex();

    @Override
    abstract int getDimsIndex();

    abstract int getExtModelIndex();

    abstract int getMeasuresIndex();

    abstract void updatebyVs(FidmExtCommonFormula var1, List<String> var2, List<String> var3);
}

