/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.disclosure.DataSetExtService;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.calculate.fidm.AbstractFidmExtCalculate;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.FidmExtCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.VDmExFormula;
import kd.fi.bcm.business.formula.param.ParamItem;

public class VDmExCalculate
extends AbstractFidmExtCalculate<VDmExFormula> {
    private static final String PROJECT = "fi-bcm-business";

    @Override
    protected void execCalculate(List formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        Map<ParamItem, List<FidmCommonFormula>> formulaGroup = this.groupFormulas(formulas);
        if (formulaGroup.size() == 0) {
            return;
        }
        formulaGroup.entrySet().forEach(f -> this.caculateExtValue((List)f.getValue()));
    }

    private void caculateExtValue(List<VDmExFormula> formulas) {
        VDmExFormula common = formulas.get(0);
        Map<String, String> shortNumber2Num = common.getShortNumber2Num();
        DataSetExtService extService = new DataSetExtService();
        for (VDmExFormula formula : formulas) {
            Set<String> userdifinenumbers = extService.getUserDimNumbers((Long)formula.getModel().p1);
            ExtFieldMappedService mapService = new ExtFieldMappedService((Long)formula.getModel().p1, (String)formula.getExtGroup().p1);
            Map<String, String> userdefinedims = mapService.getDimsFieldMapped(userdifinenumbers.toArray(new String[0]));
            HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims(formula, shortNumber2Num, this.getParam(formula, this.getDimsIndex()), userdefinedims);
            Map<String, String> fieldMappedForCols = mapService.getColsFieldMapped(formula.getExtfields());
            Map<String, String> fieldMappedForTypes = extService.getColsTypeMapped(formula.getExtfields(), (Long)formula.getModel().p1, (String)formula.getExtGroup().p1);
            Map<String, String> fielduncals = extService.getFieldsByType(fieldMappedForCols, fieldMappedForTypes, "uncal");
            boolean isCal = fielduncals.isEmpty();
            TreeMap<String, Collection> kvMap = new TreeMap<String, Collection>();
            HashMap<String, String[]> dimFilter = new HashMap<String, String[]>();
            dim2MembMap.asMap().forEach((k, v) -> {
                if (!formula.getNumbersAllCols().contains(k)) {
                    kvMap.put((String)k, (Collection)v);
                }
            });
            kvMap.forEach((k, v) -> dimFilter.put((String)k, v.toArray(new String[0])));
            EDResultSet edResultSet = VDmExCalculate.getEdResultSet(extService, formula, dim2MembMap, dimFilter);
            HashMap<String, Object> res = new HashMap<String, Object>(1);
            res.put(formula.getKey(), new BigDecimal("0"));
            if (!isCal && edResultSet.getRows().length > 1) {
                formula.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u8fd4\u56de\u7684\u975e\u6570\u503c\u578b\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u3002", (String)"VDmExCalculate_0", (String)PROJECT, (Object[])new Object[0]))));
                return;
            }
            edResultSet.iteratorRows(row -> {
                String extfield = formula.getExtfields()[0];
                String value = row.getString(extfield);
                if (isCal) {
                    res.put(formula.getKey(), new BigDecimal(value).add(new BigDecimal(res.get(formula.getKey()).toString())));
                } else {
                    res.put(formula.getKey(), value);
                }
            });
            formula.fillResult(res);
        }
    }

    @Override
    int getModelIndex() {
        return 0;
    }

    @Override
    int getDimsIndex() {
        return 2;
    }

    @Override
    int getExtModelIndex() {
        return 1;
    }

    @Override
    int getMeasuresIndex() {
        return 3;
    }

    @Override
    void updatebyVs(FidmExtCommonFormula f, List<String> left, List<String> right) {
    }
}

