/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.fi.bcm.business.formula.calculate.fidm.AbstractFidmCalculate;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.VDmvFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;

public class VDmvCalculate
extends AbstractFidmCalculate<VDmvFormula> {
    private static final int MODEL_INDEX = 0;
    private static final int DIMS_INDEX = 1;

    @Override
    int getModelIndex() {
        return 0;
    }

    @Override
    int getDimsIndex() {
        return 1;
    }

    @Override
    protected void execCalculate(List formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        Map<ParamItem, List<FidmCommonFormula>> formulaGroup = this.groupFormulas(formulas);
        if (formulaGroup.size() == 0) {
            return;
        }
        formulaGroup.entrySet().forEach(fs -> this.caculateOlapValue((List)fs.getValue()));
    }

    private void caculateOlapValue(List<VDmvFormula> formulas) {
        VDmvFormula common = formulas.get(0);
        String cube = common.getCube();
        Map<String, Integer> memberNum2Dseq = common.getMemberNum2Dseq();
        TreeMap kvMap = new TreeMap((k1, k2) -> (Integer)memberNum2Dseq.get(k1) - (Integer)memberNum2Dseq.get(k2));
        Map<String, String> shortNumber2Num = common.getShortNumber2Num();
        formulas.forEach(f -> {
            kvMap.clear();
            HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims((FidmCommonFormula)f, shortNumber2Num, this.getParam((FidmCommonFormula)f, this.getDimsIndex()));
            if ((f.getMemberinAllCols("E") || f.getMemberinAllCols("BP")) && f.getUseEcDcPcStr() == Boolean.TRUE) {
                f.addAllCols("C");
            }
            dim2MembMap.asMap().forEach((k, v) -> {
                if (!f.getNumbersAllCols().contains(k)) {
                    kvMap.put(k, v);
                }
            });
            SQLBuilder sql = new SQLBuilder(cube);
            sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
            kvMap.forEach((k, v) -> {
                sql.addSelectField((String)k);
                sql.addFilter((String)k, v.toArray(new String[0]));
            });
            List<String> cols = f.getNumbersAllCols();
            if (Objects.nonNull(cols) && cols.size() > 0) {
                sql.addSelectField(cols.toArray(new String[0]));
            }
            MDResultSet rs = OlapServiceHelper.queryData(sql);
            this.resetZeroByOrgCurrency(rs, (FidmCommonFormula)f);
            Map<String, Object> result = rs.asMap();
            f.fillBack(result);
        });
    }
}

