/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.fidm.VDsFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmvFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDsFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.integrationnew.provider.standard2my.ModelDataProvider;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.lang3.StringUtils;

public class VDsCalculate
extends AbstractCalculate<VDsFormula> {
    private static final int CONNECT_TAG_INDEX = 0;
    private static final int DIMS_INDEX = 1;
    private static final int GROUPBY_INDEX = 3;
    private static final int TOP_INDEX = 6;
    private static final int WITHNAME_INDEX = 7;
    private static final String FROM_TYPE_SAMEUSER = "1";
    private static final String FROM_TYPE_OTHERUSER = "2";

    @Override
    protected void initFormula() {
        for (VDsFormula f : this.originalFormulas) {
            this.checkParams(f);
            this.getShortNumber2Num(f);
        }
    }

    @Override
    protected void execCalculate(List<VDsFormula> formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        formulas.forEach(formula -> {
            if (formula.isSelfDataSource()) {
                if ("3".equals(formula.getAppType())) {
                    this.getValueEpm((VDsFormula)formula, FROM_TYPE_SAMEUSER);
                } else {
                    formula.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u540c\u79df\u6237\u8bf7\u4f7f\u7528\u5408\u5e76\u4f53\u7cfb\u6570\u636e\u6765\u6e90\u3002", (String)"VDsExCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]))));
                }
            } else {
                if (FROM_TYPE_SAMEUSER.equals(formula.getAppType()) || FROM_TYPE_OTHERUSER.equals(formula.getAppType())) {
                    this.getValueOtherBcm((VDsFormula)formula);
                }
                if ("3".equals(formula.getAppType())) {
                    this.getValueEpm((VDsFormula)formula, FROM_TYPE_OTHERUSER);
                }
            }
        });
    }

    private void getValueOtherBcm(VDsFormula formula) {
        Map<String, Object> olapResult;
        String withName;
        Map<String, Object> filter = this.getFilterMap(formula);
        if (!filter.containsKey("needAllDims")) {
            filter.put("needAllDims", "needAllDims");
        }
        Boolean needWithName = Boolean.FALSE;
        if (formula instanceof VSDsFormula && StringUtils.isNotBlank((CharSequence)(withName = VSDmvFormula.getParam(formula, 7)))) {
            needWithName = withName.equalsIgnoreCase(FROM_TYPE_SAMEUSER) ? Boolean.TRUE : Boolean.FALSE;
        }
        try {
            olapResult = IntegrationUtil.getOtherSourceOlapData(formula.getIsNgmodel(), filter, needWithName);
        }
        catch (Exception e) {
            formula.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u591a\u7ef4\u6570\u636e\u5931\u8d25\u3002", (String)"VDsCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u591a\u7ef4\u6570\u636e\u5931\u8d25\u3002", (String)"VDsCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]) + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            return;
        }
        List<Map<String, Object>> result = this.changeReturnDataType(olapResult, needWithName);
        formula.fillBack(result);
    }

    private List<Map<String, Object>> changeReturnDataType(Map<String, Object> olapResult, Boolean isWithName) {
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(16);
        List needDims = (List)olapResult.get("dimension");
        List olapData = (List)olapResult.get("data");
        for (List list : olapData) {
            Object v = list.get(needDims.size());
            if (v == null || v instanceof String) continue;
            HashMap returnMap = new HashMap(16);
            for (int i = 0; i < needDims.size(); ++i) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                if (isWithName.booleanValue()) {
                    String numberAndNameStr = (String)list.get(i);
                    String[] numberAndName = numberAndNameStr.split("\\;");
                    memberMap.put("number", numberAndName[0]);
                    memberMap.put("name", numberAndName[1]);
                } else {
                    memberMap.put("number", (String)list.get(i));
                }
                returnMap.put(needDims.get(i), memberMap);
            }
            returnMap.put("amount", v);
            returnList.add(returnMap);
        }
        return returnList;
    }

    private Map<String, Object> getFilterMap(VDsFormula formula) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        String filterParam = this.getParam(formula, 1);
        this.setParaMapByFilterParam(formula, paraMap, filterParam);
        return paraMap;
    }

    private void getValueEpm(VDsFormula formula, String fromType) {
        Map<String, Object> paraMap = this.getParaMap(formula, fromType);
        List<Map<String, Object>> res = null;
        res = FROM_TYPE_SAMEUSER.equals(fromType) ? ModelDataProvider.getResBySameUserSameSource(paraMap, null) : ModelDataProvider.getOtherSourceBGCMOlapData(formula.getIsNgmodel(), paraMap, null);
        formula.fillBack(res);
    }

    private Map<String, Object> getParaMap(VDsFormula formula, String fromType) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        this.setParaMapByModel(paraMap, formula.getEpmModelId(), formula, fromType);
        String filterParam = this.getParam(formula, 1);
        this.setParaMapByFilterParam(formula, paraMap, filterParam);
        if (paraMap.get("Account") == null) {
            paraMap.put("Account", "Account");
        }
        return paraMap;
    }

    private void setParaMapByFilterParam(VDsFormula formula, Map<String, Object> paraMap, String filterParam) {
        Map<String, String> short2Map = formula.getShortNumber2Num();
        ArrayList dim2MemList = Lists.newArrayList((Object[])filterParam.split(","));
        String[] array = null;
        List<String> realDim = null;
        for (String dim : dim2MemList) {
            array = VSDmvFormula.splitDimAndMemb(dim);
            realDim = this.getRealDimVal(array[1]);
            boolean isAll = false;
            for (String str : realDim) {
                if (!"$all".equalsIgnoreCase(str)) continue;
                isAll = true;
            }
            if (isAll) continue;
            paraMap.put(short2Map.get(array[0]), realDim);
        }
    }

    private List<String> getRealDimVal(String para) {
        if (para.startsWith("{") && para.endsWith("}")) {
            para = para.substring(1, para.length() - 1);
            return Arrays.asList(para.split(";"));
        }
        ArrayList<String> resList = new ArrayList<String>();
        resList.add(para);
        return resList;
    }

    private void setParaMapByModel(Map<String, Object> paraMap, Long id, VDsFormula formula, String fromType) {
        if (FROM_TYPE_SAMEUSER.equals(fromType)) {
            DynamicObject epmModel = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            paraMap.put("model", epmModel.getString("shownumber"));
            paraMap.put("dataSetNumber", formula.getDataSetNumber());
        } else {
            DynamicObject isNgmodel = formula.getIsNgmodel();
            paraMap.put("model", isNgmodel.getString("modelsourcenum"));
            paraMap.put("dataSetNumber", isNgmodel.getString("number"));
        }
        paraMap.put("power", true);
        paraMap.put("SpecificSymbol", true);
        paraMap.put("checkMember", true);
    }

    private void checkParams(VDsFormula f) {
        if (f.hasException()) {
            return;
        }
        if (f.getParamList().size() < 4) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u5c11\u4e8e4\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        String connectTag = this.getParam(f, 0);
        QFilter qf = new QFilter("connecttag", "=", (Object)connectTag);
        DynamicObject[] isNgModels = BusinessDataServiceHelper.load((String)"bcm_isngmodel", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_isngmodel").getAllFields().keySet()), (QFilter[])new QFilter[]{qf});
        if (isNgModels == null || isNgModels.length == 0) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDsCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        f.setIsNgmodel(isNgModels[0]);
    }

    private String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }

    private void getShortNumber2Num(VDsFormula f) {
        if (f.hasException()) {
            return;
        }
        DynamicObject isNgmodel = f.getIsNgmodel();
        boolean isSelfDataSource = this.checkIsSelfDataSource(isNgmodel);
        f.setSelfDataSource(isSelfDataSource);
        String appType = isNgmodel.getString("apptype");
        f.setAppType(appType);
        if (isSelfDataSource) {
            if ("3".equals(appType)) {
                this.getShortNumber2NumSelfEpm(f);
            }
        } else if (FROM_TYPE_SAMEUSER.equals(appType)) {
            this.getShortNumber2NumOtherBcm(f, ApplicationTypeEnum.CM.index);
        } else if (FROM_TYPE_OTHERUSER.equals(appType)) {
            this.getShortNumber2NumOtherBcm(f, ApplicationTypeEnum.RPT.index);
        } else {
            this.getShortNumber2NumOtherBcm(f, ApplicationTypeEnum.EB.index);
        }
    }

    private void getShortNumber2NumOtherBcm(VDsFormula f, String applicationType) {
        DynamicObject model = f.getIsNgmodel();
        f.setDataSetNumber(model.getString("number"));
        String phoneNumber = model.getString("phonenumber");
        KAESEncrypter ken = new KAESEncrypter();
        String password = ken.decode(model.getString("password"));
        Long tdpdatacenterId = null;
        Object tdpdatacenterObj = model.get("tdpdatacenterid");
        if (tdpdatacenterObj instanceof DynamicObject) {
            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
        } else if (tdpdatacenterObj instanceof Long) {
            tdpdatacenterId = (Long)tdpdatacenterObj;
        }
        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
        String userUrl = tdpdatacenter.getString("address");
        String loginToken = DimMappingHelper.getLoginTokenWithPass(phoneNumber, password, tdpdatacenter);
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApplicationTypeEnum.CM.index.equals(applicationType) || ApplicationTypeEnum.RPT.index.equals(applicationType)) {
            params.put("number", model.getString("number"));
            params.put("reportType", applicationType);
        } else if (ApplicationTypeEnum.EB.index.equals(applicationType)) {
            params.put("modelNumber", model.getString("modelsourcenum"));
            params.put("dataSetNumber", model.getString("number"));
        }
        try {
            String paramStr;
            String response;
            ApiResult res;
            String fullUrl = userUrl + "/kapi/app/cm/dimensionInfo";
            if (ApplicationTypeEnum.EB.index.equals(applicationType)) {
                fullUrl = userUrl + "/kapi/app/bgm/modelMemberQuery";
            }
            if (!(res = (ApiResult)JSONObject.parseObject((String)(response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)(paramStr = JSONObject.toJSONString(params)), (int)1000, (int)1800000)), ApiResult.class)).getSuccess()) {
                f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
                this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
            }
            HashMap<String, String> shortNumber2Num = new HashMap<String, String>(16);
            List data = (List)res.getData();
            if (data != null && data.size() > 0) {
                for (Map datum : data) {
                    shortNumber2Num.put(datum.get("shortnumber").toString(), datum.get("number").toString());
                }
            }
            f.setShortNumber2Num(shortNumber2Num);
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void getShortNumber2NumSelfEpm(VDsFormula f) {
        DynamicObject isNgmodel = f.getIsNgmodel();
        Long modelsourceId = isNgmodel.getLong("modelsource_id");
        DynamicObject dataSet = BusinessDataServiceHelper.loadSingle((Object)modelsourceId, (String)"eb_dataset");
        f.setDataSetNumber(dataSet.getString("number"));
        long epmModelId = dataSet.getLong("model_id");
        f.setEpmModelId(epmModelId);
        QFilter qf = new QFilter("model", "=", (Object)epmModelId);
        DynamicObjectCollection epmModels = QueryServiceHelper.query((String)"epm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{qf});
        HashMap<String, String> shortNumber2Num = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : epmModels) {
            shortNumber2Num.put(dynamicObject.getString("shortnumber"), dynamicObject.getString("number"));
        }
        f.setShortNumber2Num(shortNumber2Num);
    }

    private boolean checkIsSelfDataSource(DynamicObject isNgmodel) {
        String accountId = RequestContext.get().getAccountId();
        String userType = isNgmodel.getString("usertype");
        String dataSource = isNgmodel.getString("datasource");
        return accountId.equals(dataSource) && FROM_TYPE_SAMEUSER.equals(userType);
    }
}

