/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.fidm.VDsExFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmvFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class VDsExCalculate
extends AbstractCalculate<VDsExFormula> {
    private static final int CONNECT_TAG_INDEX = 0;
    private static final int EXDIM_INDEX = 1;
    private static final int DIMS_INDEX = 2;
    private static final int EXMEMBER_INDEX = 3;
    private static final int GROUP_INDEX = 4;
    private static final int ORDER_INDEX = 5;
    private static final int ASC_INDEX = 6;
    private static final int TOP_INDEX = 7;

    @Override
    protected void initFormula() {
        for (VDsExFormula f : this.originalFormulas) {
            this.checkParams(f);
            this.getShortNumber2Num(f);
        }
    }

    @Override
    protected void execCalculate(List<VDsExFormula> formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        formulas.forEach(formula -> {
            if ("1".equals(formula.getAppType())) {
                this.getExDimValueOtherBcm((VDsExFormula)formula);
            }
        });
    }

    private void getExDimValueOtherBcm(VDsExFormula formula) {
        Map<String, Object> filter = this.getFilterMap(formula);
        Map<String, Object> params = formula.getParams();
        params.put("filter", filter);
        List<Map<String, Object>> olapResult = null;
        try {
            olapResult = IntegrationUtil.getOtherSourceExDimData(formula.getIsNgmodel(), params);
        }
        catch (Exception e) {
            formula.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u62d3\u5c55\u7ef4\u6570\u636e\u5931\u8d25\u3002", (String)"VDsExCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u62d3\u5c55\u7ef4\u6570\u636e\u5931\u8d25\u3002", (String)"VDsExCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]) + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            return;
        }
        formula.fillBack(olapResult);
    }

    private Map<String, Object> getFilterMap(VDsExFormula formula) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        String dimsParam = this.getParam(formula, 2);
        this.setParaMapByFilterParam(formula, paraMap, dimsParam);
        return paraMap;
    }

    private void setParaMapByFilterParam(VDsExFormula formula, Map<String, Object> paraMap, String filterParam) {
        Map<String, String> short2Map = formula.getShortNumber2Num();
        ArrayList dim2MemList = Lists.newArrayList((Object[])filterParam.split(","));
        String[] array = null;
        List<String> realDim = null;
        for (String dim : dim2MemList) {
            array = VSDmvFormula.splitDimAndMemb(dim);
            realDim = this.getRealDimVal(array[0], array[1]);
            if (realDim == null) continue;
            paraMap.put(short2Map.get(array[0]), realDim);
        }
        formula.getParams().put("extnumber", this.getParam(formula, 1));
        formula.getParams().put("filed", this.getParam(formula, 3));
        formula.getParams().put("groupby", this.getParam(formula, 4));
        formula.getParams().put("orderby", this.getParam(formula, 5));
        formula.getParams().put("asc", this.getParam(formula, 6));
        formula.getParams().put("top", this.getParam(formula, 7));
    }

    private List<String> getRealDimVal(String dim, String para) {
        if (para.startsWith("{") && para.endsWith("}")) {
            para = para.substring(1, para.length() - 1);
            return Arrays.asList(para.split(";"));
        }
        if (para.startsWith("$")) {
            return (para = this.getDimensionVariable(dim, para)) == null ? null : Collections.singletonList(para);
        }
        ArrayList<String> resList = new ArrayList<String>();
        resList.add(para);
        return resList;
    }

    private String getDimensionVariable(String curDimCode, String curDimVal) {
        if ("$cur".equalsIgnoreCase(curDimVal)) {
            if (curDimCode.equalsIgnoreCase(DimTypesEnum.ENTITY.getShortNumber().toUpperCase(Locale.ENGLISH))) {
                curDimVal = this._ctx.getOrg();
            } else if (curDimCode.equalsIgnoreCase(DimTypesEnum.YEAR.getShortNumber().toUpperCase(Locale.ENGLISH))) {
                curDimVal = this._ctx.getYear();
            } else if (curDimCode.equalsIgnoreCase(DimTypesEnum.PERIOD.getShortNumber().toUpperCase(Locale.ENGLISH))) {
                curDimVal = this._ctx.getPeriod();
            } else if (curDimCode.equalsIgnoreCase(DimTypesEnum.SCENARIO.getShortNumber().toUpperCase(Locale.ENGLISH))) {
                curDimVal = this._ctx.getScenario();
            } else if (curDimCode.equalsIgnoreCase(DimTypesEnum.CURRENCY.getShortNumber().toUpperCase(Locale.ENGLISH))) {
                curDimVal = this._ctx.getCurrency();
            }
        }
        return curDimVal;
    }

    private void checkParams(VDsExFormula f) {
        if (f.hasException()) {
            return;
        }
        if (f.getParamList().size() < 4) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u4e2a\u6570\u5c11\u4e8e4\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDmCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        String connectTag = this.getParam(f, 0);
        QFilter qf = new QFilter("connecttag", "=", (Object)connectTag);
        DynamicObject[] isNgModels = BusinessDataServiceHelper.load((String)"bcm_isngmodel", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_isngmodel").getAllFields().keySet()), (QFilter[])new QFilter[]{qf});
        if (isNgModels == null || isNgModels.length == 0) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"VDsCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
            return;
        }
        f.setIsNgmodel(isNgModels[0]);
    }

    private String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }

    private void getShortNumber2Num(VDsExFormula f) {
        if (f.hasException()) {
            return;
        }
        DynamicObject isNgmodel = f.getIsNgmodel();
        boolean isSelfDataSource = this.checkIsSelfDataSource(isNgmodel);
        f.setSelfDataSource(isSelfDataSource);
        String appType = isNgmodel.getString("apptype");
        f.setAppType(appType);
        if (isSelfDataSource) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u540c\u79df\u6237\u8bf7\u4f7f\u7528\u5408\u5e76\u4f53\u7cfb\u6570\u636e\u6765\u6e90\u3002", (String)"VDsExCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]))));
        } else if ("1".equals(appType)) {
            this.getShortNumber2NumOtherBcm(f);
        }
    }

    private void getShortNumber2NumOtherBcm(VDsExFormula f) {
        DynamicObject ngModel = f.getIsNgmodel();
        f.setDataSetNumber(ngModel.getString("number"));
        String loginToken = IntegrationUtil.getLoginToken(ngModel);
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("number", ngModel.getString("number"));
        params.put("reportType", ApplicationTypeEnum.CM.index);
        try {
            Long tdpdatacenterId = null;
            Object tdpdatacenterObj = ngModel.get("tdpdatacenterid");
            if (tdpdatacenterObj instanceof DynamicObject) {
                tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
            } else if (tdpdatacenterObj instanceof Long) {
                tdpdatacenterId = (Long)tdpdatacenterObj;
            }
            DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
            String url = tdpdatacenter.getString("address");
            String fullUrl = url + "/kapi/app/cm/dimensionInfo";
            String paramStr = JSONObject.toJSONString(params);
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)1000, (int)1800000);
            ApiResult res = (ApiResult)JSONObject.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
                this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
            }
            HashMap<String, String> shortNumber2Num = new HashMap<String, String>(16);
            List data = (List)res.getData();
            if (data != null && data.size() > 0) {
                for (Map datum : data) {
                    shortNumber2Num.put(datum.get("shortnumber").toString(), datum.get("number").toString());
                }
            }
            f.setShortNumber2Num(shortNumber2Num);
        }
        catch (Exception e) {
            f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]))));
            this.log.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\u3002", (String)"VDsCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private boolean checkIsSelfDataSource(DynamicObject isNgmodel) {
        String accountId = RequestContext.get().getAccountId();
        String userType = isNgmodel.getString("usertype");
        String dataSource = isNgmodel.getString("datasource");
        return accountId.equals(dataSource) && "1".equals(userType);
    }
}

