/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.disclosure.DataSetExtService;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.formula.calculate.fidm.AbstractFidmExtCalculate;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.FidmExtCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmExFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class VSDmExCalculate
extends AbstractFidmExtCalculate<VSDmExFormula> {
    private static final int GROUP_INDEX = 4;
    private static final int ORDER_INDEX = 5;
    private static final int ASC_INDEX = 6;
    private static final int TOP_INDEX = 7;

    @Override
    protected void execCalculate(List formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        Map<ParamItem, List<FidmCommonFormula>> formulaGroup = this.groupFormulas(formulas);
        if (formulaGroup.size() == 0) {
            return;
        }
        formulaGroup.entrySet().forEach(model -> this.caculateExtValue((List)model.getValue()));
    }

    private void caculateExtValue(List<VSDmExFormula> formulas) {
        VSDmExFormula common = formulas.get(0);
        Map<String, String> shortNumber2Num = common.getShortNumber2Num();
        DataSetExtService extService = new DataSetExtService();
        for (VSDmExFormula formula : formulas) {
            Set<String> userdifinenumbers = extService.getUserDimNumbers((Long)formula.getModel().p1);
            ExtFieldMappedService mapService = new ExtFieldMappedService((Long)formula.getModel().p1, (String)formula.getExtGroup().p1);
            Map<String, String> userdefinedims = mapService.getDimsFieldMapped(userdifinenumbers.toArray(new String[0]));
            HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims(formula, shortNumber2Num, this.getParam(formula, this.getDimsIndex()), userdefinedims);
            Map<String, String> fieldMappedForCols = mapService.getColsFieldMapped(formula.getExtfields());
            Map<String, String> fieldMappedForTypes = extService.getColsTypeMapped(formula.getExtfields(), (Long)formula.getModel().p1, (String)formula.getExtGroup().p1);
            Map<String, String> fieldcals = extService.getFieldsByType(fieldMappedForCols, fieldMappedForTypes, "cal");
            TreeMap<String, Collection> kvMap = new TreeMap<String, Collection>();
            HashMap<String, String[]> dimFilter = new HashMap<String, String[]>();
            dim2MembMap.asMap().forEach((k, v) -> {
                if (!formula.getNumbersAllCols().contains(k)) {
                    kvMap.put((String)k, (Collection)v);
                }
            });
            kvMap.forEach((k, v) -> dimFilter.put((String)k, v.toArray(new String[0])));
            EDResultSet edResultSet = VSDmExCalculate.getEdResultSet(extService, formula, dim2MembMap, dimFilter);
            Map<String, String> selectMap = VSDmExCalculate.selectHandler(dim2MembMap);
            ArrayList result = Lists.newArrayListWithCapacity((int)edResultSet.getRows().length);
            edResultSet.iteratorRows(row -> {
                LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)row.getMetaData().getColMetaDatas().size());
                List<EDColumn> colMetaDatas = row.getMetaData().getColMetaDatas();
                for (EDColumn column : colMetaDatas) {
                    String mdName = column.getMdName();
                    if (fieldcals.containsKey(mdName)) {
                        String value = row.getString(mdName);
                        if (value.contains("E") || value.contains("e")) {
                            map.put(mdName, new BigDecimal(value).stripTrailingZeros());
                            continue;
                        }
                        map.put(mdName, new BigDecimal(value));
                        continue;
                    }
                    String res = selectMap.getOrDefault(mdName, row.getString(mdName));
                    map.put(mdName, res);
                }
                result.add(map);
            });
            HashMap<String, List<Map<String, Object>>> res = new HashMap<String, List<Map<String, Object>>>(1);
            res.put(formula.getKey(), result);
            formula.fillMResult(res);
        }
    }

    private static Map<String, String> selectHandler(HashMultimap<String, String> dim2MembMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        String process = dim2MembMap.get((Object)DimTypesEnum.PROCESS.getNumber()).toArray(new String[0])[0];
        String auditTrial = dim2MembMap.get((Object)DimTypesEnum.AUDITTRIAL.getNumber()).toArray(new String[0])[0];
        map.put(DimTypesEnum.PROCESS.getNumber(), process);
        map.put(DimTypesEnum.AUDITTRIAL.getNumber(), auditTrial);
        return map;
    }

    private String[] getValidateMembers(FidmExtCommonFormula f, Map<String, String> shortNumber2Num, int index) {
        ArrayList<String> list = new ArrayList<String>(8);
        String dimAndMembers = this.getParam(f, index);
        if (StringUtils.isEmpty((String)dimAndMembers)) {
            return list.toArray(new String[0]);
        }
        String[] dim2MemArr = dimAndMembers.split(",");
        String extnumber = this.getParam(f, this.getExtModelIndex());
        QFilter extmodelFilter = new QFilter("number", "=", (Object)extnumber).and("model.shownumber", "=", (Object)this.getParam(f, this.getModelIndex()));
        DynamicObject extmodel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{extmodelFilter});
        for (String item : dim2MemArr) {
            if (StringUtils.isEmpty((String)item)) continue;
            if (shortNumber2Num.containsKey(item.toUpperCase(Locale.ENGLISH))) {
                list.add(item);
                continue;
            }
            QFilter fieldFilter = new QFilter("extmodelid", "=", (Object)extmodel.getLong("id")).and("extfield.number", "=", (Object)item);
            DynamicObject fieldCol = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"extfield,extfield.number", (QFilter[])new QFilter[]{fieldFilter});
            if (Objects.isNull(fieldCol)) continue;
            list.add(item);
        }
        return list.toArray(new String[0]);
    }

    @Override
    int getModelIndex() {
        return 0;
    }

    @Override
    int getExtModelIndex() {
        return 1;
    }

    @Override
    void updatebyVs(FidmExtCommonFormula f, List<String> left, List<String> right) {
        f.setMultiRow((Pair<String[], String[]>)new Pair((Object)left.toArray(new String[0]), (Object)right.toArray(new String[0])));
        Map<String, String> shortNumber2Num = f.getShortNumber2Num();
        f.addGroupby(this.getValidateMembers(f, shortNumber2Num, 4));
        f.addOrderby(this.getValidateMembers(f, shortNumber2Num, 5));
        f.setAsc(Integer.parseInt(this.getParam(f, 6)));
        if (StringUtils.isNotEmpty((String)this.getParam(f, 7))) {
            f.setTop(Integer.parseInt(this.getParam(f, 7)));
        }
    }

    @Override
    int getDimsIndex() {
        return 2;
    }

    @Override
    int getMeasuresIndex() {
        return 3;
    }
}

