/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.fidm;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.formula.calculate.fidm.AbstractFidmCalculate;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmvFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class VSDmvCalculate
extends AbstractFidmCalculate<VSDmvFormula> {
    private static final int MODEL_INDEX = 0;
    private static final int DIMS_INDEX = 1;
    private static final int GROUPBY_INDEX = 3;
    private static final int DEFAUT_SIZE = 10000;

    @Override
    int getModelIndex() {
        return 0;
    }

    @Override
    int getDimsIndex() {
        return 1;
    }

    @Override
    protected void execCalculate(List formulas) {
        if (formulas.isEmpty()) {
            return;
        }
        Map<ParamItem, List<FidmCommonFormula>> formulaGroup = this.groupFormulas(formulas);
        if (formulaGroup.size() == 0) {
            return;
        }
        formulaGroup.entrySet().forEach(fs -> this.caculateOlapValue((List)fs.getValue()));
    }

    private void caculateOlapValue(List<VSDmvFormula> formulas) {
        VSDmvFormula common = formulas.get(0);
        String cube = common.getCube();
        Map<String, Integer> memberNum2Dseq = common.getMemberNum2Dseq();
        TreeMap kvMap = new TreeMap((k1, k2) -> (Integer)memberNum2Dseq.get(k1) - (Integer)memberNum2Dseq.get(k2));
        Map<String, String> shortNumber2Num = common.getShortNumber2Num();
        formulas.forEach(formula -> {
            HashSet<String> filedsselected = new HashSet<String>(16);
            kvMap.clear();
            HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims((FidmCommonFormula)formula, shortNumber2Num, this.getParam((FidmCommonFormula)formula, this.getDimsIndex()));
            if (formula.getUseEcDcPcStr() == Boolean.TRUE && (formula.getMemberinAllCols("E") || formula.getMemberinAllCols("BP"))) {
                formula.addAllCols("C");
            }
            dim2MembMap.asMap().forEach((k, v) -> {
                if (!formula.getNumbersAllCols().contains(k)) {
                    kvMap.put(k, v);
                }
            });
            SQLBuilder sql = new SQLBuilder(cube);
            sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
            List<String> groupList = VSDmvFormula.getNeedListByIndex(shortNumber2Num, formula, 3);
            if (!CollectionUtils.isEmpty(groupList)) {
                groupList.forEach(e -> filedsselected.addAll(groupList));
            }
            sql.setTop(10000);
            kvMap.forEach((k, v) -> {
                if (CollectionUtils.isEmpty((Collection)groupList)) {
                    filedsselected.add((String)k);
                }
                sql.addFilter((String)k, v.toArray(new String[0]));
            });
            List<String> cols = formula.getNumbersAllCols();
            if (Objects.nonNull(cols) && cols.size() > 0) {
                filedsselected.addAll(cols);
            }
            sql.addSelectField(filedsselected.toArray(new String[0]));
            MDResultSet rs = null;
            try {
                rs = OlapServiceHelper.queryData(sql);
                this.resetZeroByOrgCurrency(rs, (FidmCommonFormula)formula);
            }
            catch (Exception e2) {
                rs = new MDResultSet();
            }
            formula.fillBack(rs);
        });
    }

    public String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }
}

