/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.innertrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.innertrade.DvbFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.formula.util.FormulaUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class DvbCalculate
extends AbstractCalculate<DvbFormula> {
    @Override
    protected void execCalculate(List<DvbFormula> formulas) {
        formulas.forEach(formula -> {
            ParamList paramList = formula.getParamList();
            String paramItem = ((ParamItem)paramList.get(0)).toString();
            String[] split = paramItem.split("@");
            String extModel = split[0];
            String extDim = split[1];
            String rowKey = FormulaUtils.getRowKey(paramList);
            Map intrRow = (Map)FormulaUtils.getModelData(this._ctx, rowKey, extModel);
            BigDecimal dValue = (BigDecimal)intrRow.get(extDim);
            String paramItem2 = ((ParamItem)paramList.get(1)).toString();
            if (StringUtils.isBlank((CharSequence)paramItem2) || !paramItem2.contains("@")) {
                formula.fillBack(dValue);
                return;
            }
            String[] split2 = paramItem2.split("@");
            String extModel2 = split2[0];
            String extDim2 = split2[1];
            Map intrRow2 = (Map)FormulaUtils.getModelData(this._ctx, rowKey, extModel2);
            List rowList = (List)FormulaUtils.getModelData(this._ctx, rowKey, extModel2 + "_list");
            BigDecimal eValue = (BigDecimal)intrRow2.get(extDim2);
            eValue = eValue == null ? BigDecimal.ZERO : eValue;
            BigDecimal sum = BigDecimal.ZERO;
            for (Map rowMap : rowList) {
                BigDecimal v = (BigDecimal)rowMap.get(extDim2);
                v = v == null ? BigDecimal.ZERO : v;
                sum = sum.add(v);
            }
            BigDecimal result = dValue == null ? eValue : dValue.multiply(eValue.divide(sum, 15, RoundingMode.HALF_DOWN)).setScale(10, RoundingMode.HALF_DOWN);
            formula.fillBack(result);
        });
    }

    @Override
    protected void initFormula() {
    }
}

