/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.innertrade;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.innertrade.PnFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.formula.util.FormulaUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import org.apache.commons.lang3.StringUtils;

public class PnCalculate
extends AbstractCalculate<PnFormula> {
    public static final String DEFAULT_START_PERIOD = "01";

    @Override
    protected void execCalculate(List<PnFormula> formulas) {
        formulas.forEach(formula -> {
            long result = 0L;
            try {
                ParamList paramList = formula.getParamList();
                String rowKey = FormulaUtils.getRowKey(paramList);
                String startYear = this.getYearNode((ParamItem)paramList.get(0), rowKey);
                String endYear = this.getYearNode((ParamItem)paramList.get(2), rowKey);
                String startPeriod = this.getPeriodNode((ParamItem)paramList.get(1), rowKey);
                String endPeriod = this.getPeriodNode((ParamItem)paramList.get(3), rowKey);
                if (StringUtils.isNotBlank((CharSequence)startYear) && StringUtils.isNotBlank((CharSequence)endYear) && StringUtils.isNotBlank((CharSequence)startPeriod) && StringUtils.isNotBlank((CharSequence)endPeriod)) {
                    result = ChronoUnit.MONTHS.between(this.getTemporalTime(startYear, startPeriod), this.getTemporalTime(endYear, endPeriod));
                }
            }
            catch (Exception e) {
                this.log.error("\u671f\u6570\u516c\u5f0f\u8ba1\u7b97\u5f02\u5e38\uff0c\u53c2\u6570\uff1a" + formula.getParamList(), (Throwable)e);
            }
            formula.fillBack(result);
        });
    }

    private Temporal getTemporalTime(String year, String period) {
        return LocalDate.parse(String.format("%s-%02d-01", year, Integer.parseInt(period)));
    }

    private String getYearNode(ParamItem paramItem, String rowKey) {
        if (paramItem == null) {
            return null;
        }
        String param = paramItem.toString();
        if ("currentYear".equals(param) || "startYear".equals(param)) {
            return StringUtils.substring((String)MemberReader.findFyMemberById((String)this._ctx.getCubeNumber(), (Long)this._ctx.getYearId()).getNumber(), (int)"FY".length());
        }
        if (param.contains("@")) {
            String[] split = param.split("@");
            String model = split[0];
            String dim = split[1];
            Map syIntrRow = (Map)FormulaUtils.getModelData(this._ctx, rowKey, model);
            String syStr = syIntrRow.getOrDefault(dim, "");
            if (syStr != null) {
                IDNumberTreeNode node = MemberReader.findFyMemberByNum((String)this._ctx.getCubeNumber(), (String)syStr.toString());
                if (IDNumberTreeNode.NotFoundTreeNode != node) {
                    return node.getNumber().substring("FY".length());
                }
                return StringUtils.substring((String)syStr.toString(), (int)"FY".length());
            }
        }
        return null;
    }

    private String getPeriodNode(ParamItem paramItem, String rowKey) {
        if (paramItem == null) {
            return "";
        }
        String param = paramItem.toString();
        if ("currentPeriod".equals(param)) {
            return MemberReader.findPeriodMemberById((String)this._ctx.getCubeNumber(), (Long)this._ctx.getPeriodId()).getProperty("expmonth").toString();
        }
        if ("startPeriod".equals(param)) {
            return DEFAULT_START_PERIOD;
        }
        if (param.contains("@")) {
            String[] split = param.split("@");
            String model = split[0];
            String dim = split[1];
            Map syIntrRow = (Map)FormulaUtils.getModelData(this._ctx, rowKey, model);
            String syStr = syIntrRow.getOrDefault(dim, "");
            if (syStr != null) {
                IDNumberTreeNode node = MemberReader.findPeriodMemberByNum((String)this._ctx.getCubeNumber(), (String)syStr.toString());
                if (IDNumberTreeNode.NotFoundTreeNode != node) {
                    return node.getProperty("expmonth").toString();
                }
                return StringUtils.substring((String)syStr.toString(), (int)"M_M".length());
            }
        }
        return "";
    }

    @Override
    protected void initFormula() {
    }
}

