/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.inv;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.inv.DEspFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvFetchType;
import kd.fi.bcm.common.util.QFBuilder;
import org.jetbrains.annotations.NotNull;

public class DEspCalculate
extends AbstractCalculate<DEspFormula> {
    private final Table<String, String, BigDecimal> kvMap = HashBasedTable.create();
    private final HashMultimap<String, DEspFormula> unit2Formulas = HashMultimap.create();
    private static final String SELECT_FIELDS = "scenario.number, year.number, period.number,merge.number, shareholder.number , investeecompany.number,invchangetype.number,confirmopenscale,confirmchangescale,confirmsharescale";

    @Override
    protected void execCalculate(List<DEspFormula> formulas) {
        Long modelId = this._ctx.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        this.unit2Formulas.forEach((unitNum, formula) -> {
            ParamItem changetypeitem = (ParamItem)formula.getParamList().get(0);
            if (StringUtils.isEmpty((CharSequence)changetypeitem.toString())) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f[%s]\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DEspCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), "DEspCalculate_1", formula))));
                return;
            }
            IDNumberTreeNode shareholderNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)((ParamItem)formula.getParamList().get(5)).toString());
            if (IDNumberTreeNode.NotFoundTreeNode == shareholderNode) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 6))));
                return;
            }
            IDNumberTreeNode investnode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)((ParamItem)formula.getParamList().get(6)).toString());
            if (IDNumberTreeNode.NotFoundTreeNode == investnode) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 7))));
                return;
            }
            formula.fillBack((BigDecimal)this.kvMap.get(unitNum, (Object)formula.getKey()));
        });
    }

    @NotNull
    private String getKey(String fixKeys, String changeType, String fetchType) {
        StringBuilder key = new StringBuilder();
        key.append(changeType);
        key.append('#');
        key.append(fetchType);
        key.append('#');
        key.append(fixKeys);
        return key.toString();
    }

    @Override
    protected void initFormula() {
        int size = this.originalFormulas.size();
        HashSet icSet = new HashSet(size);
        HashSet investSet = new HashSet(size);
        HashSet changeTypeSet = new HashSet(8);
        StringBuilder fixKeys = new StringBuilder();
        HashSet scenarioNumbers = Sets.newHashSet();
        HashSet yearNumbers = Sets.newHashSet();
        HashSet periodNumbers = Sets.newHashSet();
        HashSet unitNumbers = Sets.newHashSet();
        scenarioNumbers.add(this._ctx.getScenario());
        yearNumbers.add(this._ctx.getYear());
        periodNumbers.add(this._ctx.getPeriod());
        String orgUnitNumber = (String)this._ctx.getProperty("orgUnitNumber");
        if (!kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
            unitNumbers.add(orgUnitNumber);
        }
        this.originalFormulas.forEach(s -> {
            ParamList paramList = s.getParamList();
            if (paramList.size() == 7) {
                this.unit2Formulas.put((Object)(orgUnitNumber == null ? "" : orgUnitNumber), s);
            } else {
                this.unit2Formulas.put((Object)((ParamItem)paramList.remove(0)).getParam().toString(), s);
            }
            ParamItem item = (ParamItem)paramList.get(0);
            if (!StringUtils.isEmpty((CharSequence)item.toString())) {
                changeTypeSet.add(item.toString());
            }
            scenarioNumbers.add(((ParamItem)s.getParamList().get(2)).toString());
            yearNumbers.add(((ParamItem)s.getParamList().get(3)).toString());
            periodNumbers.add(((ParamItem)s.getParamList().get(4)).toString());
            icSet.add(((ParamItem)s.getParamList().get(5)).toString());
            investSet.add(((ParamItem)s.getParamList().get(6)).toString());
        });
        unitNumbers.addAll(this.unit2Formulas.keySet());
        QFBuilder qf = new QFBuilder().add(new QFilter("model.number", "=", (Object)this._ctx.getCubeNumber())).add("scenario.number", "in", (Object)scenarioNumbers).add("year.number", "in", (Object)yearNumbers).add("period.number", "in", (Object)periodNumbers);
        if (!StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
            qf.add("merge.number", "in", (Object)unitNumbers);
        }
        qf.add("status", "=", (Object)"0");
        qf.add("level", "=", (Object)2);
        qf.add("shareholder.number", "in", icSet);
        qf.add("investeecompany.number", "in", investSet);
        qf.add("invchangetype.number", "in", changeTypeSet);
        DynamicObjectCollection dynamicstockratios = QueryServiceHelper.query((String)"bcm_dynamicstockratio", (String)SELECT_FIELDS, (QFilter[])qf.toArray());
        dynamicstockratios.forEach(e -> {
            String unitNum = e.getString("merge.number");
            fixKeys.append(e.getString("scenario.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("year.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("period.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("shareholder.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("investeecompany.number"));
            String changeType = e.getString("invchangetype.number");
            BigDecimal result = BigDecimal.ZERO;
            result = e.getBigDecimal("confirmopenscale");
            this.putValue(unitNum, this.getKey(fixKeys.toString(), changeType, InvFetchType.ConfirmBeginScale.name()), InvestFormulaParseHelper.delTailZero(result.divide(new BigDecimal(100))));
            result = e.getBigDecimal("confirmchangescale");
            this.putValue(unitNum, this.getKey(fixKeys.toString(), changeType, InvFetchType.ConfirmChangeScale.name()), InvestFormulaParseHelper.delTailZero(result.divide(new BigDecimal(100))));
            result = e.getBigDecimal("confirmsharescale");
            this.putValue(unitNum, this.getKey(fixKeys.toString(), changeType, InvFetchType.ConfirmEndScale.name()), InvestFormulaParseHelper.delTailZero(result.divide(new BigDecimal(100))));
            fixKeys.setLength(0);
        });
    }

    private void putValue(String unitNum, String fixKeys, BigDecimal value) {
        this.kvMap.put((Object)unitNum, (Object)fixKeys, (Object)value);
        this.kvMap.put((Object)"", (Object)fixKeys, (Object)value);
    }
}

