/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.inv;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.inv.EspFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.enums.invest.HolderTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class EspCalculate
extends AbstractCalculate<EspFormula> {
    private final Table<String, String, BigDecimal> kvMap = HashBasedTable.create();
    private static final String SELECT_FIELDS = "scenario.number, year.number, period.number, invrelatype,shareholder.number , investeecompany.number,equvscale,confirmscale,minconfirmscale,orgunit.number";

    @Override
    protected void execCalculate(List<EspFormula> formulas) {
        StringBuilder sb = new StringBuilder();
        StringBuilder fixKeys = new StringBuilder();
        HashSet scenarioNumbers = Sets.newHashSet();
        HashSet yearNumbers = Sets.newHashSet();
        HashSet periodNumbers = Sets.newHashSet();
        HashSet unitNumbers = Sets.newHashSet();
        scenarioNumbers.add(this._ctx.getScenario());
        yearNumbers.add(this._ctx.getYear());
        periodNumbers.add(this._ctx.getPeriod());
        String orgUnitNumber = (String)this._ctx.getProperty("orgUnitNumber");
        if (!StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
            unitNumbers.add(orgUnitNumber);
        }
        HashMultimap unit2Formulas = HashMultimap.create();
        this.originalFormulas.forEach(f -> {
            ParamList paramList = f.getParamList();
            if (paramList.size() == 7) {
                unit2Formulas.put((Object)(orgUnitNumber == null ? "" : orgUnitNumber), f);
            } else {
                unit2Formulas.put((Object)((ParamItem)paramList.remove(0)).getParam().toString(), f);
            }
            scenarioNumbers.add(((ParamItem)paramList.get(2)).toString());
            yearNumbers.add(((ParamItem)paramList.get(3)).toString());
            periodNumbers.add(((ParamItem)paramList.get(4)).toString());
        });
        unitNumbers.addAll(unit2Formulas.keySet());
        QFBuilder qf = new QFBuilder().add("model.number", "=", (Object)this._ctx.getCubeNumber()).add("scenario.number", "in", (Object)scenarioNumbers).add("year.number", "in", (Object)yearNumbers).add("period.number", "in", (Object)periodNumbers).add("isdelete", "=", (Object)"0");
        if (!StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
            qf.add("orgunit.number", "in", (Object)unitNumbers);
        }
        DynamicObjectCollection invColl = QueryServiceHelper.query((String)"bcm_invrelation", (String)SELECT_FIELDS, (QFilter[])qf.toArray());
        invColl.forEach(e -> {
            String unitNum = e.getString("orgunit.number");
            fixKeys.append(e.getString("scenario.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("year.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("period.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("shareholder.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("investeecompany.number"));
            if (e.getString("invrelatype").equals(InvRelaTypeEnum.INDirectRelaType.getType())) {
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.INDirectRelaType, HolderTypeEnum.equivalentAdd, "confirmscale", (DynamicObject)e);
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.INDirectRelaType, HolderTypeEnum.littleAdd, "minconfirmscale", (DynamicObject)e);
            } else if (e.getString("invrelatype").equals(InvRelaTypeEnum.DirectRelaType.getType())) {
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.DirectRelaType, HolderTypeEnum.direct, "confirmscale", (DynamicObject)e);
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.DirectRelaType, HolderTypeEnum.little, "minconfirmscale", (DynamicObject)e);
            } else if (e.getString("invrelatype").equals(InvRelaTypeEnum.MultiRelaType.getType())) {
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.MultiRelaType, HolderTypeEnum.equivalentMulti, "confirmscale", (DynamicObject)e);
                this.putValue(unitNum, fixKeys, sb, InvRelaTypeEnum.MultiRelaType, HolderTypeEnum.littleMulti, "minconfirmscale", (DynamicObject)e);
            } else if (e.getString("invrelatype").equals(InvRelaTypeEnum.MinRelaType.getType()) || e.getString("invrelatype").equals(InvRelaTypeEnum.SameLevelRelaType.getType())) {
                Optional.ofNullable(InvRelaTypeEnum.findEnumByType((String)e.getString("invrelatype"))).ifPresent(invRelaType -> this.putValue(unitNum, fixKeys, sb, (InvRelaTypeEnum)invRelaType, HolderTypeEnum.little, "minconfirmscale", (DynamicObject)e));
            } else {
                Optional.ofNullable(InvRelaTypeEnum.findEnumByType((String)e.getString("invrelatype"))).ifPresent(invRelaType -> {
                    this.putValue(unitNum, fixKeys, sb, (InvRelaTypeEnum)invRelaType, HolderTypeEnum.DefindScale, "confirmscale", (DynamicObject)e);
                    this.putValue(unitNum, fixKeys, sb, (InvRelaTypeEnum)invRelaType, HolderTypeEnum.little, "minconfirmscale", (DynamicObject)e);
                });
            }
            fixKeys.setLength(0);
        });
        unit2Formulas.forEach((unitNum, formula) -> formula.fillBack((BigDecimal)this.kvMap.get(unitNum, (Object)formula.getKey())));
    }

    private void putValue(String unitNum, StringBuilder fixKeys, StringBuilder sb, InvRelaTypeEnum relaType, HolderTypeEnum numbType, String rateField, DynamicObject e) {
        sb.append(relaType.getType());
        sb.append('#');
        sb.append(numbType.getNumber());
        sb.append('#');
        sb.append((CharSequence)fixKeys);
        BigDecimal value = InvestFormulaParseHelper.delTailZero(e.getBigDecimal(rateField).divide(new BigDecimal(100)));
        this.kvMap.put((Object)unitNum, (Object)sb.toString(), (Object)value);
        this.kvMap.put((Object)"", (Object)sb.toString(), (Object)value);
        sb.setLength(0);
    }

    @Override
    protected void initFormula() {
        this.originalFormulas.forEach(f -> {
            if (!f.hasException() && f.getParamList().size() != 7 && f.getParamList().size() != 8) {
                f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u201c%1$s\u201d\u9700\u8981%2$s\u4e2a\u53c2\u6570\uff0c\u53ea\u63d0\u4f9b\u4e86%3$s\u4e2a\u3002", (String)"EspCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), f, 7, f.getParamList().size()))));
            }
        });
    }
}

