/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.inv;

import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.calculate.inv.InvShareCalculate;
import kd.fi.bcm.business.formula.model.inv.InvShareFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvChangeType;
import kd.fi.bcm.common.util.QFBuilder;

public class GetInvActCalculate
extends InvShareCalculate {
    private static final String SELECT_FIELDS = "sharecase.number,shareholder.number , investeecompany.number,holderec.number,invchangetype.number,investdate,investamount";
    ArrayListMultimap<String, DynamicObject> resultGroupData = ArrayListMultimap.create();

    @Override
    protected void execCalculate(List<InvShareFormula> formulas) {
        Long modelId = this._ctx.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (InvShareFormula formula : formulas) {
            StringJoiner key = new StringJoiner(String.valueOf('#'));
            String caseNumber = ((ParamItem)formula.getParamList().get(0)).toString();
            Object id = this.caseMap.get(caseNumber);
            if (id == null) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 1))));
                continue;
            }
            key.add(caseNumber);
            String icNumber = ((ParamItem)formula.getParamList().get(3)).toString();
            IDNumberTreeNode shareholderNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)icNumber);
            if (IDNumberTreeNode.NotFoundTreeNode == shareholderNode) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 4))));
                continue;
            }
            key.add(icNumber);
            String modelnumber = MemberReader.findModelNumberById((Object)modelId);
            String investNumber = ((ParamItem)formula.getParamList().get(4)).toString();
            IDNumberTreeNode invest = MemberReader.findEntityMemberByNum((String)modelnumber, (String)investNumber);
            if (IDNumberTreeNode.NotFoundTreeNode == invest) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 5))));
                continue;
            }
            key.add(investNumber);
            ParamItem currency = (ParamItem)formula.getParamList().get(5);
            IDNumberTreeNode cur = MemberReader.findCurrencyMemberByNum((String)modelnumber, (String)currency.toString());
            if (IDNumberTreeNode.NotFoundTreeNode == cur) {
                formula.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u4e3a\u7a7a\u6216\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetInvPerCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), 6))));
                continue;
            }
            key.add(currency.toString());
            String changetype = ((ParamItem)formula.getParamList().get(1)).toString();
            ParamItem startdate = (ParamItem)formula.getParamList().get(6);
            ParamItem enddate = (ParamItem)formula.getParamList().get(7);
            List ds = this.resultGroupData.get((Object)key.toString());
            if (ds.size() <= 0) continue;
            BigDecimal result = ds.stream().filter(s -> {
                String dyChangeType = s.getString("invchangetype.number");
                if (!StringUtil.isEmpty((CharSequence)changetype) && !InvChangeType.None.name().equals(changetype)) {
                    return changetype.equals(dyChangeType);
                }
                return true;
            }).filter(s -> {
                Date investDate = s.getDate("investdate");
                if (!StringUtil.isEmpty((CharSequence)startdate.toString())) {
                    return startdate.toDate().compareTo(investDate) <= 0;
                }
                return true;
            }).filter(s -> {
                Date investDate = s.getDate("investdate");
                if (!StringUtil.isEmpty((CharSequence)enddate.toString())) {
                    return enddate.toDate().compareTo(investDate) >= 0;
                }
                return true;
            }).map(s -> s.getBigDecimal("investamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            formula.fillBack(InvestFormulaParseHelper.delTailZero(result));
        }
    }

    @Override
    protected void initFormula() {
        int size = this.originalFormulas.size();
        HashSet icSet = new HashSet(size);
        HashSet investSet = new HashSet(size);
        HashSet<String> caseSet = new HashSet<String>(size);
        HashSet currencySet = new HashSet(size);
        StringBuilder fixKeys = new StringBuilder();
        this.originalFormulas.forEach(s -> {
            caseSet.add(((ParamItem)s.getParamList().get(0)).toString());
            icSet.add(((ParamItem)s.getParamList().get(3)).toString());
            investSet.add(((ParamItem)s.getParamList().get(4)).toString());
            currencySet.add(((ParamItem)s.getParamList().get(5)).toString());
        });
        QFBuilder qf = new QFBuilder().add(new QFilter("model.number", "=", (Object)this._ctx.getCubeNumber()));
        qf.add("sharecase.number", "in", caseSet);
        qf.add("shareholder.number", "in", icSet);
        qf.add("investeecompany.number", "in", investSet);
        qf.add("holderec.number", "in", currencySet);
        DynamicObjectCollection invshareColl = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_invsharerela", (String)SELECT_FIELDS, (QFilter[])qf.toArray(), (String)"investdate asc");
        invshareColl.forEach(e -> {
            fixKeys.append(e.getString("sharecase.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("shareholder.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("investeecompany.number"));
            fixKeys.append('#');
            fixKeys.append(e.getString("holderec.number"));
            this.resultGroupData.put((Object)fixKeys.toString(), e);
            fixKeys.setLength(0);
        });
        this.caseMap = this.getCaseMap(caseSet);
    }
}

