/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.inv;

import com.google.common.collect.ArrayListMultimap;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.model.inv.InvFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang3.tuple.Triple;

public class InvCalculate
extends AbstractCalculate<InvFormula> {
    private static final String GROUP_DATA = "groupData";
    private static final String SELECT_FIELD = "account, account.number, changetype.number, investeecompany.number, changedate, invcompanycurrency.number, changeamount, cvt1currenyid.number, change1amount, cvt2currenyid.number, change2amount, cvt3currenyid.number, change3amount, cvt4currenyid.number, change4amount, cvt5currenyid.number, change5amount";
    private Set<String> accountNumbers = new HashSet<String>();
    private Set<String> changeTypeNumbers = new HashSet<String>();
    private Set<String> investeecompanyNumbers = new HashSet<String>();

    @Override
    protected void execCalculate(List<InvFormula> formulas) {
        DynamicObjectCollection query = null;
        if (this.accountNumbers.size() > 0) {
            query = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)SELECT_FIELD, (QFilter[])new QFilter("account.number", "in", this.accountNumbers).and(new QFilter("changetype.number", "in", this.changeTypeNumbers)).and(QFilter.of((String)"model.number = ?", (Object[])new Object[]{this._ctx.getCubeNumber()})).and(new QFilter("investeecompany.number", "in", this.investeecompanyNumbers)).toArray());
        }
        ArrayListMultimap resultGroupData = (ArrayListMultimap)this._ctx.getProperty(GROUP_DATA);
        StringBuilder key = new StringBuilder();
        if (query != null) {
            query.forEach(v -> {
                Date changedate = v.getDate("changedate");
                key.append(v.getString("investeecompany.number"));
                key.append('#');
                key.append(v.getString("account.number"));
                key.append('#');
                key.append(v.getString("changetype.number"));
                key.append('#');
                List list = resultGroupData.get((Object)key.toString());
                key.setLength(0);
                if (list == null || list.isEmpty()) {
                    return;
                }
                block0: for (InvFormula formula : list) {
                    if (formula.getStartDate() != null && formula.getStartDate().compareTo(changedate) > 0 || formula.getEndDate() != null && formula.getEndDate().compareTo(changedate) < 0) continue;
                    if (formula.getCurrency().equals(v.getString("invcompanycurrency.number"))) {
                        formula.add(InvestFormulaParseHelper.delTailZero(v.getBigDecimal("changeamount")));
                        continue;
                    }
                    for (int i = 1; i <= 5; ++i) {
                        if (v.getString("cvt" + i + "currenyid.number") == null || !formula.getCurrency().equals(v.getString("cvt" + i + "currenyid.number"))) continue;
                        formula.add(InvestFormulaParseHelper.delTailZero(v.getBigDecimal("change" + i + "amount")));
                        continue block0;
                    }
                }
            });
            formulas.forEach(v -> v.fillBack());
        }
    }

    @Override
    protected void initFormula() {
        if (this._ctx.getCubeNumber() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u4e2d\u672a\u8bbe\u7f6e\u4f53\u7cfb\u3002", (String)"InvCalculate_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Date[] periodDate = this.trans2DateByYP(this._ctx.getYear(), this._ctx.getPeriod());
        this.groupData(periodDate, this.accountNumbers, this.changeTypeNumbers, this.investeecompanyNumbers);
    }

    private void groupData(Date[] periodDate, Set<String> accountNumbers, Set<String> changeTypeNumbers, Set<String> investeecompanyNumbers) {
        ArrayListMultimap resultGroupData = ArrayListMultimap.create();
        this.originalFormulas.forEach(v -> {
            ParamList paramList = v.getParamList();
            if (paramList.size() != 7) {
                v.setException(new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u201c%1$s\u201d\u9700\u8981%2$d\u4e2a\u53c2\u6570\uff0c\u53ea\u63d0\u4f9b\u4e86%3$d\u4e2a\u3002", (String)"InvCalculate_4", (String)"fi-bcm-business", (Object[])new Object[0]), v.toString(), 7, v.getParamList().size())));
                return;
            }
            String investeeCom = v.getInvesteeCompany();
            if (StringUtils.isEmpty((String)investeeCom)) {
                v.setException(new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u88ab\u6295\u8d44\u516c\u53f8\u7684\u4fe1\u606f\u3002", (String)"InvCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0])));
                return;
            }
            if (StringUtils.isEmpty((String)v.getCurrency())) {
                if (StringUtils.isEmpty((String)this._ctx.getCurrency())) {
                    v.setException(new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5e01\u79cd", (String)"InvCalculate_3", (String)"fi-bcm-business", (Object[])new Object[0])));
                    return;
                }
                v.setCurrency(this._ctx.getCurrency());
            }
            investeecompanyNumbers.add(investeeCom);
            accountNumbers.add(((ParamItem)paramList.get(1)).toString());
            changeTypeNumbers.add(((ParamItem)paramList.get(2)).toString());
            resultGroupData.put((Object)v.getKey(), v);
            if ("1".equals(((ParamItem)paramList.get(4)).toString())) {
                v.setStartDate(periodDate[0]);
                v.setEndDate(periodDate[1]);
            } else if ("2".equals(((ParamItem)paramList.get(4)).toString())) {
                v.setStartDate(periodDate[2]);
                v.setEndDate(periodDate[1]);
            } else if ("3".equals(((ParamItem)paramList.get(4)).toString())) {
                v.setStartDate(null);
                v.setEndDate(periodDate[1]);
            } else {
                try {
                    v.setStartDate(((ParamItem)paramList.get(5)).toDate());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    v.setEndDate(((ParamItem)paramList.get(6)).toDate());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._ctx.setProperty(GROUP_DATA, resultGroupData);
    }

    private Date[] trans2DateByYP(String yearNumber, String periodNumber) {
        String yearStr = yearNumber.substring(2);
        QFBuilder qf = new QFBuilder();
        qf.add("number", "=", (Object)periodNumber);
        qf.add("model.number", "=", (Object)this._ctx.getCubeNumber());
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"id", (QFilter[])qf.toArray());
        Triple triple = PeriodUtils.getPeiodStartEndAndYearStartDate((String)yearStr, (long)periodDyn.getLong("id"));
        return new Date[]{(Date)triple.getMiddle(), (Date)triple.getRight(), (Date)triple.getLeft()};
    }
}

