/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.inv;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.formula.model.inv.Inv_SpecExprFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.CtrlHoldingCompanyScheme;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.fel.enums.Inv_SpecExprEnum;
import kd.fi.bcm.spread.common.util.StringUtil;

public class InvSpecExprCalculate
extends AbstractCalculate<Inv_SpecExprFormula> {
    public static final String HOLDERORG = "$HOLDERORG";
    public static final String INVESTORG = "$INVESTORG";
    public static final String INVESTORGEC = "$INVESTORGEC";
    public static final String INVESTORGPC = "$INVESTORGPC";
    public static final String HOLDERORGEC = "$HOLDERORGEC";
    public static final String HOLDERORGPC = "$HOLDERORGPC";
    public static final String COMMONORGEC = "$COMMONORGEC";
    private InvestFormulaContext invCtx;
    private CtrlHoldingCompanyScheme ctrlPoolScheme;

    @Override
    public void initEvn(ICalContext ctx, List<Inv_SpecExprFormula> formulas) {
        super.initEvn(ctx, formulas);
        this.invCtx = new InvestFormulaContext(this._ctx.getModelId(), this._ctx.getScenarioId(), this._ctx.getYearId(), this._ctx.getPeriodId());
        this.invCtx.setMergeOrgId((Long)this._ctx.getProperty("orgId"));
        this.invCtx.setCslschemeId((Long)this._ctx.getProperty("cslscheme"));
    }

    @Override
    protected void execCalculate(List<Inv_SpecExprFormula> formulas) {
        for (Inv_SpecExprFormula f : formulas) {
            if (f.hasException()) continue;
            ParamList paramList = f.getParamList();
            if (paramList.isEmpty()) {
                f.setException((Exception)((Object)new KDBizException("paramList can not be empty")));
                return;
            }
            Inv_SpecExprEnum specExprEnum = Inv_SpecExprEnum.searchEnumByType((String)((ParamItem)paramList.get(0)).toString());
            if (specExprEnum == null) {
                return;
            }
            switch (specExprEnum) {
                case SPEC_V_ORG_PROCESS_PARM: {
                    this.handleVOrgProcessSpecParam(f);
                    break;
                }
                case SPEC_CURRENCY_PARM: {
                    this.handleVCurrencySpecParam(f);
                    break;
                }
                case SPEC_ORG_PARM: {
                    this.handleOrgSpecParam(f);
                    break;
                }
                case SPEC_JL_DIM_PARM: {
                    this.handleJLSpecParam(f);
                    break;
                }
            }
        }
    }

    private void handleJLSpecParam(Inv_SpecExprFormula f) {
        String shareHolder = ((ParamItem)f.getParamList().get(1)).toString();
        String investOrg = ((ParamItem)f.getParamList().get(2)).toString();
        String dimensionParam = InvestFormulaParseHelper.handelParam(f.getParamList().get(3));
        LinkedHashMap<String, Object> dim2ValMap = new LinkedHashMap<String, Object>(16);
        LinkedHashMap<String, String[]> dim2ScopeMap = new LinkedHashMap<String, String[]>(16);
        block6: for (String p : dimensionParam.split(",")) {
            String[] dimAndMemb = GetJLEntryFormula.splitDimAndMemb(p);
            switch (dimAndMemb.length) {
                case 2: {
                    dim2ValMap.put(InvestFormulaParseHelper.handelParam(dimAndMemb[0]), InvestFormulaParseHelper.handelParam(dimAndMemb[1]));
                    continue block6;
                }
                case 4: {
                    dim2ValMap.put(InvestFormulaParseHelper.handelParam(dimAndMemb[0]), InvestFormulaParseHelper.handelParam(dimAndMemb[2]));
                    dim2ScopeMap.put(InvestFormulaParseHelper.handelParam(dimAndMemb[0]), dimAndMemb);
                    continue block6;
                }
                default: {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), p))));
                    return;
                }
            }
        }
        String scene = dim2ValMap.computeIfAbsent(DimTypesEnum.SCENARIO.getShortNumber(), a -> this._ctx.getScenario());
        String year = dim2ValMap.computeIfAbsent(DimTypesEnum.YEAR.getShortNumber(), a -> this._ctx.getYear());
        String period = dim2ValMap.computeIfAbsent(DimTypesEnum.PERIOD.getShortNumber(), a -> this._ctx.getPeriod());
        String processNum = (String)dim2ValMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String curNum = (String)dim2ValMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(this._ctx.getModelId(), this._ctx.getScenarioId(), this._ctx.getYearId(), this._ctx.getPeriodId(), year, period);
        dim2ValMap.put(DimTypesEnum.YEAR.getShortNumber(), yearAndPeriod.p1);
        dim2ValMap.put(DimTypesEnum.PERIOD.getShortNumber(), yearAndPeriod.p2);
        String orgNum = (String)dim2ValMap.get(DimTypesEnum.ENTITY.getShortNumber());
        dim2ValMap.put(DimTypesEnum.ENTITY.getShortNumber(), this.getEntityNumBySpecialSign(shareHolder, investOrg, orgNum, false));
        if (dim2ValMap.containsKey(DimTypesEnum.INTERCOMPANY.getShortNumber())) {
            String icNum = (String)dim2ValMap.get(DimTypesEnum.INTERCOMPANY.getShortNumber());
            dim2ValMap.put(DimTypesEnum.INTERCOMPANY.getShortNumber(), this.getEntityNumBySpecialSign(shareHolder, investOrg, icNum, false));
        }
        if (dim2ValMap.containsKey(DimTypesEnum.MYCOMPANY.getShortNumber())) {
            String mcNum = (String)dim2ValMap.get(DimTypesEnum.MYCOMPANY.getShortNumber());
            dim2ValMap.put(DimTypesEnum.MYCOMPANY.getShortNumber(), this.getEntityNumBySpecialSign(shareHolder, investOrg, mcNum, false));
        }
        try {
            curNum = this.getCurrencyNumBySpecialSign(shareHolder, investOrg, curNum);
            curNum = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)this._ctx.getCubeNumber(), (String)"Entity", (String)orgNum), (long)this._ctx.getModelId().longValue(), (String)processNum, (String)curNum).p2;
            dim2ValMap.put(DimTypesEnum.CURRENCY.getShortNumber(), curNum);
        }
        catch (Exception t) {
            f.setException(t);
        }
        StringJoiner sj = new StringJoiner(",");
        dim2ValMap.forEach((k, v) -> {
            CharSequence[] dimScope = (String[])dim2ScopeMap.get(k);
            String string = v = v.contains(".") ? "[" + v + "]" : v;
            if (dimScope == null || dimScope.length < 4) {
                sj.add(k + "." + v);
            } else {
                dimScope[2] = v;
                sj.add(String.join((CharSequence)".", dimScope));
            }
        });
        f.setValue(sj.toString());
    }

    private void handleOrgSpecParam(Inv_SpecExprFormula f) {
        String shareHolder = ((ParamItem)f.getParamList().get(1)).toString();
        String investOrg = ((ParamItem)f.getParamList().get(2)).toString();
        String orgNum = ((ParamItem)f.getParamList().get(3)).toString();
        orgNum = orgNum.substring(orgNum.indexOf(".") + 1);
        f.setValue(this.getEntityNumBySpecialSign(shareHolder, investOrg, orgNum, false));
    }

    private void handleVCurrencySpecParam(Inv_SpecExprFormula f) {
        String shareHolder = ((ParamItem)f.getParamList().get(1)).toString();
        String investOrg = ((ParamItem)f.getParamList().get(2)).toString();
        String curNum = ((ParamItem)f.getParamList().get(3)).toString().replace("C.", "").replace("BP.", "");
        try {
            f.setValue(this.getCurrencyNumBySpecialSign(shareHolder, investOrg, curNum));
        }
        catch (Exception t) {
            f.setException(t);
        }
    }

    private void handleVOrgProcessSpecParam(Inv_SpecExprFormula f) {
        String shareHolder = ((ParamItem)f.getParamList().get(1)).toString();
        String investOrg = ((ParamItem)f.getParamList().get(2)).toString();
        String process = ((ParamItem)f.getParamList().get(3)).toString().replace("BP.", "");
        String fgConfig = ((ParamItem)f.getParamList().get(4)).toString();
        String orgNum = ((ParamItem)f.getParamList().get(5)).toString().replace("E.", "");
        if (orgNum.contains("_")) {
            f.setValue(orgNum);
            return;
        }
        if (StringUtils.isEmpty((String)(orgNum = this.getEntityNumBySpecialSign(shareHolder, investOrg, orgNum, true)))) {
            f.setException((Exception)((Object)new KDBizException("handleVOrgSpecParam : not found orgNum")));
        }
    }

    private String getCurrencyNumBySpecialSign(String shareHolder, String investOrg, String curNum) {
        if (StringUtils.isEmpty((String)curNum)) {
            return "";
        }
        switch (curNum) {
            case "$INVESTORGEC": 
            case "INVESTORGEC": {
                curNum = BcmThreadCache.findMemberByNum((String)this.invCtx.getModelNum(), (String)"Entity", (String)investOrg).getCurrency();
                break;
            }
            case "$INVESTORGPC": 
            case "INVESTORGPC": {
                IDNumberTreeNode investNode = InvestServiceHelper.queryEffectiveOrgNode(this.invCtx.getModelId(), this.invCtx.getScenarioId(), this.invCtx.getFyId(), this.invCtx.getPeriodId(), this.invCtx.getMergeOrgId(), investOrg);
                if (investNode == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u4e0b\u627e\u4e0d\u5230\u53ef\u7528\u7684\u88ab\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvSpecExprCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                curNum = investNode.getParent().getCurrency();
                break;
            }
            case "$HOLDERORGEC": 
            case "HOLDERORGEC": 
            case "HOLDEREC": {
                curNum = BcmThreadCache.findMemberByNum((String)this.invCtx.getModelNum(), (String)"Entity", (String)shareHolder).getCurrency();
                break;
            }
            case "$HOLDERORGPC": 
            case "HOLDERORGPC": {
                IDNumberTreeNode holderNode = InvestServiceHelper.queryEffectiveOrgNode(this.invCtx.getModelId(), this.invCtx.getScenarioId(), this.invCtx.getFyId(), this.invCtx.getPeriodId(), this.invCtx.getMergeOrgId(), shareHolder);
                if (holderNode == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u4e0b\u627e\u4e0d\u5230\u53ef\u7528\u7684\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvSpecExprCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                curNum = holderNode.getParent().getCurrency();
                break;
            }
            case "$COMMONORGEC": 
            case "COMMONORGEC": {
                curNum = this.invCtx.queryMergeOrg().getCurrency();
                break;
            }
        }
        return curNum;
    }

    private String getEntityNumBySpecialSign(String shareHolder, String investOrg, String orgNum, boolean isChangeCtrlOrg) {
        if (HOLDERORG.equalsIgnoreCase(orgNum) || "HOLDER".equalsIgnoreCase(orgNum)) {
            orgNum = shareHolder;
        } else if (INVESTORG.equalsIgnoreCase(orgNum) || "INVESTORG".equalsIgnoreCase(orgNum) || StringUtil.equals((String)orgNum, (String)investOrg)) {
            String ctrlOrg = isChangeCtrlOrg ? this.getCtrlPoolScheme().searchCtrlHoldingCompany(investOrg) : null;
            orgNum = StringUtils.isEmpty((String)ctrlOrg) ? investOrg : ctrlOrg;
        }
        return orgNum;
    }

    public CtrlHoldingCompanyScheme getCtrlPoolScheme() {
        if (this.ctrlPoolScheme == null) {
            this.ctrlPoolScheme = new CtrlHoldingCompanyScheme(this.invCtx.getModelId(), this.invCtx.getCslschemeId(), this.invCtx.getScenarioId(), this.invCtx.getFyId(), this.invCtx.getPeriodId());
        }
        return this.ctrlPoolScheme;
    }

    @Override
    protected void initFormula() {
    }
}

