/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate.refrence;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.excelformula.IReference;
import kd.fi.bcm.common.util.ToStringHelper;

public class CalcQueue {
    private boolean hasCalc = false;
    private ExpressStatus es;
    private Object value = null;
    private int currentCalcLevel = -1;
    private ICalContext ctx;
    private TreeMap<Integer, List<IFormula>> levelSort = new TreeMap((f1, f2) -> f2 - f1);

    public int getCurrentCalcLevel() {
        return this.currentCalcLevel;
    }

    public CalcQueue(ExpressStatus es, List<IFormula> formulas, ICalContext ctx) {
        this.es = es;
        this.ctx = ctx;
        formulas.forEach(f -> {
            List fn = this.levelSort.computeIfAbsent(f.getCalcLevel(), v -> new ArrayList(1));
            fn.add(f);
        });
        this.currentCalcLevel = this.levelSort.isEmpty() ? -1 : this.levelSort.firstKey();
    }

    public List<IFormula> getNextCalcFormulas() {
        if (this.currentCalcLevel == -1) {
            return null;
        }
        List<IFormula> formulas = null;
        while (this.currentCalcLevel != -1 && (formulas = this.levelSort.get(this.currentCalcLevel)) == null) {
            --this.currentCalcLevel;
        }
        if (formulas != null) {
            for (IFormula f : formulas) {
                if (!IReference.class.isAssignableFrom(f.getClass()) || ((IReference)IReference.class.cast(f)).hasCalcAllRefCell(this.ctx)) continue;
                return null;
            }
            --this.currentCalcLevel;
        }
        return formulas;
    }

    public boolean isHasCalc() {
        return this.hasCalc;
    }

    public void setHasCalc(boolean hasCalc) {
        this.hasCalc = hasCalc;
        if (this.es != null) {
            this.value = this.es.hasException() ? this.es.getException() : this.ctx.getCalculateService().getCalculateEngine().calculate(this.es.getParseExpr());
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setCycleRefrenceCalcException(Exception e) {
        List<IFormula> formulas = null;
        while (this.currentCalcLevel != -1 && (formulas = this.levelSort.get(this.currentCalcLevel)) != null) {
            formulas.forEach(f -> f.setException(e));
            --this.currentCalcLevel;
        }
        this.value = e;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this.es) + ToStringHelper.reflectionToString((Object)this.value);
    }
}

