/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.dispatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;

public class DispatchParams {
    protected String formulaName;
    private Map<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
    private Map<String, Object> commParam;
    private Map<String, Set<String>> refParam;
    private Map<String, Set<String>> floatParam;
    private HashMultimap<String, String> commonAssistDim;
    private List<String> formulaParamNames = new ArrayList<String>(10);

    public DispatchParams(String formulaName) {
        String caseformulaName;
        Map formulaConfig = ExternalFormulaLoader.getInstance().getFormulaConfig(formulaName);
        this.formulaName = caseformulaName = formulaConfig.get("number").toString();
        for (Map param : (List)formulaConfig.get("param")) {
            this.formulaParamNames.add(param.get("number").toString());
        }
    }

    public DispatchParams() {
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public void setFormulaParamNames(List<String> formulaParamNames) {
        this.formulaParamNames = formulaParamNames;
    }

    public void addFormulaParam(String formulaUuid, List<Object> params) {
        this.paramMap.put(formulaUuid, params);
    }

    public void addCommonParam(Map<String, Object> commParam) {
        this.commParam = commParam;
    }

    public void addRefParam(Map<String, Set<String>> refParam) {
        this.refParam = refParam;
    }

    public void addCommonAssistDim(HashMultimap<String, String> commonAssistDim) {
        this.commonAssistDim = commonAssistDim;
    }

    public Map<String, Set<String>> getFloatParam() {
        return this.floatParam;
    }

    public void setFloatParam(Map<String, Set<String>> floatParam) {
        this.floatParam = floatParam;
    }

    public String toJson() {
        JSONObject objJson = new JSONObject();
        objJson.put("formulaName", (Object)this.formulaName);
        objJson.put("param", this.paramMap);
        if (this.commParam != null) {
            this.commParam.put("formulaParamNames", this.formulaParamNames);
            objJson.put("commParam", this.commParam);
        }
        objJson.put("ref_param", this.refParam);
        objJson.put("float_param", this.floatParam);
        objJson.put("commonAssistDim", this.commonAssistDim);
        return objJson.toJSONString();
    }

    public String getFormulaName() {
        return this.formulaName;
    }
}

