/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.enums;

import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum DataSourceTypeEnum {
    MERGE_MODEL(new MultiLangEnumBridge("\u5408\u5e76\u4f53\u7cfb", "DataSourceTypeEnum_0", "fi-bcm-business"), "1", "bcm_model", "bcmmodel"),
    RPT_MODEL(new MultiLangEnumBridge("\u8d22\u52a1\u4f53\u7cfb", "DataSourceTypeEnum_1", "fi-bcm-business"), "2", "bcm_model", "rptmodel"),
    EB_MODEL(new MultiLangEnumBridge("\u9884\u7b97\u4f53\u7cfb", "DataSourceTypeEnum_2", "fi-bcm-business"), "3", "epm_model", "ebmodel"),
    ISC_METADATA(new MultiLangEnumBridge("\u96c6\u6210\u5bf9\u8c61", "DataSourceTypeEnum_3", "fi-bcm-business"), "4", "isc_metadata_schema", "iscmetadata"),
    EPM_DATAMANAGE(new MultiLangEnumBridge("EPM\u6570\u636e\u7ba1\u7406", "DataSourceTypeEnum_4", "fi-bcm-business"), "5", "epdm_dm", "epmmodel");

    private final String type;
    private final MultiLangEnumBridge bridge;
    private final String formId;
    private final String mark;

    private DataSourceTypeEnum(MultiLangEnumBridge bridge, String type, String formId, String mark) {
        this.type = type;
        this.bridge = bridge;
        this.formId = formId;
        this.mark = mark;
    }

    public String getType() {
        return this.type;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getName() {
        return this.getBridge().loadKDString();
    }

    public String getMark() {
        return this.mark;
    }

    public static DataSourceTypeEnum getByType(String type) {
        for (DataSourceTypeEnum value : DataSourceTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }
}

