/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.express;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.factory.FormulaCalculateFactory;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.excelformula.AreaRefFormula;
import kd.fi.bcm.business.formula.model.excelformula.ReferenceFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.Functional;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import kd.fi.bcm.spread.formula.util.AreaReference;

public class ExpressParser {
    public Pair<String, List<IFormula>> parse(String express, EncoderService encoder) throws Exception {
        if (express == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpressParser_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Expression exprs = ExcelFormulaPaserHelper.parse((String)express);
        StringBuffer buffer = new StringBuffer();
        exprs.outputEncodeExpr(buffer, x -> encoder.getCode());
        ArrayList<Functional> lst = new ArrayList<Functional>();
        this.collectFunctionExpr(lst, exprs);
        List formulas = Lists.transform(lst, f -> this.transFormulaExpr2Formula((Functional)f, true, encoder));
        ArrayList extendFormulas = new ArrayList();
        formulas.forEach(f -> this.extendFunctionExprOnParams((IFormula)f, encoder, 0, extendFormulas));
        extendFormulas.addAll(formulas);
        return Pair.onePair((Object)buffer.toString(), extendFormulas);
    }

    public List<Expression> parse2(String express, EncoderService encoder) throws Exception {
        if (express == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpressParser_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Expression exprs = ExcelFormulaPaserHelper.parse((String)express);
        StringBuffer buffer = new StringBuffer();
        exprs.outputEncodeExpr(buffer, x -> encoder.getCode());
        ArrayList<Expression> lst = new ArrayList<Expression>();
        this.collectExpr(lst, exprs);
        return lst;
    }

    private void collectExpr(List<Expression> lst, Expression exprs) {
        if (exprs instanceof BinaryOperationExpr) {
            this.collectExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            this.collectExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            this.collectExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        } else {
            lst.add(exprs);
        }
    }

    public List<Expression> parseAll(String express, EncoderService encoder) throws Exception {
        if (express == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpressParser_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Expression exprs = ExcelFormulaPaserHelper.parse((String)express);
        StringBuffer buffer = new StringBuffer();
        exprs.outputEncodeExpr(buffer, x -> encoder.getCode());
        ArrayList<Expression> lst = new ArrayList<Expression>();
        this.recursiveCollectExpr(lst, exprs);
        return lst;
    }

    private void recursiveCollectExpr(List<Expression> lst, Expression exprs) {
        if (exprs instanceof FunctionExpr) {
            List parameters = ((FunctionExpr)exprs).getParameters();
            ((FunctionExpr)exprs).getParameters().stream().map(parameter -> (Expression)parameter).forEach(e -> this.recursiveCollectExpr(lst, (Expression)e));
        } else if (exprs instanceof BinaryOperationExpr) {
            this.recursiveCollectExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            this.recursiveCollectExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            this.recursiveCollectExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        } else {
            lst.add(exprs);
        }
    }

    private IFormula transFormulaExpr2Formula(Functional f, boolean isSyncroUuid, EncoderService encoder) {
        if (f instanceof FunctionExpr) {
            return this.constructFormulaModel((FunctionExpr)FunctionExpr.class.cast(f), isSyncroUuid);
        }
        if (f instanceof ReferenceExpr) {
            return this.constructReferenceModel((ReferenceExpr)ReferenceExpr.class.cast(f), isSyncroUuid, encoder);
        }
        if (f instanceof AreaExpr) {
            return this.constructAreaReferenceModel((AreaExpr)AreaExpr.class.cast(f), isSyncroUuid, encoder);
        }
        throw new KDBizException(String.format("no formula model adapt to express %s ", f.toString()));
    }

    private IFormula constructFormulaModel(FunctionExpr f, boolean isSyncroUuid) {
        Object formula = FormulaCalculateFactory.getFormulaModel(f.getFuncionName());
        ParamList paramlist = new ParamList();
        paramlist.addAll(Lists.transform((List)f.getParameters(), p -> new ParamItem(p)));
        formula.initParam(paramlist);
        if (isSyncroUuid) {
            formula.setUUID(f.getUUID());
        }
        formula.setCalcLevel(0);
        return formula;
    }

    private IFormula constructReferenceModel(ReferenceExpr ref, boolean isSyncroUuid, EncoderService encoder) {
        Object formula = FormulaCalculateFactory.getFormulaModel("CELLREF");
        ((ReferenceFormula)ReferenceFormula.class.cast(formula)).setRefName(ref.toString());
        ParamList paramlist = new ParamList();
        paramlist.add(new ParamItem(ref.toString()));
        formula.initParam(paramlist);
        if (isSyncroUuid) {
            formula.setUUID(ref.getUUID());
        }
        formula.setCalcLevel(0);
        return formula;
    }

    private IFormula constructAreaReferenceModel(AreaExpr ref, boolean isSyncroUuid, EncoderService encoder) {
        Object formula = FormulaCalculateFactory.getFormulaModel("AreaRef");
        AreaRefFormula sumRef = (AreaRefFormula)AreaRefFormula.class.cast(formula);
        sumRef.setAreaRef(new AreaReference(ref.getStart_row(), ref.getStart_col(), ref.getEnd_row(), ref.getEnd_col()));
        ParamList paramlist = new ParamList();
        paramlist.add(new ParamItem(sumRef.getAreaRef()));
        formula.initParam(paramlist);
        if (isSyncroUuid) {
            formula.setUUID(ref.getUUID());
        }
        formula.setCalcLevel(0);
        return formula;
    }

    private void extendFunctionExprOnParams(IFormula f, EncoderService encoder, int parentLevel, List<IFormula> extendFormulas) {
        f.getParamList().forEach(p -> {
            if (p.getParam() instanceof Expression) {
                this.collectFunctionExpr((Expression)p.getParam(), encoder, parentLevel, extendFormulas);
            }
        });
    }

    private void collectFunctionExpr(Expression exprs, EncoderService encoder, int parentLevel, List<IFormula> extendFormulas) {
        if (exprs instanceof FunctionExpr || exprs instanceof ReferenceExpr || exprs instanceof AreaExpr) {
            IFormula formula = this.transFormulaExpr2Formula((Functional)exprs, false, encoder);
            String uuid = encoder.getCode();
            exprs.setUUID(uuid);
            formula.setUUID(uuid);
            int level = parentLevel + 1;
            formula.setCalcLevel(level);
            extendFormulas.add(formula);
            if (exprs instanceof FunctionExpr) {
                this.extendFunctionExprOnParams(formula, encoder, level, extendFormulas);
            }
        } else if (exprs instanceof BinaryOperationExpr) {
            this.collectFunctionExpr(((BinaryOperationExpr)exprs).getLeft(), encoder, parentLevel, extendFormulas);
            this.collectFunctionExpr(((BinaryOperationExpr)exprs).getRight(), encoder, parentLevel, extendFormulas);
        } else if (exprs instanceof UnaryOperationExpr) {
            this.collectFunctionExpr(((UnaryOperationExpr)exprs).getOperand(), encoder, parentLevel, extendFormulas);
        }
    }

    private void collectFunctionExpr(List<Functional> lst, Expression exprs) {
        if (exprs instanceof Functional) {
            lst.add((Functional)exprs);
        } else if (exprs instanceof BinaryOperationExpr) {
            this.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            this.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            this.collectFunctionExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        }
    }
}

