/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.express;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.IntExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaAnalyze {
    public static List<FunctionExpr> analyticFun(String express) {
        ArrayList<FunctionExpr> lstFormula = new ArrayList<FunctionExpr>(10);
        try {
            Expression exprs = ExcelFormulaPaserHelper.parse((String)express);
            StringBuffer buffer = new StringBuffer();
            exprs.outputEncodeExpr(buffer, x -> {
                EncoderService encoder = new EncoderService();
                return x instanceof FunctionExpr ? encoder.getCode() : x.toString();
            });
            FormulaAnalyze.collectFunctionExpr(lstFormula, exprs);
        }
        catch (Exception e) {
            return lstFormula;
        }
        return lstFormula;
    }

    private static void collectFunctionExpr(List<FunctionExpr> lst, Expression exprs) {
        if (exprs instanceof FunctionExpr) {
            lst.add((FunctionExpr)exprs);
        } else if (exprs instanceof BinaryOperationExpr) {
            FormulaAnalyze.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getLeft());
            FormulaAnalyze.collectFunctionExpr(lst, ((BinaryOperationExpr)exprs).getRight());
        } else if (exprs instanceof UnaryOperationExpr) {
            FormulaAnalyze.collectFunctionExpr(lst, ((UnaryOperationExpr)exprs).getOperand());
        }
    }

    public static Map<String, Object> generalledgerQueryParams(List<Map<String, Object>> formulProp, List<Object> lstNumber) {
        HashMap<String, Object> formul = new HashMap<String, Object>(16);
        for (int i = 0; i < formulProp.size(); ++i) {
            Map<String, Object> item = formulProp.get(i);
            String number = lstNumber.get(i).toString().replaceAll("\"", "");
            if (item.get("number").equals("account")) {
                Object[] numbers = FormulaAnalyze.getAccountOrAsstactTypeNumbers(number);
                if (numbers.length > 1) {
                    numbers[0] = FormulaAnalyze.queryAccountIdByNumber(item.get("value").toString(), numbers[0], Long.parseLong(formul.get("org").toString()), Long.parseLong(formul.get("accountbookstype").toString()));
                    formul.put(item.get("number").toString(), StringUtils.join((Object[])numbers, (String)"|"));
                    continue;
                }
                formul.put(item.get("number").toString(), FormulaAnalyze.queryAccountIdByNumber(item.get("value").toString(), number, Long.parseLong(formul.get("org").toString()), Long.parseLong(formul.get("accountbookstype").toString())));
                continue;
            }
            if (item.get("number").equals("fetchtype") || item.get("number").equals("fy") || item.get("number").equals("period") || item.get("number").equals("currency") && "".equals(number) || item.get("number").equals("cashflow") || item.get("number").equals("reclassparam") || item.get("number").equals("contraaccount")) {
                formul.put(item.get("number").toString(), number);
                continue;
            }
            if ("commonassist".equals(item.get("number"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8054\u67e5\u529f\u80fd\u4e0d\u652f\u6301\u91d1\u8776\u4e91\u00b7\u661f\u701a\u603b\u8d26\u516c\u5171\u7ef4\u5ea6\u8054\u67e5\uff0c\u5982\u9700\u8981\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u542f\u65b0\u8054\u67e5\u529f\u80fd\u540e\u4f7f\u7528\u3002", (String)"FormulaAnalyze_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            formul.put(item.get("number").toString(), FormulaAnalyze.queryEntityIdByNumber(item.get("value").toString(), number));
        }
        return formul;
    }

    public static String[] getAccountOrAsstactTypeNumbers(String number) {
        Pattern pattern = Pattern.compile("(\\|)");
        return pattern.split(number);
    }

    public static String queryEntityIdByNumber(String entityNumber, String number) {
        QFilter filter2 = new QFilter("number", "=", (Object)number);
        DynamicObject object = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{filter2});
        if (object != null) {
            return object.getString("id");
        }
        String msg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801%s\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u7f16\u7801\u3002", (String)"FormulaAnalyze_2", (String)"fi-bcm-business", (Object[])new Object[0]), number);
        throw new KDBizException(msg);
    }

    public static String queryAccountIdByNumber(String entityNumber, String number, long orgId, long accountbookstype) {
        QFilter qfNumber;
        DynamicObject bookInfo = FormulaAnalyze.getBookObject(orgId, accountbookstype);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868\u672a\u627e\u5230\u3002", (String)"FormulaAnalyze_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        long acctTableId = bookInfo.getLong("accounttable.id");
        QFilter qfAcctTable = new QFilter("accounttable", "=", (Object)acctTableId);
        if (number.contains("[")) {
            String tempStr = number.trim().substring(1, number.length() - 1);
            if (tempStr.split(",").length == 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u586b\u5199\u9519\u8bef\u3002\u516c\u5f0f\u4e2d\u7684\u79d1\u76ee\u4e3a\u8fde\u7eed\u7c7b\u578b\u65f6\uff0c\u8bf7\u4f7f\u7528\u683c\u5f0f\u201ca,b\u201d\u3002", (String)"FormulaAnalyze_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            boolean flag = true;
            if (tempStr.split(",")[0].compareToIgnoreCase(tempStr.split(",")[1]) > 0) {
                flag = false;
            }
            qfNumber = new QFilter("number", ">=", (Object)(flag ? tempStr.split(",")[0] : tempStr.split(",")[1]));
            qfNumber.and("number", "<=", (Object)(flag ? tempStr.split(",")[1] : tempStr.split(",")[0]));
        } else {
            qfNumber = number.contains(",") ? new QFilter("number", "in", (Object)number.trim().split(",")) : new QFilter("number", "=", (Object)number);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{qfAcctTable, qfNumber});
        if (dynamicObjects.size() != 0) {
            HashSet resultSet = new HashSet(dynamicObjects.size());
            dynamicObjects.forEach(dyo -> resultSet.add(dyo.getLong("id")));
            return resultSet.toString();
        }
        return "0";
    }

    public static DynamicObject getBookObject(long org, long bookType) {
        QFilter orgF = new QFilter("org", "=", (Object)org);
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
        if (book == null) {
            return null;
        }
        DynamicObject bookObj = BusinessDataServiceHelper.loadSingleFromCache((Object)book.getLong("id"), (String)"gl_accountbook", (String)"org,bookstype,basecurrency,periodtype,startperiod,curperiod,exratetable,accounttable,cashinitperiod,isendinit,accountingsys");
        return bookObj;
    }

    public static DynamicObject getCorrentPeriod(Map<String, Object> params) {
        QFilter periodf1 = new QFilter("periodtype", "=", (Object)Long.valueOf(String.valueOf(params.get("periodtype"))));
        QFilter periodf2 = new QFilter("periodyear", "=", (Object)Long.valueOf(String.valueOf(params.get("fy"))));
        QFilter periodf3 = new QFilter("periodnumber", "=", (Object)Long.valueOf(String.valueOf(params.get("period"))));
        QFilter[] filter = new QFilter[]{periodf1, periodf2, periodf3};
        return QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodyear,periodnumber,begindate,enddate", (QFilter[])filter);
    }

    public static StringExpr setOrgDefaultValue(Long entityPK) {
        return (StringExpr)ThreadCache.get((Object)"FormulaAnalyze.sodv", () -> {
            DynamicObject dyEntity = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entityPK)});
            if (dyEntity != null) {
                return new StringExpr(dyEntity.getString("number"));
            }
            return null;
        });
    }

    public static StringExpr setBookTypeDefaultValue() {
        return (StringExpr)ThreadCache.get((Object)"FormulaAnalyze.sbtdv", () -> {
            DynamicObject dyBookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)"1")});
            if (dyBookType != null) {
                return new StringExpr(dyBookType.getString("number"));
            }
            return null;
        });
    }

    public static IntExpr setFYOrPeriodDefaultValue(DynamicObject dyn) {
        Pattern pattern = Pattern.compile("[^0-9]");
        String fymember = dyn.getString("number");
        fymember = pattern.matcher(fymember).replaceAll("");
        IntExpr expr = new IntExpr();
        expr.setValue(BigInteger.valueOf(Long.parseLong(fymember)));
        return expr;
    }

    public static IntExpr setFYOrPeriodDefaultValue(String value) {
        Pattern pattern = Pattern.compile("[^0-9]");
        value = pattern.matcher(value).replaceAll("");
        IntExpr expr = new IntExpr(BigInteger.valueOf(Long.parseLong(value)));
        return expr;
    }

    public static StringExpr setCurrencyOrPeriodDefaultValue(DynamicObject dyn) {
        Pattern pattern = Pattern.compile("[^A-Z]");
        String fymember = dyn.getString("number");
        return new StringExpr(pattern.matcher(fymember).replaceAll(""));
    }

    public static String fillAcctTypeParam(String express, String orgNum, String yearNum, String periodNum) {
        try {
            Expression exprs = ExcelFormulaPaserHelper.parse((String)express);
            FormulaAnalyze.fillFunctionExpr(exprs, orgNum, yearNum, periodNum);
            StringBuffer sb = new StringBuffer();
            exprs.output(sb);
            return sb.toString();
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u586b\u5145ACCT\u7c7b\u578b\u516c\u5f0f\u53c2\u6570\u9519\u8bef\uff0c\u5f53\u524d\u516c\u5f0f\uff1a%s\u3002", (String)"GLFormulaDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), express));
        }
    }

    private static void fillFunctionExpr(Expression exprs, String orgNum, String yearNum, String periodNum) {
        if (exprs instanceof FunctionExpr) {
            FormulaAnalyze.fillAcctTypeParam((FunctionExpr)exprs, orgNum, yearNum, periodNum);
        } else if (exprs instanceof BinaryOperationExpr) {
            FormulaAnalyze.fillFunctionExpr(((BinaryOperationExpr)exprs).getLeft(), orgNum, yearNum, periodNum);
            FormulaAnalyze.fillFunctionExpr(((BinaryOperationExpr)exprs).getRight(), orgNum, yearNum, periodNum);
        } else if (exprs instanceof UnaryOperationExpr) {
            FormulaAnalyze.fillFunctionExpr(((UnaryOperationExpr)exprs).getOperand(), orgNum, yearNum, periodNum);
        }
    }

    public static String fillAcctTypeParam(FunctionExpr formula, String orgNum, String yearNum, String periodNum) {
        String functionName = formula.getFuncionName();
        if (functionName.equalsIgnoreCase("acct") || functionName.equalsIgnoreCase("acctcf") || functionName.equalsIgnoreCase("acctage") || functionName.equalsIgnoreCase("ictacct") || functionName.equalsIgnoreCase("ictcf")) {
            boolean isErr;
            boolean bl = isErr = formula.getParameters().size() < 6;
            if (isErr) {
                return ResManager.loadKDString((String)"\u65e0\u6548\u7684\u53d6\u6570\u516c\u5f0f\u3002", (String)"FormulaAnalyze_3", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
            if (orgNum != null && formula.getParameters().get(0).toString().replaceAll("\"", "").length() == 0) {
                formula.getParameters().set(0, new StringExpr(orgNum));
            }
            if (formula.getParameters().get(1).toString().replaceAll("\"", "").length() == 0) {
                formula.getParameters().set(1, FormulaAnalyze.setBookTypeDefaultValue());
            }
            if (!functionName.equalsIgnoreCase("acctage")) {
                int periodIndex;
                int fyIndex;
                if (functionName.equalsIgnoreCase("acct") || functionName.equalsIgnoreCase("acctcf")) {
                    fyIndex = 4;
                    periodIndex = 5;
                } else {
                    fyIndex = 6;
                    periodIndex = 7;
                }
                String originalYear = formula.getParameters().get(fyIndex).toString().replaceAll("\"", "");
                if (yearNum != null && ("0".equals(originalYear) || originalYear.length() == 0)) {
                    formula.getParameters().set(fyIndex, FormulaAnalyze.setFYOrPeriodDefaultValue(yearNum));
                }
                String originalPeriod = formula.getParameters().get(periodIndex).toString().replaceAll("\"", "");
                boolean isText = DataCollectUtils.acctFormulaPeriodIsTxt(functionName);
                if (periodNum != null && ("0".equals(originalPeriod) || originalPeriod.length() == 0)) {
                    String newPeriod;
                    int number;
                    if (!isText && !ConfigServiceHelper.getGlobalBoolParam("isStriclyDisPerCode") && periodNum.contains("T") && (number = Integer.parseInt(newPeriod = periodNum.replace("T", ""))) >= 13) {
                        periodNum = newPeriod;
                    }
                    formula.getParameters().set(periodIndex, new StringExpr(periodNum));
                }
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u6682\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"FormulaAnalyze_4", (String)"fi-bcm-business", (Object[])new Object[0]);
    }
}

