/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.factory;

import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.ICalculateHandle;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.register.FormulaRegister;

public class FormulaCalculateFactory {
    public static <T extends ICalculateHandle<?>> T getCalculateHandle(String formulaName) {
        Class<ICalculateHandle<?>> clazz = FormulaRegister.getCalculateClazz(formulaName);
        try {
            return (T)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDBizException(String.format("new instance class %s fail,cause:%s", clazz.getName(), e.getMessage()));
        }
    }

    public static <T extends IFormula> T getFormulaModel(String formulaName) {
        Class clazz = (Class)ThreadCache.get((Object)formulaName, () -> FormulaRegister.getFormulaModelClazz(formulaName));
        try {
            IFormula t = (IFormula)clazz.newInstance();
            t.setFormulaName(formulaName);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDBizException(String.format("new instance class %s fail,cause:%s", clazz.getName(), e.getMessage()));
        }
    }
}

