/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.external.IFormatParam;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public abstract class Formula
implements IFormula,
IFormatParam {
    private Object value;
    private ParamList params;
    private Exception exception;
    protected ICalContext ctx;
    private String uuid;
    private int calcLevel = 0;
    private String exceptionMsg;
    private String logMsg;
    private String tipLogMsg;
    private int floatParamIndex = -1;
    private boolean periodInFormula = false;
    private String cellReference;

    @Override
    public void initParam(ParamList params) {
        this.params = params;
    }

    @Override
    public <T> T getValue() {
        return (T)(this.hasException() ? this.exception : this.value);
    }

    @Override
    public ParamList getParamList() {
        return this.params;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception e) {
        this.exception = e;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public int getFloatParamIndex() {
        return this.floatParamIndex;
    }

    @Override
    public void setFloatParamIndex(int floatParamIndex) {
        this.floatParamIndex = floatParamIndex;
    }

    @Override
    public String getTipLogMsg() {
        return this.tipLogMsg;
    }

    @Override
    public void setTipLogMsg(String tipLogMsg) {
        this.tipLogMsg = tipLogMsg;
    }

    public String toString() {
        List list = this.params.stream().map(p -> {
            if (p.getParam() instanceof Number || p.getParam() instanceof Boolean) {
                return p.toString();
            }
            return "\"" + p + "\"";
        }).collect(Collectors.toList());
        return this.getName() + "(" + String.join((CharSequence)",", list) + ")";
    }

    public String toBizRuleFormulaString(String formulaName) {
        List list = this.params.stream().map(p -> {
            if (p.getParam() instanceof Number || p.getParam() instanceof Boolean) {
                return p.toString();
            }
            return "\"" + p + "\"";
        }).collect(Collectors.toList());
        return formulaName + "(" + String.join((CharSequence)",", list) + ")";
    }

    @Override
    public void setCalcLevel(int level) {
        this.calcLevel = level;
    }

    @Override
    public int getCalcLevel() {
        return this.calcLevel;
    }

    @Override
    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    @Override
    public void setExceptionMsg(String exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }

    @Override
    public String getLogMsg() {
        return this.logMsg;
    }

    @Override
    public void setLogMsg(String logMsg) {
        this.logMsg = logMsg;
    }

    @Override
    public List<Object> formatParam() {
        ArrayList<Object> params = new ArrayList<Object>();
        this.getParamList().forEach(pitem -> {
            Object p = pitem.getParam();
            if (p instanceof StringExpr) {
                params.add(((StringExpr)p).getValue());
            } else if (p != null) {
                params.add(p.toString());
            } else {
                params.add("");
            }
        });
        return params;
    }

    public boolean iSParamCanAccExp(int index) {
        return false;
    }

    @Override
    public boolean isPeriodInFormula() {
        return this.periodInFormula;
    }

    @Override
    public void setPeriodInFormula(boolean periodInFormula) {
        this.periodInFormula = periodInFormula;
    }

    @Override
    public void setCellReference(String cellReference) {
        this.cellReference = cellReference;
    }

    @Override
    public String getCellReference() {
        return this.cellReference;
    }
}

