/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kd.fi.bcm.business.formula.model.IFormula;

public class FormulaPoolManager
implements Iterable<Map.Entry<String, List<IFormula>>> {
    private Map<String, List<IFormula>> pool = new ConcurrentHashMap<String, List<IFormula>>();
    private Map<String, Object> formulaMap = new HashMap<String, Object>();

    public void push(List<IFormula> formulas) {
        Objects.requireNonNull(formulas);
        formulas.forEach(f -> this.push((IFormula)f));
    }

    public void pushBatchFormula(List<IFormula> formulas) {
        Objects.requireNonNull(formulas);
        formulas.forEach(f -> {
            if (f.toString().indexOf("@") != -1) {
                this.push((IFormula)f);
            }
        });
    }

    public void push(IFormula formula) {
        this.check(formula.getName());
        this.pool.get(formula.getName()).add(formula);
    }

    public Map<String, Object> getFormulaMap() {
        if (this.formulaMap.isEmpty()) {
            this.pool.values().stream().forEach(formulas -> formulas.forEach(formula -> this.formulaMap.put(formula.getUUID(), formula.toString())));
        }
        return this.formulaMap;
    }

    private void check(String formulaName) {
        if (!this.pool.containsKey(formulaName)) {
            this.pool.put(formulaName, new ArrayList());
        }
    }

    public List<IFormula> pull(String formulaName) {
        return this.pool.get(formulaName);
    }

    @Override
    public Iterator<Map.Entry<String, List<IFormula>>> iterator() {
        return this.pool.entrySet().iterator();
    }

    public void clear() {
        this.pool.clear();
        this.formulaMap.clear();
    }

    public Stream<Map.Entry<String, List<IFormula>>> parallelStreamEntry() {
        return this.pool.entrySet().parallelStream();
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }
}

