/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.model.adjust;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class GetJLEntryFormula
extends Formula {
    public static final String MERGEFIELD = "merge";
    public static final String MERGESCOPEFIELD = "mergescope";
    public static final String DIMENSIONFIELD = "dimensionMem";
    public static final String COMPUTETYPEFIELD = "computetype";
    private int entityIndex = -1;
    private List<String> keyList;
    public String dimension;
    private Map<String, BigDecimal> aggScopeData = new HashMap<String, BigDecimal>(16);

    public void fillBack(Map<String, Object> result, Set<String> parentOrgScope) {
        if (CollectionUtils.isEmpty(parentOrgScope)) {
            return;
        }
        this.setValue(parentOrgScope.stream().map(parentOrg -> this.getAmount((String)parentOrg, result)).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private BigDecimal getAmount(String parentOrg, Map<String, Object> result) {
        String dimKeyStr = this.getKey(parentOrg);
        BigDecimal v = InvestUtils.convertToBigDecimal((Object)result.get(dimKeyStr));
        if (v == null) {
            return BigDecimal.ZERO;
        }
        this.aggScopeData.put(dimKeyStr, v);
        return v;
    }

    private String getKey(String parentOrg) {
        List<String> keyList = this.getKeyList();
        keyList.set(this.entityIndex, parentOrg);
        return Joiner.on((String)"|").join(keyList);
    }

    public List<String> getKeyList() {
        if (this.keyList == null) {
            this.keyList = new ArrayList<String>(16);
            String[] strs = null;
            int i = 0;
            for (String itemStr : this.dimension.split(",")) {
                strs = GetJLEntryFormula.splitDimAndMemb(itemStr);
                if ("E".equalsIgnoreCase(strs[0])) {
                    this.entityIndex = i;
                }
                this.keyList.add(strs[1]);
                ++i;
            }
        }
        return this.keyList;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public static String[] splitDimAndMemb(String param) {
        try {
            param = param.trim();
            int spiltFirstIndex = param.indexOf("[");
            if (spiltFirstIndex != -1) {
                int spiltLastIndex = param.lastIndexOf("]");
                spiltLastIndex = spiltLastIndex == -1 ? param.length() : spiltLastIndex;
                ArrayList<String> dotResult = new ArrayList<String>(6);
                dotResult.addAll(Arrays.asList(GetJLEntryFormula.splitDimAndMemb(param.substring(0, spiltFirstIndex))));
                dotResult.add(param.substring(spiltFirstIndex, spiltLastIndex).replaceAll("[\\[\\]]", ""));
                Arrays.stream(GetJLEntryFormula.splitDimAndMemb(param.substring(spiltLastIndex + 1))).filter(StringUtils::isNotEmpty).forEach(dotResult::add);
                return dotResult.toArray(new String[0]);
            }
            return param.trim().replaceAll("\\(+", ".").replaceAll("\\)+", "").split("\\.");
        }
        catch (Throwable t) {
            return new String[]{param};
        }
    }

    @Override
    public String getName() {
        return "GETJLENTRY";
    }

    @Override
    public void fillBack(Map<String, Object> result) {
    }

    @Override
    public String getKey() {
        return this.toString();
    }

    public String getAggScopeStr() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u805a\u5408\u8303\u56f4\u65e5\u5fd7\uff1a", (String)"GetJLEntryFormula_1", (String)"fi-bcm-business", (Object[])new Object[0]).concat(this.aggScopeData.toString());
    }
}

