/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.model.fidm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.disclosure.model.DataSetResult;
import kd.fi.bcm.business.disclosure.util.DataSetArrangeUtil;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.fidm.FidmCommonFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.sql.MDColumn;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class VSDmvFormula
extends FidmCommonFormula {
    private static final int DIMS_INDEX = 1;
    private static final int GROUPBY_INDEX = 3;
    private static final int ORDERBY_INDEX = 4;
    private static final int SEQ_INDEX = 5;
    private static final int TOP_INDEX = 6;

    public void fillBack(MDResultSet mdrs) {
        List result = null;
        List<String> selectList = VSDmvFormula.getNeedListByIndex(this.getShortNumber2Num(), this, 1);
        List<String> groupList = VSDmvFormula.getNeedListByIndex(this.getShortNumber2Num(), this, 3);
        List<String> orderList = VSDmvFormula.getNeedListByIndex(this.getShortNumber2Num(), this, 4);
        String isPositiveSequence = VSDmvFormula.getParam(this, 5);
        if (mdrs.isEmpty()) {
            this.setValue(new ArrayList());
            return;
        }
        if (CollectionUtils.isEmpty(groupList) && CollectionUtils.isEmpty(orderList)) {
            result = this.getResultByRow(mdrs);
            this.setValue(result.subList(0, this.getSqlTop(this, 6, result.size())));
            return;
        }
        List<DataSetResult> dataSets = null;
        DataSetArrangeUtil dsau = new DataSetArrangeUtil();
        if (CollectionUtils.isEmpty(groupList)) {
            dataSets = this.buildDataSetResult(selectList, orderList, mdrs);
        } else {
            dataSets = this.buildDataSetResult(groupList, orderList, mdrs);
            dataSets = dsau.groupbySum(dataSets);
        }
        if (!CollectionUtils.isEmpty(orderList)) {
            dsau.sort(isPositiveSequence, dataSets);
        }
        LinkedList<String> measureList = new LinkedList<String>();
        measureList.add(FacTabFieldDefEnum.FIELD_MONEY.getField());
        result = CollectionUtils.isEmpty(groupList) ? (List)dsau.getResultByDataSet(selectList, dataSets, -1, measureList) : (List)dsau.getResultByDataSet(groupList, dataSets, -1, measureList);
        this.setValue(result.subList(0, this.getSqlTop(this, 6, result.size())));
    }

    private Integer getSqlTop(VSDmvFormula formula, int topIndex, int length) {
        String top = VSDmvFormula.getParam(formula, topIndex);
        int topInt = Integer.parseInt(StringUtils.isEmpty((String)top) || "0".equals(top) ? String.valueOf(length) : top);
        return length < topInt ? length : topInt;
    }

    private List<Map<String, Object>> getResultByRow(MDResultSet rs) {
        Row[] rows;
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        LinkedHashMap<String, Object> map = null;
        List<MDColumn> metaDatas = rs.getMetaData().getMetaDatas();
        for (Row row : rows = rs.getRows()) {
            if (Objects.isNull(row)) continue;
            map = new LinkedHashMap<String, Object>(16);
            int moneyIndex = 0;
            for (MDColumn col : metaDatas) {
                if (FacTabFieldDefEnum.FIELD_MONEY.getField().equals(col.getMdName())) {
                    moneyIndex = col.getColIndex();
                } else {
                    map.put(col.getMdName(), row.getValue(col.getColIndex()));
                }
                if (FacTabFieldDefEnum.FIELD_MONEY.getField().equals(col.getMdName())) {
                    moneyIndex = col.getColIndex();
                    continue;
                }
                map.put(col.getMdName(), row.getValue(col.getColIndex()));
            }
            map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), row.getValue(moneyIndex));
            result.add(map);
        }
        return result;
    }

    public static List<String> getNeedListByIndex(Map<String, String> shortNumber2Num, Formula formula, int selectIndex) {
        LinkedList<String> needList = new LinkedList<String>();
        String dimAndMembers = VSDmvFormula.getParam(formula, selectIndex);
        if (StringUtils.isEmpty((String)dimAndMembers)) {
            return needList;
        }
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        if (selectIndex == 1) {
            String[] arrays = null;
            for (String s : dim2MemList) {
                arrays = VSDmvFormula.splitDimAndMemb(s);
                needList.add(shortNumber2Num.get(arrays[0]));
            }
        } else {
            for (String s : dim2MemList) {
                needList.add(shortNumber2Num.get(s));
            }
        }
        return needList;
    }

    @Override
    public String getName() {
        return "VS_DM_V";
    }

    public static String[] splitDimAndMemb(String param) {
        param = param.trim();
        int first = param.indexOf(46);
        String dim = param.substring(0, first);
        String member = param.substring(first + 1);
        return new String[]{dim, member};
    }

    public static String getParam(Formula f, int index) {
        ParamItem modelParam = (ParamItem)f.getParamList().get(index);
        String paramStr = " ";
        paramStr = modelParam.getParam() instanceof StringExpr ? ((StringExpr)modelParam.getParam()).getValue() : modelParam.getParam().toString();
        return paramStr;
    }

    @Override
    public void fillBack(Map<String, Object> result) {
    }

    @Override
    public String getKey() {
        return null;
    }

    public List<DataSetResult> buildDataSetResult(List<String> attrList, List<String> orderList, MDResultSet rs) {
        Row[] rows;
        LinkedList<DataSetResult> dsrs = new LinkedList<DataSetResult>();
        DataSetResult dsr = null;
        MDResultSetMetaData metaData = rs.getMetaData();
        for (Row row : rows = rs.getRows()) {
            int i;
            if (Objects.isNull(row)) continue;
            dsr = new DataSetResult();
            for (i = 0; i < attrList.size(); ++i) {
                dsr.addGroupList((String)row.getValue(metaData.getColIndex(attrList.get(i))));
            }
            for (i = 0; i < orderList.size(); ++i) {
                dsr.addOrderList((String)row.getValue(metaData.getColIndex(orderList.get(i))));
            }
            dsr.addMeasureList(String.valueOf(row.getValue(metaData.getColIndex(FacTabFieldDefEnum.FIELD_MONEY.getField()))));
            dsrs.add(dsr);
        }
        return dsrs;
    }
}

