/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.model.key;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.key.IPackKey;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import kd.fi.bcm.spread.util.CollectCalculateHelp;

public class PackKey
implements IPackKey {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(IPackKey.class);
    private List<String> bcmMems;
    private List<String> bcmDims;

    public PackKey(List<String> bcmMems, List<String> bcmDims) {
        this.bcmMems = bcmMems;
        this.bcmDims = bcmDims;
    }

    public void setBcmMems(List<String> bcmMems) {
        this.bcmMems = bcmMems;
    }

    public List<String> getKey(IFormula formula, Map glDimToBcmDim, HashMultimap glDimBcmMem2GlMems, Table param2BcmDim) {
        Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(formula.toString());
        ArrayList<String> result = new ArrayList<String>(16);
        ArrayList<List<String>> gls = new ArrayList<List<String>>(10);
        List glDims = (List)pair.p2;
        for (Object gl : glDims) {
            int index = this.bcmDims.indexOf(glDimToBcmDim.get(gl));
            if (index == -1) {
                throw new KDBizException("%s dim not in float.");
            }
            Set set = glDimBcmMem2GlMems.get((Object)((String)gl + "_-" + this.bcmMems.get(index)));
            ArrayList glMemList = Lists.newArrayList();
            glMemList.addAll(set);
            gls.add(glMemList);
        }
        List<String> bcmDimsByParams = CollectCalculateHelp.getBcmDimsByParams((Table<String, String, String>)param2BcmDim, (Map)pair.p1);
        if (!bcmDimsByParams.isEmpty()) {
            for (String bcmDimsByParam : bcmDimsByParams) {
                gls.add(Collections.singletonList(this.bcmMems.get(this.bcmDims.indexOf(bcmDimsByParam))));
            }
        }
        ArrayList<List<String>> descartes = new ArrayList<List<String>>();
        AnalysisFormulaUtil.descartes(gls, descartes, 0, new ArrayList<String>());
        for (List list : descartes) {
            result.add(String.join((CharSequence)"|", list));
        }
        return result;
    }

    @Override
    public List<String> getKeyByRes(IFormula formula, Map<String, String> glDimToBcmDim, HashMultimap<String, String> glDimBcmMem2GlMems, Object collects) {
        Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(formula.toString());
        List<Object> result = new ArrayList(16);
        ArrayList<List<String>> gls = new ArrayList<List<String>>(10);
        List glDims = (List)pair.p2;
        for (String gl : glDims) {
            int n = this.bcmDims.indexOf(glDimToBcmDim.get(gl));
            if (n == -1) {
                throw new KDBizException("%s dim not in float.");
            }
            Set glMemSet = glDimBcmMem2GlMems.get((Object)(gl + "_-" + this.bcmMems.get(n)));
            ArrayList glMemList = Lists.newArrayList();
            glMemList.addAll(glMemSet);
            gls.add(glMemList);
        }
        this.printLog(gls);
        if (this.checkByRes3(gls, collects)) {
            result = this.getResultByRes3(gls, collects);
        } else if (this.checkByRes2(gls, collects)) {
            result = this.getResultByRes2(gls, collects);
        } else {
            ArrayList<List<String>> descartes = new ArrayList<List<String>>();
            AnalysisFormulaUtil.descartes(gls, descartes, 0, new ArrayList<String>());
            for (List list : descartes) {
                result.add(String.join((CharSequence)"|", list));
            }
        }
        return result;
    }

    private List<String> getResultByRes2(List<List<String>> gls, Object collects) {
        Map collectsMap = (Map)collects;
        ArrayList<String> result = new ArrayList<String>(16);
        if (collectsMap.size() == 0) {
            result.add("Not_Found");
        } else {
            HashSet<String> gs0 = new HashSet<String>(16);
            HashSet<String> gs1 = new HashSet<String>(16);
            this.fillGs(gs0, gs1, null, collectsMap);
            List<String> glFilter0 = this.getGlFilter(gls.get(0), gs0);
            if (glFilter0.size() == 0) {
                result.add("Not_Found");
                return result;
            }
            List<String> glFilter1 = this.getGlFilter(gls.get(1), gs1);
            if (glFilter1.size() == 0) {
                result.add("Not_Found");
                return result;
            }
            for (int i = 0; i < glFilter0.size(); ++i) {
                for (int j = 0; j < glFilter1.size(); ++j) {
                    String tempKey = glFilter0.get(i) + "|" + glFilter1.get(j);
                    if (!collectsMap.containsKey(tempKey)) continue;
                    result.add(tempKey);
                }
            }
            if (result.size() == 0) {
                result.add("Not_Found");
            }
        }
        return result;
    }

    private boolean checkByRes2(List<List<String>> gls, Object collects) {
        if (gls.size() != 2) {
            return false;
        }
        if (!(collects instanceof Map)) {
            return false;
        }
        if (gls.get(0) == null || gls.get(1) == null) {
            return false;
        }
        return gls.get(0).size() * gls.get(1).size() >= 10000;
    }

    private List<String> getResultByRes3(List<List<String>> gls, Object collects) {
        Map collectsMap = (Map)collects;
        ArrayList<String> result = new ArrayList<String>(16);
        if (collectsMap.size() == 0) {
            result.add("Not_Found");
        } else {
            HashSet<String> gs0 = new HashSet<String>(16);
            HashSet<String> gs1 = new HashSet<String>(16);
            HashSet<String> gs2 = new HashSet<String>(16);
            this.fillGs(gs0, gs1, gs2, collectsMap);
            List<String> glFilter0 = this.getGlFilter(gls.get(0), gs0);
            if (glFilter0.size() == 0) {
                result.add("Not_Found");
                return result;
            }
            List<String> glFilter1 = this.getGlFilter(gls.get(1), gs1);
            if (glFilter1.size() == 0) {
                result.add("Not_Found");
                return result;
            }
            List<String> glFilter2 = this.getGlFilter(gls.get(2), gs2);
            if (glFilter2.size() == 0) {
                result.add("Not_Found");
                return result;
            }
            for (int i = 0; i < glFilter0.size(); ++i) {
                for (int j = 0; j < glFilter1.size(); ++j) {
                    for (int k = 0; k < glFilter2.size(); ++k) {
                        String tempKey = glFilter0.get(i) + "|" + glFilter1.get(j) + "|" + glFilter2.get(k);
                        if (!collectsMap.containsKey(tempKey)) continue;
                        result.add(tempKey);
                    }
                }
            }
            if (result.size() == 0) {
                result.add("Not_Found");
            }
        }
        return result;
    }

    private void fillGs(Set<String> gs0, Set<String> gs1, Set<String> gs2, Map collects) {
        for (Object key : collects.keySet()) {
            String keyStr = (String)key;
            String[] keyArr = keyStr.split("\\|");
            gs0.add(keyArr[0]);
            gs1.add(keyArr[1]);
            if (gs2 == null) continue;
            gs2.add(keyArr[2]);
        }
    }

    private List<String> getGlFilter(List<String> gl, Set<String> gs) {
        ArrayList<String> glFilter = new ArrayList<String>(16);
        for (String str : gl) {
            if (!gs.contains(str)) continue;
            glFilter.add(str);
        }
        return glFilter;
    }

    private boolean checkByRes3(List<List<String>> gls, Object collects) {
        if (gls.size() != 3) {
            return false;
        }
        if (!(collects instanceof Map)) {
            return false;
        }
        if (gls.get(0) == null || gls.get(1) == null || gls.get(2) == null) {
            return false;
        }
        return gls.get(0).size() * gls.get(1).size() * gls.get(2).size() >= 10000;
    }

    private void printLog(List<List<String>> gls) {
        StringBuilder sb = new StringBuilder(16);
        sb.append("getKey gls size is:");
        for (int i = 0; i < gls.size(); ++i) {
            sb.append(gls.get(i) == null ? "null" : Integer.valueOf(gls.get(i).size())).append(";");
        }
        log.info(sb.toString());
    }

    public List<String> getBcmMems() {
        return this.bcmMems;
    }

    public List<String> getBcmDims() {
        return this.bcmDims;
    }
}

